/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.BdbConnectionException;
import com.sleepycat.client.BdbServerAdmin;
import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SEnvironmentConfig;
import com.sleepycat.client.SslConfig;
import com.sleepycat.client.ThriftWrapper;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TEnvironment;
import com.sleepycat.thrift.TProtocolVersionTestResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class BdbServerConnection
implements RemoteCallHelper,
AutoCloseable {
    private final String host;
    private final int port;
    private BdbService.Client client;

    private BdbServerConnection(String string, int n) {
        this.host = Objects.requireNonNull(string, "host is null.");
        this.port = Objects.requireNonNull(Integer.valueOf(n), "port is null.");
    }

    BdbServerConnection(InputStream inputStream, OutputStream outputStream) {
        this.host = "test";
        this.port = 0;
        TCompactProtocol tCompactProtocol = new TCompactProtocol((TTransport)new TIOStreamTransport(inputStream, outputStream));
        this.client = new BdbService.Client((TProtocol)tCompactProtocol);
    }

    public static BdbServerConnection connect(String string, int n) throws SDatabaseException {
        return BdbServerConnection.connectSsl(string, n, null, 0);
    }

    public static BdbServerConnection connectSsl(String string, int n, SslConfig sslConfig, int n2) throws SDatabaseException {
        try {
            BdbServerConnection bdbServerConnection = new BdbServerConnection(string, n);
            bdbServerConnection.open(sslConfig, n2);
            return bdbServerConnection;
        }
        catch (TTransportException tTransportException) {
            String string2 = "Failed to connect to '" + string + ":" + n + "'";
            throw new BdbConnectionException(string2, tTransportException);
        }
    }

    private void open(SslConfig sslConfig, int n) throws TTransportException {
        TSocket tSocket;
        TSocket tSocket2;
        if (sslConfig == null) {
            tSocket2 = new TSocket(this.host, this.port);
            tSocket = new TFramedTransport((TTransport)tSocket2);
            tSocket.open();
        } else {
            tSocket = TSSLTransportFactory.getClientSocket((String)this.host, (int)this.port, (int)n, (TSSLTransportFactory.TSSLTransportParameters)sslConfig.getParameters());
        }
        tSocket2 = new TCompactProtocol((TTransport)tSocket);
        this.client = new BdbService.Client((TProtocol)tSocket2);
        TProtocolVersionTestResult tProtocolVersionTestResult = this.remoteCall(() -> this.client.isProtocolVersionSupported("1.0.0"));
        if (!tProtocolVersionTestResult.isSupported()) {
            throw new BdbConnectionException("Driver is not compatible with the server. The server requires drivers with protocol version: " + tProtocolVersionTestResult.serverProtocolVersion, null);
        }
    }

    public BdbServerAdmin adminService() {
        return new BdbServerAdmin(this.client);
    }

    public SEnvironment openEnvironment(String string, SEnvironmentConfig sEnvironmentConfig) throws IOException, SDatabaseException {
        return this.remoteCallWithIOException(() -> {
            TEnvironment tEnvironment = this.client.openEnvironment(string, ThriftWrapper.nullSafeGet(sEnvironmentConfig));
            return new SEnvironment(tEnvironment, string, this.client);
        });
    }

    @Override
    public void close() {
        this.client.getInputProtocol().getTransport().close();
    }
}

