// generated by Fast Light User Interface Designer (fluid) version 1.0110

#include <libintl.h>
#include "apps.h"
// (c) Robert Shingledecker 2008-2012
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <FL/fl_message.H>
#include <FL/Fl_File_Chooser.H>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <locale.h>
#include <unistd.h>
#include <string.h>
using namespace std;
static string tcedir, target_dir, last_dir; 
static string select_extn, select_results, select_extn_file; 
static string repository; 
static ifstream ifappserr; 
static string appserr,hilite; 
static int results, locales_set=0; 
static string mode, command, msg, mirror, err_extn; 
static string option_type, report_type, update_type; 
static string copy2fsList, copy2fsFlag, onbootName, onbootList, onbootTitle; 
static Fl_Text_Buffer *txtBuffer = new Fl_Text_Buffer; 
static void errhandler(const string &str); 

static void cursor_normal() {
  window->cursor(FL_CURSOR_DEFAULT);
Fl::flush();
}

static void cursor_wait() {
  Fl::redraw();
window->cursor(FL_CURSOR_WAIT);
Fl::flush();
}

static char * mygettext(const char *msgid) {
  if (!locales_set) {

setlocale(LC_ALL, "");
bindtextdomain("tinycore","/usr/local/share/locale");
textdomain("tinycore");

locales_set=1;

}

return gettext(msgid);
}

static void auditView() {
  grpBrowse->hide();
grpMulti->hide();
menuBarDepends->hide();
brwExtn->clear();
brwMulti->clear();
brwResults->clear();
boxExtn->label("Select");
boxResults->label("Results");
report_type.empty();
btnSingle->label("Add Item");
btnResults->label("Delete Item from list");
btnSingle->deactivate();
btnResults->deactivate();
btnSingle->hide();
btnResults->hide();
grpAudit->show();
grpSingle->show();
Fl::flush();
}

static void browseView() {
  grpAudit->hide();
menuBarDepends->hide();
grpMulti->hide();
grpBrowse->show();
Fl::flush();
}

void protectChr() {
  int p = 0;
int s = 0;
do
{
   p = select_extn.find("+",p+s);
   if ( p > 0 )
   {
      select_extn.replace(p,1,"\\+");
      s = 2;
   }
} while ( p > 0 );
}

void displayTabData() {
  txtBuffer->loadfile("");
FILE *pipe = popen(command.c_str(),"r");
char *mbuf = (char *)calloc(PATH_MAX,sizeof(char));
if (pipe)
{
   while(fgets(mbuf,PATH_MAX,pipe))
   {
      string line(mbuf);
      txtBuffer->append(line.c_str());
      Fl::flush();
   }
   pclose(pipe);
   free(mbuf);
}
}

void loadBrwExtnData() {
  brwExtn->clear();
FILE *pipe = popen(command.c_str(),"r");
char *mbuf = (char *)calloc(PATH_MAX,sizeof(char));
if (pipe)
{
   while(fgets(mbuf,PATH_MAX,pipe))
   {
      string line(mbuf);
      brwExtn->add(line.c_str());
      Fl::flush();
   }
   pclose(pipe);
   free(mbuf);
}
}

void loadBrwResultsData() {
  FILE *pipe = popen(command.c_str(),"r");
char *mbuf = (char *)calloc(PATH_MAX,sizeof(char));
if (pipe)
{
   while(fgets(mbuf,PATH_MAX,pipe))
   {
      string line(mbuf);
      brwResults->add(line.c_str());
      Fl::flush();
   }
   pclose(pipe);
   free(mbuf);
}
}

static void fetch_extension() {
  outputStatus->activate();
outputStatus->color(FL_WHITE);
outputStatus->value(command.c_str());
cursor_wait();
msg = select_extn;
command = "xterm -fg black -bg white -g 80x5 -e " + command;
system(command.c_str());

command = "busybox md5sum -cs " + select_extn + ".md5.txt";
results = system(command.c_str());

if (results == 0 )
{
  outputStatus->color(175);
  msg += + " OK.";
} else
  msg += " Failed.";
  
outputStatus->value(msg.c_str());  
cursor_normal();
}

static void builddb() {
  cursor_wait();
command = "tce-audit builddb " + target_dir +"/";
system(command.c_str());
string listfile = target_dir + "/tce.lst";
brwExtn->load(listfile.c_str());
brwExtn->remove(brwExtn->size());
brwResults->load("/tmp/audit_results.txt");
brwResults->remove(brwResults->size());
menu_nodepends->activate();
menu_notrequired->activate();
menu_auditall->activate();
menu_fetchmissing->activate();
menu_marked->activate();
menu_clearlst->activate();
boxResults->label("Results");
cursor_normal();
}

Fl_Double_Window *errwindow=(Fl_Double_Window *)0;

Fl_Box *errlabel=(Fl_Box *)0;

static void cb_Remove(Fl_Button*, void*) {
  string cmd = "rm -f " + err_extn + "*";

system(cmd.c_str());

fetch_extension();
errwindow->hide();
}

static void cb_Try(Fl_Button*, void*) {
  string cmd = "zsync " + mirror + "3.x/tcz/" + err_extn + ".zsync";

int ret = system(cmd.c_str());
ret = WEXITSTATUS(ret);

if (ret == 0) fetch_extension();
else {

	// If zsync also fails, it's a bad hair
	// day for the network. Nothing we can do.

	outputStatus->value("Zsync failed.");

	cmd = "rm -f " + err_extn + "*";

	system(cmd.c_str());
}

errwindow->hide();
}

static void cb_Cancel(Fl_Button*, void*) {
  errwindow->hide();
}

static void errhandler(const string &str) {
  { errwindow = new Fl_Double_Window(520, 125, mygettext("MD5SUM error"));
    { errlabel = new Fl_Box(162, 25, 195, 30, mygettext("Md5sum error on"));
    } // Fl_Box* errlabel
    { Fl_Button* o = new Fl_Button(15, 70, 160, 35, mygettext("Remove and try again"));
      o->callback((Fl_Callback*)cb_Remove);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(200, 70, 160, 35, mygettext("Try to finish download"));
      o->callback((Fl_Callback*)cb_Try);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(385, 70, 115, 35, mygettext("Cancel"));
      o->callback((Fl_Callback*)cb_Cancel);
    } // Fl_Button* o
    errwindow->end();
  } // Fl_Double_Window* errwindow
  errlabel->label(str.c_str());

err_extn = str;
err_extn.replace(0,9,""); // Yes, hardcoded magic value. Bad.

errwindow->show();
}

static void menuCB(Fl_Widget *, void* userdata) {
  const string userdatastr = userdata ? (char *) userdata : "";

report_type = (const char*)userdata;
if (userdatastr == "tcz")
{
   browseView();
   mode = "tcz";
   tabs->deactivate();
   txtBuffer->loadfile("");
   repository = (const char*) userdata;
   cursor_wait();
   unlink("info.lst");
   command = "tce-fetch.sh info.lst.gz";
   int results = system(command.c_str());
   cursor_normal();
   if (results == 0 )
   {
      system("gunzip -c info.lst.gz > info.lst");
      brwSelect->load("info.lst");
      brwSelect->remove(brwSelect->size());
      btnGo->deactivate();
      boxSelect->label("Select Remote Extension");
      boxSelect->activate();
      search_choices->activate();
      search_field->activate();                                              
    } else
      fl_message("Error, check network, mirror or writable extension directory.");
      
} else if (userdatastr == "LoadLocal" )
{
  auditView();
  btnSingle->label("Load");
  btnSingle->show();
  btnResults->hide();
  boxExtn->label("Select Local Extension");
  cursor_wait();
  command = "tce-status -u | sort -f";
  loadBrwExtnData();
  cursor_normal();
  
} else if (userdatastr == "onboot" )
{
  auditView();
  btnSingle->show();
  btnResults->show();
  target_dir = tcedir + "/optional/";
  cursor_wait();
  
  command = "ondemand -l";
  loadBrwExtnData();  
  
  onbootTitle = "On Boot Items (" + onbootName +")";
  boxResults->label(onbootTitle.c_str());
  brwResults->load(onbootList.c_str());
  brwResults->remove(brwResults->size());
  
  cursor_normal();
} else if (userdatastr == "ondemand" )
{
  auditView();
  btnSingle->show();
  btnResults->show();
  cursor_wait();
  command = "ondemand -lt";
  loadBrwExtnData();  
  
  boxResults->label("Current OnDemand Items");
  command = "ondemand -ct | sort -f";
  loadBrwResultsData();
  cursor_normal();
} else if (userdatastr == "md5s") 
{
   auditView();
   grpSingle->hide();
   btnMulti->deactivate();
   grpMulti->show();
   boxExtn->label("Select Md5s");
   Fl::flush();
   cursor_wait();
   command = "cd " + target_dir + " && ls *.md5.txt | sort -f > /tmp/apps_upd.lst";
   system(command.c_str());
   brwMulti->load("/tmp/apps_upd.lst");
   brwMulti->remove(brwMulti->size());
   cursor_normal();

} else if (userdatastr == "updates") 
{
   string line;
   auditView();
   boxExtn->label("Select Updates");
   grpSingle->hide();
   btnMulti->deactivate();
   grpMulti->show();
   Fl::flush();
   cursor_wait();

   brwResults->clear();
   command = "version -c";
   loadBrwResultsData();
   brwResults->add("Please Standby... Now checking your extensions.");

   command = "tce-update list " + target_dir;
   FILE *pipe = popen(command.c_str(),"r");
   char *mbuf = (char *)calloc(PATH_MAX,sizeof(char));
   if (pipe)
   {
      while(fgets(mbuf,PATH_MAX,pipe))
      {
         string line(mbuf);
         if (line.find("Error ") == string::npos ) {
            brwMulti->add(line.c_str());
            brwMulti->bottomline(brwMulti->size());
         } else { 
            brwResults->add(line.c_str());
            brwResults->bottomline(brwResults->size());
         }
         Fl::flush();
      }
      pclose(pipe);
      free(mbuf);
   }
   brwResults->add("Scan for updates completed.");    
   if ( brwMulti->size() >= 1 )
      btnMulti->deactivate();
   else {
      if ( brwResults->size() == 1 )
         brwResults->add("Extensions are current. No updates required.");
   }
   cursor_normal();
   Fl::flush(); 
   
   
} else if (userdatastr == "orphans") 
{
   string line;
   auditView();
   cursor_wait();
   brwResults->clear();

   command = "tce-status -o";
   loadBrwResultsData();
   brwResults->add("Scan for orphans complete.");    
   cursor_normal();
   Fl::flush();      
      
} else if (userdatastr == "unneeded") 
{
   string line;
   auditView();
   cursor_wait();
   brwResults->clear();

   command = "chkonboot.sh";
   loadBrwResultsData();
   cursor_normal();
   Fl::flush();      
      
} else if (userdatastr == "copy2fs")
{
   auditView();
   command = "ls "+ copy2fsFlag + " >/dev/null 2>&1";
   int results = system(command.c_str());
   if (results == 0)
   {
     command = "rm -f "+ copy2fsFlag;
     system(command.c_str());
     boxResults->label("copy2fs.flg removed.");
   } else
   {  
     command = "touch " + tcedir + "/copy2fs.flg";
     system(command.c_str());
     boxResults->label("copy2fs.flg set");
   }
} else if (userdatastr == "SelectiveCopy") 
{
   auditView();
   btnSingle->show();
   btnResults->show();
   boxExtn->label("Select to Copy");
   command = "ls " + target_dir + "|grep -E .tcz$ ";
   loadBrwExtnData();
   
   brwResults->load(copy2fsList.c_str());
   brwResults->remove(brwResults->size());
   boxResults->label("Current copy2fs.lst");
   option_type = (const char*) userdata;
   
} else if (userdatastr == "menuDepends")
  {
    auditView();
    mode = "depends";
    btnSingle->hide();
    btnResults->hide();
    grpMulti->hide();
    brwExtn->show();
    menuBarApps->hide();
    builddb();
    menu_dependson->deactivate();
    menu_requiredby->deactivate();
    menu_missing->deactivate();
    menu_delete->deactivate();
    menuBarDepends->show();
    
} else if (userdatastr == "quit")
  {
    if ( last_dir.compare(0,8,"/tmp/tce") != 0 )
    {
      ofstream last_dir_fout("/opt/.appbrowser",ios::out|ios::out);
      if ( last_dir_fout.is_open())
      {
        last_dir_fout << last_dir << endl;
        last_dir_fout.close();
      }
    }  
    command = "quit\n";
    unlink("info.lst");
    unlink("info.lst.gz");
    unlink("/tmp/tags.lst");
    exit(0);

  }
}

static void btnCB(Fl_Widget *, void* userdata) {
  const string userdatastr = userdata ? (char *) userdata : "";

if (userdatastr == "go")
{
   outputStatus->value("");
   outputStatus->label("Status");
   int action = install_choices->value();
   string action_type;
   switch(action)
   {
      case 0 : action_type="wi";
               break;
      case 1 : action_type="wo";
               break;
      case 2 : action_type="wil";
               break;
      case 3 : action_type="w";
               break;
      default: mode="w";
   }
   command = "tce-load -" + action_type + " " + select_extn;
   fetch_extension();
} else if (userdatastr == "setdrive")
{
   cursor_wait();
   command = "tce-setdrive -l";
   int results = system(command.c_str());
   cursor_normal();
   if (results == 0 )
   {
      mode = "setdrive";
      brwSelect->load("/tmp/tcesetdev");
      brwSelect->remove(brwSelect->size());
      boxSelect->label("Select for TCE dir.");
      boxSelect->activate();
      unlink("/tmp/tcesetdev");
   } else
     fl_message("No available drives found!");
     
} else if (userdatastr == "search")
{
  if (search_choices->text() == string("Search"))
     command = "search.sh";
  else if (search_choices->text() == string("Tags"))
     command = "search.sh -t";
  else
     command = "provides.sh";
  tabs->deactivate();
  txtBuffer->loadfile("");
  brwSelect->load(""); 
  cursor_wait();
  command = command + " " + (string)search_field->value();
  FILE *pipe = popen(command.c_str(),"r");
  char *mbuf = (char *)calloc(PATH_MAX,sizeof(char));
  if (pipe)
  {
     while(fgets(mbuf,PATH_MAX,pipe))
     {
        string line(mbuf);
        line = line.substr(0,line.length()-1);
        brwSelect->add(line.c_str());
        brwSelect->bottomline(brwSelect->size());
        Fl::flush();
     }
     pclose(pipe);
     free(mbuf);
  }
  search_field->value("");
  cursor_normal();
  btnGo->deactivate();
  search_choices->activate();
  search_field->activate();                                              
      
}
}

static void brwSelectCB(Fl_Widget *, void *) {
  if (brwSelect->value())
{
   select_extn = brwSelect->text(brwSelect->value());
   if ( mode == "tcz" )
   {
      string select_extn_file = select_extn + (string)".info";
      command = "tce-fetch.sh " + select_extn_file;
      int results = system(command.c_str());
      if (results == 0)
      {
         txtBuffer->loadfile(select_extn_file.c_str());

         unlink(select_extn_file.c_str());
         btnGo->activate();
         
         tabs->activate();
         infoTab->activate();
         filesTab->activate();
         dependsTab->activate();
         sizeTab->activate();
         infoTab->show();
      } 
   }
   if ( mode == "mirror" )
   {
     mirror = select_extn;
     outURI->value(mirror.c_str());
     ofstream fout("/opt/tcemirror", ios::out|ios::out);
     if (! fout.is_open())
     {
       cerr << "Can't open /opt/tcemirror for output!" << endl;
       exit(EXIT_FAILURE);
     }
     fout << mirror << endl;
     fout.close();      
   }
   if ( mode == "setdrive" )
   {
      command = "tce-setdrive -s " + select_extn;
      int results = system(command.c_str());
      if (results == 0)
      {
         target_dir = select_extn + "/tce";
         brwSelect->clear();
         boxSelect->label("");
         target_dir += "/optional";
         outputStatus->color(FL_WHITE);
         outputStatus->value((target_dir).c_str());
         btn_tce->deactivate();         
      }
   }
}
}

static void mirrorCB(Fl_Widget*, void*) {
  mode = "mirror";
browseView();
tabs->deactivate();
search_choices->deactivate();
search_field->deactivate();
system("cat /opt/localmirrors /usr/local/share/mirrors > /tmp/mirrors 2>/dev/null");
brwSelect->load("/tmp/mirrors");
if ( brwSelect->size() == 1)
  fl_message("Must load mirrors.tcz extension or have /opt/localmirrors in order to use this feature.");
else {
   brwSelect->remove(brwSelect->size());
   boxSelect->label("Select Mirror");
   boxSelect->activate();
}
}

static void tabsGroupCB(Fl_Widget*, void*) {
  if (brwSelect->value())
{
   cursor_wait();
   select_extn = brwSelect->text(brwSelect->value());
   
   if (infoTab->visible())
   {
     select_extn_file = select_extn + (string)".info";
     command = "tce-fetch.sh -O " + select_extn_file;
     displayTabData();
   }
   
   if (filesTab->visible())
   {
     select_extn_file = select_extn + (string)".list";
     command = "tce-fetch.sh -O " + select_extn_file;
     displayTabData();
   }
   
   if (dependsTab->visible())
   {
     select_extn_file = select_extn + (string)".tree";
     command = "tce-fetch.sh -O " + select_extn_file;
     displayTabData();
   }
   if (sizeTab->visible())
   {
     command = "tce-size " + select_extn;
     displayTabData();
   }
   cursor_normal();
}
}

void dependsCB(Fl_Widget *, void* userdata) {
  const string userdatastr = userdata ? (char *) userdata : "";

option_type = "";
report_type = (const char*) userdata;
btnResults->hide();

if (userdatastr == "updatedeps")
{
   cursor_wait();
   command = "tce-audit updatedeps " + target_dir +"/";
   system(command.c_str());
   cursor_normal();
} else if (userdatastr == "builddb")
{
   cursor_wait();
   builddb();
   cursor_normal();
} else if (userdatastr == "dependson" or userdatastr == "requiredby" or userdatastr == "audit") 
{
   string loadit = "tce-audit " + report_type + " " + target_dir + "/" + select_extn;
   int results = system(loadit.c_str());
   if (results == 0 )
   {
      brwResults->load("/tmp/audit_results.txt");
      brwResults->remove(brwResults->size());
   } else {
      fl_message("error detected!");
   }
} else if (userdatastr == "auditall" or userdatastr == "nodepends" or userdatastr == "notrequired")
{
   cursor_wait();
   boxResults->label("Results");
   menu_delete->deactivate();
   menu_dependson->deactivate();
   menu_requiredby->deactivate();
   menu_missing->deactivate();
   command = "tce-audit " + report_type + " " + target_dir + "/";
   int results = system(command.c_str());
   if (results == 0 )
   {
      brwResults->load("/tmp/audit_results.txt");
      brwResults->remove(brwResults->size());
   } else {
      ifstream ifappserr("/tmp/appserr");
      msg = "Error: ";
      getline(ifappserr,appserr);
      while (ifappserr) 
      {
         msg = msg + appserr + "\n";
         getline(ifappserr,appserr);
      }
      ifappserr.close();
      fl_message(msg.c_str());
   }
   cursor_normal();
} else if (userdatastr == "fetchmissing")
{
   cursor_wait();
   brwResults->clear();
   command = "tce-audit fetchmissing";
   FILE *pipe = popen(command.c_str(),"r");
   char *mbuf = (char *)calloc(PATH_MAX,sizeof(char));
   if (pipe)
   {
      brwResults->clear();
      while(fgets(mbuf,PATH_MAX,pipe))
      {
         string line(mbuf);
         if (line.find("Error ") == string::npos )
            hilite = "";
         else
            hilite = "@B17";
         brwResults->add((hilite + line).c_str());
         brwResults->bottomline(brwResults->size());
         Fl::flush();
      }
      pclose(pipe);
      free(mbuf);
   }
   if ( brwResults->size() == 0 )
      brwResults->add("Dependency check complete. No missing dependencies found.");
   else
      brwResults->add("Missing dependencies fetch completed.");    

   cursor_normal();
} else if (userdatastr == "delete")
{
   protectChr();
   command = "tce-audit " + report_type + " " + target_dir + "/" + "\""+ select_extn + "\"";
   int results = system(command.c_str());
   if (results == 0 )
   {
      brwResults->load("/tmp/audit_results.txt");
      brwResults->remove(brwResults->size());
   } else {
      fl_message("error detected!");
   }
} else if (userdatastr == "display_marked")
{
     boxResults->label("Results");
     brwResults->load("/tmp/audit_marked.lst");
     brwResults->remove(brwResults->size());
} else if (userdatastr == "clearlst")
{
     command = "tce-audit " + report_type + " " + target_dir + "/" + select_extn;
     int results = system(command.c_str());
     if (results == 0 )
     { 
        brwResults->clear();
        boxResults->label("Marked for deletion cleared");
     }
} else if (userdatastr == "exit_depends")
{

    menuBarDepends->hide();
    brwExtn->clear();
    brwResults->clear();
    boxResults->label("Results");
    menuBarApps->show();
    btnSingle->show();
    btnResults->show();    mode="";
    Fl::flush();
}

menu_dependson->deactivate();
menu_requiredby->deactivate();
menu_missing->deactivate();
menu_delete->deactivate();
brwExtn->deselect();
}

void brwExtnCB(Fl_Widget *, void *) {
  if (brwExtn->value())
{
  select_extn =brwExtn->text(brwExtn->value());
  if ( mode == "depends" )
  {
    boxResults->label(select_extn.c_str());
    menu_dependson->activate();
    menu_requiredby->activate();
    menu_missing->activate();
    menu_delete->activate();
    brwResults->clear();
  } else
      btnSingle->activate();
      
  brwResults->deselect();
  btnResults->deactivate();
}
}

void btnSingleCB(Fl_Widget *, void *) {
  if (brwExtn->value())
{
   select_extn =brwExtn->text(brwExtn->value());
   bool not_duplicate = true;
   for ( int x=1; x <= brwResults->size(); x++ ) {
     if (!strcmp(brwResults->text(x),select_extn.c_str())) {
       not_duplicate = false;
     }
   }
   if ( option_type == "SelectiveCopy" && not_duplicate )
   {
     select_extn = select_extn.substr(0, select_extn.length()-1);
     command = "echo " + select_extn + " >> " + copy2fsList;
     system(command.c_str());
     brwResults->load(copy2fsList.c_str());
     brwResults->remove(brwResults->size());
   }
   if ( report_type == "onboot" && not_duplicate )
   {
     cursor_wait();
     select_extn = select_extn.substr(0, select_extn.length()-1);
     command = "echo " + select_extn + " >> " + onbootList;
     results = system(command.c_str());
     if (results == 0 )
     {
        brwExtn->remove(brwExtn->value());
        boxResults->label(onbootTitle.c_str());
        brwResults->load(onbootList.c_str());
        brwResults->remove(brwResults->size());
     }
     cursor_normal();
   }
      
   if ( report_type == "ondemand" )
   {
     cursor_wait();
     boxResults->label("Current OnDemand Items");
     command = "ondemand " + select_extn;
     results = system(command.c_str());
     if ( results == 0 ) 
     {
       brwExtn->remove(brwExtn->value());
       command = "ls -1 " + tcedir + "/ondemand | grep -v \".img$\" | sort -f";
       brwResults->clear();
       loadBrwResultsData();
     }
     cursor_normal();
   }
   
   if (report_type == "LoadLocal" )
   {
      command = "tce-load -i " + select_extn;
      loadBrwResultsData();
      msg = brwResults->text(brwResults->size());
      msg = msg.substr(msg.length()-3,2);
      if ( msg == "OK" )
      {
         brwExtn->remove(brwExtn->value());
         btnResults->deactivate();
      }
   }
}
btnSingle->deactivate();
brwExtn->deselect();
}

void brwMultiCB(Fl_Widget *, void *) {
  btnMulti->activate();
cursor_wait();
brwResults->clear();
if ( report_type == "updates" ) { 
   for (int t=0; t<=brwMulti->size(); t++) {
      if (brwMulti->selected(t) ) {
         select_extn = brwMulti->text(t);
         
         select_extn_file = select_extn.substr(0,select_extn.size()-1);
         select_extn_file += ".info";
         command = "tce-fetch.sh -O " + select_extn_file;
         loadBrwResultsData();           
         continue;
      }
   }
}
cursor_normal();
}

void btnMultiCB(Fl_Widget *, void *) {
  btnMulti->deactivate();
cursor_wait();
brwResults->clear();
for ( int t=0; t<=brwMulti->size(); t++ )
{
   if ( brwMulti->selected(t) )
   {
      select_extn = brwMulti->text(t);
      if ( report_type == "md5s" )
      {
         command = "cd " + target_dir +"/ && busybox md5sum -c " + select_extn + "> /dev/null";
         results = system(command.c_str());
         if ( results == 0 ) {
            msg = " OK";
            hilite = "";
         } else {
            msg = " FAILED";
            hilite = "@B17";
         }   
             
         brwResults->add((hilite + select_extn + msg).c_str());
         Fl::flush();      
      
      } else {
         brwResults->add(("Fetching " + select_extn).c_str());       
         string md5_file(select_extn,0,select_extn.size()-1);
         md5_file = md5_file + ".md5.txt";
         command = "tce-update update " + target_dir +"/" + md5_file;
         loadBrwResultsData();
         
      }
   }
}
brwMulti->deselect();
if (report_type == "md5s" )
   brwResults->add("Md5 checking complete.");
if (report_type == "updates" )
   brwResults->add("Updates complete. Reboot to effect.");
cursor_normal();
}

void brwResultsCB(Fl_Widget *, void *) {
  if (brwResults->value())
{
  btnResults->deactivate();
  if ( report_type == "ondemand" or report_type == "onboot" or report_type == "SelectiveCopy" or report_type == "delete" or report_type == "display_marked" )
  {
     btnResults->show();
     btnResults->activate();
  }
  brwExtn->deselect();
  btnSingle->deactivate();
}
}

void btnResultsCB(Fl_Widget *, void *) {
  if (brwResults->value())
{
   select_results = brwResults->text(brwResults->value());
   if ( option_type == "SelectiveCopy" )
   {
     command = "sed -i '/" + select_results + "/d' " + copy2fsList;
     system(command.c_str());
     brwResults->load(copy2fsList.c_str());
     brwResults->remove(brwResults->size());
   }
   if (report_type == "delete" or report_type == "display_marked")
   {
     string target = select_results.substr(select_results.find_last_of("/")+1);
     command = "sed -i '/" + target + "/d' /tmp/audit_marked.lst";
     system(command.c_str());
     brwResults->load("/tmp/audit_marked.lst");
     brwResults->remove(brwResults->size());
   }
   if (report_type == "onboot")
   {
     cursor_wait();  
     command = "sed -i '/" + select_results + "/d' " + onbootList;
     system(command.c_str());
     brwResults->load(onbootList.c_str());
     brwResults->remove(brwResults->size());
     
     target_dir = tcedir + "/optional/";
     command = "ondemand -l ";
     loadBrwExtnData();
     cursor_normal();
   }  

   if (report_type == "ondemand")
   {
     cursor_wait();  
     command = "ondemand -r " + select_results;
     system(command.c_str());   
     command = "ondemand -l ";
     loadBrwExtnData();
     brwResults->clear();       
     command = "ondemand -ct";
     loadBrwResultsData();
     cursor_normal();
   }  
}
btnResults->deactivate();
}

void mirrorpicker() {
  system("mirrorpicker");

// reload mirror
ifstream mirror_fin("/opt/tcemirror");
getline(mirror_fin,mirror);
mirror_fin.close();
}

Fl_Double_Window *window=(Fl_Double_Window *)0;

Fl_Menu_Bar *menuBarApps=(Fl_Menu_Bar *)0;

static void cb_Select(Fl_Menu_*, void*) {
  mirrorpicker();
outURI->value(mirror.c_str());
}

Fl_Menu_Item menu_menuBarApps[] = {
 {mygettext("Apps"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Cloud (Remote)"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Browse"), 0,  (Fl_Callback*)menuCB, (void*)("tcz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Select Mirror"), 0,  (Fl_Callback*)mirrorCB, (void*)("mirror"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Select fastest mirror"), 0,  (Fl_Callback*)cb_Select, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {mygettext("Load App Locally"), 0,  (Fl_Callback*)menuCB, (void*)("LoadLocal"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Maintenance"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Md5 Checking"), 0,  (Fl_Callback*)menuCB, (void*)("md5s"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Check for Updates"), 0,  (Fl_Callback*)menuCB, (void*)("updates"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Check for Orphans"), 0,  (Fl_Callback*)menuCB, (void*)("orphans"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Dependencies And Deletions"), 0,  (Fl_Callback*)menuCB, (void*)("menuDepends"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Check Onboot Unneeded"), 0,  (Fl_Callback*)menuCB, (void*)("unneeded"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("OnBoot Maintenance"), 0,  (Fl_Callback*)menuCB, (void*)("onboot"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("OnDemand Maintenance"), 0,  (Fl_Callback*)menuCB, (void*)("ondemand"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {mygettext("Installation Options"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Toggle Default Install to File System Flag"), 0,  (Fl_Callback*)menuCB, (void*)("copy2fs"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Selective Copy Install to File System"), 0,  (Fl_Callback*)menuCB, (void*)("SelectiveCopy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {mygettext("Quit"), 0,  (Fl_Callback*)menuCB, (void*)("quit"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Bar *menuBarDepends=(Fl_Menu_Bar *)0;

Fl_Menu_Item menu_menuBarDepends[] = {
 {mygettext("Dependencies"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Update .dep files."), 0,  (Fl_Callback*)dependsCB, (void*)("updatedeps"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Build Reporting Database"), 0,  (Fl_Callback*)dependsCB, (void*)("builddb"), 128, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Missing Dependencies Reporting"), 0,  (Fl_Callback*)dependsCB, (void*)("auditall"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Fetch Missing Dependencies"), 0,  (Fl_Callback*)dependsCB, (void*)("fetchmissing"), 128, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Display All with No Dependencies"), 0,  (Fl_Callback*)dependsCB, (void*)("nodepends"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Display All Not Depended On"), 0,  (Fl_Callback*)dependsCB, (void*)("notrequired"), 128, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("List Dependencies"), 0,  (Fl_Callback*)dependsCB, (void*)("dependson"), 1, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("List Required By"), 0,  (Fl_Callback*)dependsCB, (void*)("requiredby"), 1, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("List Missing Dependencies"), 0,  (Fl_Callback*)dependsCB, (void*)("audit"), 129, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Mark for Deletion"), 0,  (Fl_Callback*)dependsCB, (void*)("delete"), 1, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Display Marked for Deletion"), 0,  (Fl_Callback*)dependsCB, (void*)("display_marked"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Clear Marked for Deletion"), 0,  (Fl_Callback*)dependsCB, (void*)("clearlst"), 128, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Exit Dependency Check"), 0,  (Fl_Callback*)dependsCB, (void*)("exit_depends"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Group *grpBrowse=(Fl_Group *)0;

Fl_Group *grpSearch=(Fl_Group *)0;

Fl_Choice *search_choices=(Fl_Choice *)0;

Fl_Menu_Item menu_search_choices[] = {
 {mygettext("Search"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Provides"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Tags"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Input *search_field=(Fl_Input *)0;

Fl_Box *boxSelect=(Fl_Box *)0;

Fl_Browser *brwSelect=(Fl_Browser *)0;

Fl_Tabs *tabs=(Fl_Tabs *)0;

Fl_Group *infoTab=(Fl_Group *)0;

Fl_Text_Display *infoDisplay=(Fl_Text_Display *)0;

Fl_Group *filesTab=(Fl_Group *)0;

Fl_Text_Display *filesDisplay=(Fl_Text_Display *)0;

Fl_Group *dependsTab=(Fl_Group *)0;

Fl_Text_Display *dependsDisplay=(Fl_Text_Display *)0;

Fl_Group *sizeTab=(Fl_Group *)0;

Fl_Text_Display *sizeDisplay=(Fl_Text_Display *)0;

Fl_Choice *install_choices=(Fl_Choice *)0;

Fl_Menu_Item menu_install_choices[] = {
 {mygettext("OnBoot"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("OnDemand"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Download + Load"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {mygettext("Download Only"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Button *btnGo=(Fl_Button *)0;

Fl_Output *outputStatus=(Fl_Output *)0;

Fl_Button *btn_tce=(Fl_Button *)0;

Fl_Output *outURI=(Fl_Output *)0;

Fl_Group *grpAudit=(Fl_Group *)0;

Fl_Box *boxExtn=(Fl_Box *)0;

Fl_Group *grpSingle=(Fl_Group *)0;

Fl_Browser *brwExtn=(Fl_Browser *)0;

Fl_Button *btnSingle=(Fl_Button *)0;

Fl_Box *boxResults=(Fl_Box *)0;

Fl_Group *grpMulti=(Fl_Group *)0;

Fl_Browser *brwMulti=(Fl_Browser *)0;

Fl_Button *btnMulti=(Fl_Button *)0;

Fl_Browser *brwResults=(Fl_Browser *)0;

Fl_Button *btnResults=(Fl_Button *)0;

Fl_Output *outTCE=(Fl_Output *)0;

int main(int argc, char **argv) {
  setlocale(LC_ALL, "");
bindtextdomain("tinycore", "/usr/local/share/locale");
textdomain("tinycore");

ifstream mirror_fin("/opt/tcemirror");
getline(mirror_fin,mirror);
mirror_fin.close();


char buffer[1024];
int length;
chdir("/etc/sysconfig");
length = readlink("tcedir", buffer, sizeof(buffer));
buffer[length] = '\0';
chdir(buffer); // we go there to more easily handle errors (delete, zsync)
tcedir = get_current_dir_name();

target_dir = tcedir + "/optional";
last_dir = target_dir;   
ifstream last_dir_file("/opt/.appbrowser");
if ( last_dir_file.is_open() )
{
   getline(last_dir_file,last_dir);
   last_dir_file.close();
}

copy2fsList = tcedir + "/copy2fs.lst";
copy2fsFlag = tcedir + "/copy2fs.flg";

string cmdline, target_boot_option;
ifstream proc_cmdline("/proc/cmdline");
getline(proc_cmdline, cmdline);
proc_cmdline.close();
target_boot_option = "lst=";
int sloc = cmdline.find(target_boot_option);
if ( sloc == string::npos ) {
   onbootName = "onboot.lst";
} else {
   int eloc = cmdline.find(" ",sloc);
   int work = eloc - (sloc + target_boot_option.length());
   onbootName = cmdline.substr(sloc+target_boot_option.length(),work);
}

onbootList = tcedir + "/" + onbootName;

chdir(target_dir.c_str()); // we go there to more easily handle errors (delete, zsync)

// first run?
if (access("../firstrun", F_OK)) {
	creat("../firstrun", S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
	if (fl_ask("First run - would you like the system to pick the fastest mirror?") == 1)
		mirrorpicker();
}


// Test writable 
string testfile = "test.test";
ofstream writest(testfile.c_str());
if (writest.fail()) {
   fl_message("Fatal Error: TCE Directory is not writable.");
   exit(1);
}
writest.close();
unlink(testfile.c_str());
  { window = new Fl_Double_Window(690, 428, mygettext("Apps: Regular Applications (tcz)"));
    window->callback((Fl_Callback*)menuCB, (void*)("quit"));
    { menuBarApps = new Fl_Menu_Bar(5, 7, 55, 20);
      menuBarApps->menu(menu_menuBarApps);
    } // Fl_Menu_Bar* menuBarApps
    { menuBarDepends = new Fl_Menu_Bar(5, 7, 120, 20);
      menuBarDepends->hide();
      menuBarDepends->menu(menu_menuBarDepends);
    } // Fl_Menu_Bar* menuBarDepends
    { grpBrowse = new Fl_Group(0, -1, 695, 426);
      { grpSearch = new Fl_Group(65, 7, 620, 20);
        { search_choices = new Fl_Choice(68, 7, 93, 20);
          search_choices->down_box(FL_BORDER_BOX);
          search_choices->deactivate();
          search_choices->menu(menu_search_choices);
        } // Fl_Choice* search_choices
        { search_field = new Fl_Input(165, 7, 520, 20);
          search_field->labeltype(FL_NO_LABEL);
          search_field->callback((Fl_Callback*)btnCB, (void*)("search"));
          search_field->when(FL_WHEN_ENTER_KEY);
          search_field->deactivate();
          Fl_Group::current()->resizable(search_field);
        } // Fl_Input* search_field
        grpSearch->end();
      } // Fl_Group* grpSearch
      { boxSelect = new Fl_Box(45, 31, 120, 16);
        boxSelect->deactivate();
      } // Fl_Box* boxSelect
      { brwSelect = new Fl_Browser(5, 52, 200, 325);
        brwSelect->type(2);
        brwSelect->textfont(4);
        brwSelect->callback((Fl_Callback*)brwSelectCB);
      } // Fl_Browser* brwSelect
      { tabs = new Fl_Tabs(210, 27, 475, 350);
        tabs->callback((Fl_Callback*)tabsGroupCB);
        { infoTab = new Fl_Group(210, 52, 475, 325, mygettext("Info"));
          infoTab->when(FL_WHEN_CHANGED);
          infoTab->hide();
          infoTab->deactivate();
          { infoDisplay = new Fl_Text_Display(215, 57, 470, 318);
            infoDisplay->textfont(4);
            infoDisplay->buffer(txtBuffer);
          } // Fl_Text_Display* infoDisplay
          infoTab->end();
        } // Fl_Group* infoTab
        { filesTab = new Fl_Group(210, 52, 475, 325, mygettext("Files"));
          filesTab->when(FL_WHEN_CHANGED);
          filesTab->deactivate();
          { filesDisplay = new Fl_Text_Display(215, 52, 470, 323);
            filesDisplay->textfont(4);
            filesDisplay->buffer(txtBuffer);
          } // Fl_Text_Display* filesDisplay
          filesTab->end();
        } // Fl_Group* filesTab
        { dependsTab = new Fl_Group(210, 52, 475, 325, mygettext("Depends"));
          dependsTab->hide();
          dependsTab->deactivate();
          { dependsDisplay = new Fl_Text_Display(215, 57, 470, 318);
            dependsDisplay->labelfont(1);
            dependsDisplay->textfont(4);
            dependsDisplay->buffer(txtBuffer);
          } // Fl_Text_Display* dependsDisplay
          dependsTab->end();
        } // Fl_Group* dependsTab
        { sizeTab = new Fl_Group(210, 52, 475, 325, mygettext("Size"));
          sizeTab->hide();
          sizeTab->deactivate();
          { sizeDisplay = new Fl_Text_Display(215, 57, 470, 318);
            sizeDisplay->textfont(4);
            sizeDisplay->buffer(txtBuffer);
          } // Fl_Text_Display* sizeDisplay
          sizeTab->end();
        } // Fl_Group* sizeTab
        tabs->end();
      } // Fl_Tabs* tabs
      { install_choices = new Fl_Choice(8, 380, 140, 20);
        install_choices->down_box(FL_BORDER_BOX);
        install_choices->menu(menu_install_choices);
      } // Fl_Choice* install_choices
      { btnGo = new Fl_Button(150, 380, 30, 20, mygettext("Go"));
        btnGo->callback((Fl_Callback*)btnCB, (void*)("go"));
        btnGo->deactivate();
      } // Fl_Button* btnGo
      { outputStatus = new Fl_Output(230, 380, 420, 20, mygettext("Status"));
        outputStatus->color((Fl_Color)55);
        outputStatus->value(target_dir.c_str());
        outputStatus->label("  TCE:");
      } // Fl_Output* outputStatus
      { btn_tce = new Fl_Button(650, 380, 36, 20, mygettext("Set"));
        btn_tce->callback((Fl_Callback*)btnCB, (void*)("setdrive"));
        btn_tce->deactivate();
        if (target_dir.compare(0,8,"/tmp/tce") == 0 ){btn_tce->activate();outputStatus->color(9);};
      } // Fl_Button* btn_tce
      { outURI = new Fl_Output(40, 401, 646, 20, mygettext("URI:"));
        outURI->color((Fl_Color)29);
        outURI->value(mirror.c_str());
      } // Fl_Output* outURI
      grpBrowse->end();
    } // Fl_Group* grpBrowse
    { grpAudit = new Fl_Group(0, -1, 690, 426);
      grpAudit->hide();
      { boxExtn = new Fl_Box(0, 31, 200, 16, mygettext("Select"));
      } // Fl_Box* boxExtn
      { grpSingle = new Fl_Group(5, 52, 200, 348);
        { brwExtn = new Fl_Browser(5, 52, 200, 325);
          brwExtn->type(2);
          brwExtn->textfont(4);
          brwExtn->callback((Fl_Callback*)brwExtnCB);
        } // Fl_Browser* brwExtn
        { btnSingle = new Fl_Button(5, 380, 75, 20, mygettext("Go"));
          btnSingle->callback((Fl_Callback*)btnSingleCB);
          btnSingle->deactivate();
        } // Fl_Button* btnSingle
        grpSingle->end();
      } // Fl_Group* grpSingle
      { boxResults = new Fl_Box(205, 34, 470, 17, mygettext("Results"));
        boxResults->labelfont(1);
      } // Fl_Box* boxResults
      { grpMulti = new Fl_Group(5, 52, 200, 348);
        { brwMulti = new Fl_Browser(5, 52, 200, 325);
          brwMulti->type(3);
          brwMulti->textfont(4);
          brwMulti->callback((Fl_Callback*)brwMultiCB);
        } // Fl_Browser* brwMulti
        { btnMulti = new Fl_Button(5, 380, 200, 20, mygettext("Process Selected Item(s)"));
          btnMulti->callback((Fl_Callback*)btnMultiCB);
        } // Fl_Button* btnMulti
        grpMulti->end();
      } // Fl_Group* grpMulti
      { brwResults = new Fl_Browser(210, 52, 475, 325);
        brwResults->type(2);
        brwResults->textfont(4);
        brwResults->callback((Fl_Callback*)brwResultsCB);
      } // Fl_Browser* brwResults
      { btnResults = new Fl_Button(210, 380, 145, 20, mygettext("Go"));
        btnResults->callback((Fl_Callback*)btnResultsCB);
        btnResults->deactivate();
      } // Fl_Button* btnResults
      { outTCE = new Fl_Output(40, 401, 646, 20, mygettext("TCE:"));
        outTCE->color((Fl_Color)29);
        outTCE->value(target_dir.c_str());
      } // Fl_Output* outTCE
      grpAudit->end();
    } // Fl_Group* grpAudit
    window->end();
    window->resizable(window);
  } // Fl_Double_Window* window
  window->show(argc, argv);
  return Fl::run();
}
