#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <dbus/dbus.h>
#include "dbus/dbus-sysdeps.h"

int
main (int argc, char *argv[])
{
  DBusConnection *conn = NULL;
  DBusError error;

  _dbus_setenv ("DBUS_SESSION_BUS_ADDRESS", NULL);

  dbus_error_init (&error);

  conn = dbus_bus_get (DBUS_BUS_SESSION, &error);

#ifdef DBUS_ENABLE_X11_AUTOLAUNCH
  if (dbus_error_is_set (&error))
    {
      fprintf (stderr, "*** Failed to autolaunch session bus: %s\n",
               error.message);
      dbus_error_free (&error);
      return 1;
    }
#else
  /* We don't necessarily expect it to *work* without X (although it might -
   * for instance on Mac OS it might have used launchd). Just check that the
   * results are consistent. */

  if (dbus_error_is_set (&error) && conn != NULL)
    {
      fprintf (stderr, "*** Autolaunched session bus, but an error was set!\n");
      return 1;
    }
#endif

  if (!dbus_error_is_set (&error) && conn == NULL)
    {
      fprintf (stderr, "*** Failed to autolaunch session bus but no error was set\n");
      return 1;
    }

  return 0;
}
