/*

This file is part of Auditive.

Copyright 2010-2012 Graeme Sheppard.

Auditive is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Auditive is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Auditive. If not, see <http://www.gnu.org/licenses/>.

*/


// created by script

class key_maps
{
  public const int key_up = Curses.Key.UP;
  public const int key_down = Curses.Key.DOWN;
  public const int key_left = Curses.Key.LEFT;
  public const int key_right = Curses.Key.RIGHT;
  public const int key_home = Curses.Key.HOME;
  public const int key_end = Curses.Key.END;
  public const int key_ppage = Curses.Key.PPAGE;
  public const int key_npage = Curses.Key.NPAGE;
  public const int key_backspace = Curses.Key.BACKSPACE;
  public const int key_shift_tab = 353;
  public const int key_f1 = 265; // could be better defined
  public const int key_k1 = '1';

  public HashTable <string, int> key_texts;

  void add (string name, int num)
  {
    key_texts.insert (name, num);
  }
  
  public key_maps()
  {
    key_texts = new HashTable <string, int> (str_hash, str_equal);
    add ("key_up", key_up);
    add ("key_down", key_down);
    add ("key_left", key_left);
    add ("key_right", key_right);
    add ("key_home", key_home);
    add ("key_end", key_end);
    add ("key_ppage", key_ppage);
    add ("key_npage", key_npage);
    add ("key_backspace", key_backspace);
  }
}

