/* files.c generated by valac 0.16.1, the Vala compiler
 * generated from files.vala, do not modify */

/*

This file is part of Auditive.

Copyright 2010-2012 Graeme Sheppard.

Auditive is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Auditive is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Auditive. If not, see <http://www.gnu.org/licenses/>.

*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <curses.h>
#include <gobject/gvaluecollector.h>


#define TYPE_FILE_TYPE (file_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, nodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, nodeClass))

typedef struct _node node;
typedef struct _nodeClass nodeClass;
typedef struct _nodePrivate nodePrivate;
typedef struct _ParamSpecnode ParamSpecnode;

#define TYPE_SCREEN (screen_get_type ())
#define SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCREEN, screen))
#define SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCREEN, screenClass))
#define IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCREEN))
#define IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCREEN))
#define SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCREEN, screenClass))

typedef struct _screen screen;
typedef struct _screenClass screenClass;
typedef struct _screenPrivate screenPrivate;

#define WORLD_WIDE_TYPE_SCREEN_TYPE (world_wide_screen_type_get_type ())

#define TYPE_WORLD_WIDE (world_wide_get_type ())
#define WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORLD_WIDE, world_wide))
#define WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORLD_WIDE, world_wideClass))
#define IS_WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORLD_WIDE))
#define IS_WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORLD_WIDE))
#define WORLD_WIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORLD_WIDE, world_wideClass))

typedef struct _world_wide world_wide;
typedef struct _world_wideClass world_wideClass;

#define TYPE_FILES (files_get_type ())
#define FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILES, files))
#define FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILES, filesClass))
#define IS_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILES))
#define IS_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILES))
#define FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILES, filesClass))

typedef struct _files files;
typedef struct _filesClass filesClass;
typedef struct _filesPrivate filesPrivate;

#define FILES_TYPE_DISPLAY_TYPE (files_display_type_get_type ())
#define __g_list_free__node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__node_unref0_ (var), NULL)))
typedef struct _world_widePrivate world_widePrivate;

#define TYPE_CONSOLE (console_get_type ())
#define CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSOLE, console))
#define CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSOLE, consoleClass))
#define IS_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSOLE))
#define IS_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSOLE))
#define CONSOLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSOLE, consoleClass))

typedef struct _console console;
typedef struct _consoleClass consoleClass;

#define TYPE_KEY_MAPS (key_maps_get_type ())
#define KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MAPS, key_maps))
#define KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MAPS, key_mapsClass))
#define IS_KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MAPS))
#define IS_KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MAPS))
#define KEY_MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MAPS, key_mapsClass))

typedef struct _key_maps key_maps;
typedef struct _key_mapsClass key_mapsClass;

#define TYPE_AUDITIVE (auditive_get_type ())
#define AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUDITIVE, auditive))
#define AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUDITIVE, auditiveClass))
#define IS_AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUDITIVE))
#define IS_AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUDITIVE))
#define AUDITIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUDITIVE, auditiveClass))

typedef struct _auditive auditive;
typedef struct _auditiveClass auditiveClass;

#define TYPE_PLAYLIST (playlist_get_type ())
#define PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLIST, playlist))
#define PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLIST, playlistClass))
#define IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLIST))
#define IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLIST))
#define PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLIST, playlistClass))

typedef struct _playlist playlist;
typedef struct _playlistClass playlistClass;

#define TYPE_VIEWLIST (viewlist_get_type ())
#define VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEWLIST, viewlist))
#define VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEWLIST, viewlistClass))
#define IS_VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEWLIST))
#define IS_VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEWLIST))
#define VIEWLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEWLIST, viewlistClass))

typedef struct _viewlist viewlist;
typedef struct _viewlistClass viewlistClass;

#define TYPE_EXTERNAL (external_get_type ())
#define EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL, external))
#define EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL, externalClass))
#define IS_EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL))
#define IS_EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL))
#define EXTERNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL, externalClass))

typedef struct _external external;
typedef struct _externalClass externalClass;

#define TYPE_DBG (dbg_get_type ())
#define DBG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBG, dbg))
#define DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DBG, dbgClass))
#define IS_DBG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBG))
#define IS_DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DBG))
#define DBG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DBG, dbgClass))

typedef struct _dbg dbg;
typedef struct _dbgClass dbgClass;

#define TYPE_HELP (help_get_type ())
#define HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELP, help))
#define HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELP, helpClass))
#define IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELP))
#define IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELP))
#define HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELP, helpClass))

typedef struct _help help;
typedef struct _helpClass helpClass;

#define TYPE_METHOD (method_get_type ())
#define METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METHOD, method))
#define METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METHOD, methodClass))
#define IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METHOD))
#define IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METHOD))
#define METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METHOD, methodClass))

typedef struct _method method;
typedef struct _methodClass methodClass;

#define WORLD_WIDE_TYPE_PLAYING_TYPE (world_wide_playing_type_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define EXTERNAL_TYPE_KEY_HANDLED (external_key_handled_get_type ())

typedef enum  {
	FILE_TYPE_dir,
	FILE_TYPE_file,
	FILE_TYPE_m3u,
	FILE_TYPE_not_exist
} file_type;

struct _node {
	GTypeInstance parent_instance;
	volatile int ref_count;
	nodePrivate * priv;
	gchar* name;
	gboolean is_dir;
	glong age;
	glong size;
};

struct _nodeClass {
	GTypeClass parent_class;
	void (*finalize) (node *self);
};

struct _ParamSpecnode {
	GParamSpec parent_instance;
};

typedef enum  {
	WORLD_WIDE_SCREEN_TYPE_none,
	WORLD_WIDE_SCREEN_TYPE_file_list,
	WORLD_WIDE_SCREEN_TYPE_view_list,
	WORLD_WIDE_SCREEN_TYPE_play_list,
	WORLD_WIDE_SCREEN_TYPE_ext_list,
	WORLD_WIDE_SCREEN_TYPE_debug,
	WORLD_WIDE_SCREEN_TYPE_help
} world_widescreen_type;

struct _screen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	screenPrivate * priv;
	world_wide* world;
	gint screen_pos;
	gint row_pos;
	gint key_handled;
};

struct _screenClass {
	GTypeClass parent_class;
	void (*finalize) (screen *self);
	gboolean (*has_title) (screen* self);
	gchar* (*get_title) (screen* self);
	void (*previous_song) (screen* self);
	void (*advance_song) (screen* self);
	void (*continue_songs) (screen* self);
	void (*continue_songs_draw) (screen* self);
	gint (*get_size) (screen* self);
	gchar* (*calc_target) (screen* self, guint num);
	gchar* (*get_line) (screen* self, guint num);
	world_widescreen_type (*get_screen_type) (screen* self);
	void (*reset_stop) (screen* self);
	void (*draw) (screen* self);
	void (*key_press) (screen* self, gint key_num);
};

struct _files {
	screen parent_instance;
	filesPrivate * priv;
	gchar* path;
	GList* entry;
};

struct _filesClass {
	screenClass parent_class;
};

typedef enum  {
	FILES_DISPLAY_TYPE_name,
	FILES_DISPLAY_TYPE_size,
	FILES_DISPLAY_TYPE_age,
	FILES_DISPLAY_TYPE_end
} filesdisplay_type;

struct _filesPrivate {
	filesdisplay_type display_mode;
	gchar* playlist_position_string;
	gchar* gapless_position_string;
	gint files_position;
	glong max_size;
	gint size_padding;
};

typedef enum  {
	WORLD_WIDE_PLAYING_TYPE_stop,
	WORLD_WIDE_PLAYING_TYPE_play,
	WORLD_WIDE_PLAYING_TYPE_pause
} world_wideplaying_type;

struct _world_wide {
	GTypeInstance parent_instance;
	volatile int ref_count;
	world_widePrivate * priv;
	console* con;
	key_maps* keys;
	auditive* player;
	playlist* play_screen;
	viewlist* view_screen;
	external* ext_screen;
	dbg* debug;
	help* help_screen;
	GList* files_array;
	GList* keys_array;
	world_widescreen_type screen_current;
	world_wideplaying_type playing_state;
	gint screen_files;
	gboolean play_advance;
	screen* playing_screen;
	gint playlist_position;
};

struct _world_wideClass {
	GTypeClass parent_class;
	void (*finalize) (world_wide *self);
};

typedef enum  {
	EXTERNAL_KEY_HANDLED_none,
	EXTERNAL_KEY_HANDLED_resync,
	EXTERNAL_KEY_HANDLED_opened
} externalkey_handled;


static gpointer node_parent_class = NULL;
static gpointer files_parent_class = NULL;

GType file_type_get_type (void) G_GNUC_CONST;
file_type determine_node (const gchar* path);
gchar* remove_slashes (const gchar* path);
gchar* get_file_from_path (const gchar* full_path);
gchar* get_base_from_path (const gchar* full_path);
gchar* int_to_commas (glong num);
gpointer node_ref (gpointer instance);
void node_unref (gpointer instance);
GParamSpec* param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_node (GValue* value, gpointer v_object);
void value_take_node (GValue* value, gpointer v_object);
gpointer value_get_node (const GValue* value);
GType node_get_type (void) G_GNUC_CONST;
enum  {
	NODE_DUMMY_PROPERTY
};
node* node_new (const gchar* n, gboolean d, glong a, glong s);
node* node_construct (GType object_type, const gchar* n, gboolean d, glong a, glong s);
static void node_finalize (node* obj);
gint cmp_nodes_name (node* left, node* right);
gint cmp_nodes_size (node* left, node* right);
gint cmp_nodes_age (node* left, node* right);
gint cmp_nodes_age_reverse (node* left, node* right);
gpointer screen_ref (gpointer instance);
void screen_unref (gpointer instance);
GParamSpec* param_spec_screen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_screen (GValue* value, gpointer v_object);
void value_take_screen (GValue* value, gpointer v_object);
gpointer value_get_screen (const GValue* value);
GType screen_get_type (void) G_GNUC_CONST;
GType world_wide_screen_type_get_type (void) G_GNUC_CONST;
gpointer world_wide_ref (gpointer instance);
void world_wide_unref (gpointer instance);
GParamSpec* param_spec_world_wide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_world_wide (GValue* value, gpointer v_object);
void value_take_world_wide (GValue* value, gpointer v_object);
gpointer value_get_world_wide (const GValue* value);
GType world_wide_get_type (void) G_GNUC_CONST;
GType files_get_type (void) G_GNUC_CONST;
static GType files_display_type_get_type (void) G_GNUC_UNUSED;
#define FILES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILES, filesPrivate))
enum  {
	FILES_DUMMY_PROPERTY
};
static void _node_unref0_ (gpointer var);
static void _g_list_free__node_unref0_ (GList* self);
files* files_new (world_wide* w, const gchar* dir_name);
files* files_construct (GType object_type, world_wide* w, const gchar* dir_name);
screen* screen_construct (GType object_type);
gpointer console_ref (gpointer instance);
void console_unref (gpointer instance);
GParamSpec* param_spec_console (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_console (GValue* value, gpointer v_object);
void value_take_console (GValue* value, gpointer v_object);
gpointer value_get_console (const GValue* value);
GType console_get_type (void) G_GNUC_CONST;
gpointer key_maps_ref (gpointer instance);
void key_maps_unref (gpointer instance);
GParamSpec* param_spec_key_maps (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_maps (GValue* value, gpointer v_object);
void value_take_key_maps (GValue* value, gpointer v_object);
gpointer value_get_key_maps (const GValue* value);
GType key_maps_get_type (void) G_GNUC_CONST;
gpointer auditive_ref (gpointer instance);
void auditive_unref (gpointer instance);
GParamSpec* param_spec_auditive (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_auditive (GValue* value, gpointer v_object);
void value_take_auditive (GValue* value, gpointer v_object);
gpointer value_get_auditive (const GValue* value);
GType auditive_get_type (void) G_GNUC_CONST;
GType playlist_get_type (void) G_GNUC_CONST;
GType viewlist_get_type (void) G_GNUC_CONST;
GType external_get_type (void) G_GNUC_CONST;
GType dbg_get_type (void) G_GNUC_CONST;
GType help_get_type (void) G_GNUC_CONST;
gpointer method_ref (gpointer instance);
void method_unref (gpointer instance);
GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_method (GValue* value, gpointer v_object);
void value_take_method (GValue* value, gpointer v_object);
gpointer value_get_method (const GValue* value);
GType method_get_type (void) G_GNUC_CONST;
GType world_wide_playing_type_get_type (void) G_GNUC_CONST;
static void files_rescan (files* self);
void files_sort_name (files* self);
void dbg_add (dbg* self, const gchar* text);
static gchar* files_real_get_title (screen* base);
static gint files_real_get_size (screen* base);
static gchar* files_real_calc_target (screen* base, guint num);
static gchar* files_real_get_line (screen* base, guint num);
gchar* screen_list_prefix (screen* self);
void files_sort_size (files* self);
void files_sort_age (files* self);
void files_sort_age_reverse (files* self);
static world_widescreen_type files_real_get_screen_type (screen* base);
static void files_real_draw (screen* base);
void screen_draw (screen* self);
void files_play_a_song (files* self, const gchar* name);
static gint files_find_entry (files* self, const gchar* name);
void auditive_stop (auditive* self);
void playlist_empty (playlist* self);
void auditive_set_playing (auditive* self, const gchar* source);
static void files_real_previous_song (screen* base);
void screen_zoom_to (screen* self, gint index);
static void files_real_advance_song (screen* base);
static void files_real_continue_songs (screen* base);
gint screen_get_size (screen* self);
void auditive_continue_playing (auditive* self, const gchar* source);
static void files_real_continue_songs_draw (screen* base);
void auditive_draw (auditive* self);
static void files_real_reset_stop (screen* base);
static void files_real_key_press (screen* base, gint key_num);
viewlist* viewlist_new_view_start (world_wide* w, const gchar* full_path);
viewlist* viewlist_construct_view_start (GType object_type, world_wide* w, const gchar* full_path);
#define KEY_MAPS_key_left ((gint) KEY_LEFT)
#define KEY_MAPS_key_right ((gint) KEY_RIGHT)
#define KEY_MAPS_key_shift_tab 353
void files_sort (files* self);
GType external_key_handled_get_type (void) G_GNUC_CONST;
externalkey_handled external_external_key_press (external* self, gint key_num);
void screen_key_press (screen* self, gint key_num);
void files_zoom_to_name (files* self, const gchar* name);
static void files_finalize (screen* obj);
void start_from_new_path (world_wide* world, const gchar* full_path, gboolean do_draw, const gchar* zoom_into);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType file_type_get_type (void) {
	static volatile gsize file_type_type_id__volatile = 0;
	if (g_once_init_enter (&file_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_TYPE_dir, "FILE_TYPE_dir", "dir"}, {FILE_TYPE_file, "FILE_TYPE_file", "file"}, {FILE_TYPE_m3u, "FILE_TYPE_m3u", "m3u"}, {FILE_TYPE_not_exist, "FILE_TYPE_not_exist", "not-exist"}, {0, NULL, NULL}};
		GType file_type_type_id;
		file_type_type_id = g_enum_register_static ("file_type", values);
		g_once_init_leave (&file_type_type_id__volatile, file_type_type_id);
	}
	return file_type_type_id__volatile;
}


file_type determine_node (const gchar* path) {
	file_type result = 0;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* node;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_;
	GFileType _tmp5_ = 0;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (path != NULL, 0);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	node = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		result = FILE_TYPE_not_exist;
		_g_object_unref0 (node);
		return result;
	}
	_tmp4_ = node;
	_tmp5_ = g_file_query_file_type (_tmp4_, 0, NULL);
	if (_tmp5_ == G_FILE_TYPE_DIRECTORY) {
		result = FILE_TYPE_dir;
		_g_object_unref0 (node);
		return result;
	}
	_tmp6_ = path;
	_tmp7_ = g_str_has_suffix (_tmp6_, ".m3u");
	if (_tmp7_) {
		result = FILE_TYPE_m3u;
		_g_object_unref0 (node);
		return result;
	} else {
		result = FILE_TYPE_file;
		_g_object_unref0 (node);
		return result;
	}
	_g_object_unref0 (node);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* remove_slashes (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* ret;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp11_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gboolean _tmp16_;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	ret = _tmp1_;
	while (TRUE) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* old;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = ret;
		_tmp3_ = g_strdup (_tmp2_);
		old = _tmp3_;
		_tmp4_ = ret;
		_tmp5_ = string_replace (_tmp4_, "//", "/");
		_g_free0 (ret);
		ret = _tmp5_;
		_tmp6_ = ret;
		_tmp7_ = old;
		if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
			_g_free0 (old);
			break;
		}
		_g_free0 (old);
	}
	_tmp9_ = ret;
	if (g_strcmp0 (_tmp9_, "") == 0) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = ret;
		_tmp8_ = g_strcmp0 (_tmp10_, "/") == 0;
	}
	_tmp11_ = _tmp8_;
	if (_tmp11_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("/");
		result = _tmp12_;
		_g_free0 (ret);
		return result;
	}
	_tmp13_ = ret;
	_tmp14_ = string_substring (_tmp13_, (glong) (-1), (glong) (-1));
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strcmp0 (_tmp15_, "/") == 0;
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		_tmp17_ = ret;
		_tmp18_ = ret;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp20_ - 1));
		result = _tmp21_;
		_g_free0 (ret);
		return result;
	}
	result = ret;
	return result;
}


gchar* get_file_from_path (const gchar* full_path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** bits;
	gint bits_length1;
	gint _bits_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_val_if_fail (full_path != NULL, NULL);
	_tmp0_ = full_path;
	_tmp1_ = remove_slashes (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "/") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = path;
		return result;
	}
	_tmp6_ = path;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
	bits = _tmp8_;
	bits_length1 = _vala_array_length (_tmp7_);
	_bits_size_ = bits_length1;
	_tmp9_ = bits;
	_tmp9__length1 = bits_length1;
	_tmp10_ = bits;
	_tmp10__length1 = bits_length1;
	_tmp11_ = _tmp9_[_tmp10__length1 - 1];
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* get_base_from_path (const gchar* full_path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	g_return_val_if_fail (full_path != NULL, NULL);
	_tmp0_ = full_path;
	_tmp1_ = remove_slashes (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "/") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = path;
		return result;
	}
	{
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint i;
		_tmp6_ = path;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		i = ((gint) _tmp8_) - 1;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar _tmp15_ = '\0';
				gunichar _tmp16_ = 0U;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ - 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				if (!(_tmp12_ > 0)) {
					break;
				}
				_tmp13_ = path;
				_tmp14_ = i;
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
				_tmp16_ = string_get_char ("/", (glong) 0);
				if (((gunichar) _tmp15_) == _tmp16_) {
					const gchar* _tmp17_;
					gint _tmp18_;
					gchar* _tmp19_ = NULL;
					_tmp17_ = path;
					_tmp18_ = i;
					_tmp19_ = string_substring (_tmp17_, (glong) 0, (glong) _tmp18_);
					result = _tmp19_;
					_g_free0 (path);
					return result;
				}
			}
		}
	}
	result = path;
	return result;
}


gchar* int_to_commas (glong num) {
	gchar* result = NULL;
	gchar* answer = NULL;
	gint i = 0;
	gint c = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_tmp0_ = num;
	_tmp1_ = g_strdup_printf ("%li", _tmp0_);
	_g_free0 (answer);
	answer = _tmp1_;
	_tmp2_ = answer;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	i = _tmp4_;
	_tmp5_ = i;
	if (_tmp5_ == 0) {
		result = answer;
		return result;
	}
	_tmp6_ = i;
	i = _tmp6_ - 1;
	c = 3;
	while (TRUE) {
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp21_;
		_tmp7_ = i;
		if (!(_tmp7_ > 0)) {
			break;
		}
		_tmp8_ = c;
		c = _tmp8_ - 1;
		_tmp9_ = c;
		if (_tmp9_ == 0) {
			const gchar* _tmp10_;
			gint _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp10_ = answer;
			_tmp11_ = i;
			_tmp12_ = string_substring (_tmp10_, (glong) 0, (glong) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = answer;
			_tmp17_ = i;
			_tmp18_ = string_substring (_tmp16_, (glong) _tmp17_, (glong) (-1));
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
			_g_free0 (answer);
			answer = _tmp20_;
			_g_free0 (_tmp19_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			c = 3;
		}
		_tmp21_ = i;
		i = _tmp21_ - 1;
	}
	result = answer;
	return result;
}


node* node_construct (GType object_type, const gchar* n, gboolean d, glong a, glong s) {
	node* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	glong _tmp3_;
	glong _tmp4_;
	g_return_val_if_fail (n != NULL, NULL);
	self = (node*) g_type_create_instance (object_type);
	_tmp0_ = n;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = d;
	self->is_dir = _tmp2_;
	_tmp3_ = a;
	self->age = _tmp3_;
	_tmp4_ = s;
	self->size = _tmp4_;
	return self;
}


node* node_new (const gchar* n, gboolean d, glong a, glong s) {
	return node_construct (TYPE_NODE, n, d, a, s);
}


static void value_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		node_unref (value->data[0].v_pointer);
	}
}


static void value_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		node* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	node** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecnode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


void value_set_node (GValue* value, gpointer v_object) {
	node* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_unref (old);
	}
}


void value_take_node (GValue* value, gpointer v_object) {
	node* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_unref (old);
	}
}


static void node_class_init (nodeClass * klass) {
	node_parent_class = g_type_class_peek_parent (klass);
	NODE_CLASS (klass)->finalize = node_finalize;
}


static void node_instance_init (node * self) {
	self->ref_count = 1;
}


static void node_finalize (node* obj) {
	node * self;
	self = NODE (obj);
	_g_free0 (self->name);
}


GType node_get_type (void) {
	static volatile gsize node_type_id__volatile = 0;
	if (g_once_init_enter (&node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_node_init, value_node_free_value, value_node_copy_value, value_node_peek_pointer, "p", value_node_collect_value, "p", value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (nodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (node), 0, (GInstanceInitFunc) node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType node_type_id;
		node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "node", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&node_type_id__volatile, node_type_id);
	}
	return node_type_id__volatile;
}


gpointer node_ref (gpointer instance) {
	node* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void node_unref (gpointer instance) {
	node* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint cmp_nodes_name (node* left, node* right) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	node* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	node* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp11_;
	node* _tmp12_;
	const gchar* _tmp13_;
	node* _tmp14_;
	const gchar* _tmp15_;
	node* _tmp16_;
	const gchar* _tmp17_;
	node* _tmp18_;
	const gchar* _tmp19_;
	_tmp1_ = left;
	_tmp2_ = _tmp1_->is_dir;
	if (_tmp2_) {
		node* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = right;
		_tmp4_ = _tmp3_->is_dir;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = -1;
		return result;
	}
	_tmp7_ = left;
	_tmp8_ = _tmp7_->is_dir;
	if (!_tmp8_) {
		node* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = right;
		_tmp10_ = _tmp9_->is_dir;
		_tmp6_ = _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		result = 1;
		return result;
	}
	_tmp12_ = left;
	_tmp13_ = _tmp12_->name;
	_tmp14_ = right;
	_tmp15_ = _tmp14_->name;
	if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
		result = 0;
		return result;
	}
	_tmp16_ = left;
	_tmp17_ = _tmp16_->name;
	_tmp18_ = right;
	_tmp19_ = _tmp18_->name;
	if (g_strcmp0 (_tmp17_, _tmp19_) < 0) {
		result = -1;
		return result;
	}
	result = 1;
	return result;
}


gint cmp_nodes_size (node* left, node* right) {
	gint result = 0;
	node* _tmp0_;
	glong _tmp1_;
	node* _tmp2_;
	glong _tmp3_;
	node* _tmp4_;
	glong _tmp5_;
	node* _tmp6_;
	glong _tmp7_;
	_tmp0_ = left;
	_tmp1_ = _tmp0_->size;
	_tmp2_ = right;
	_tmp3_ = _tmp2_->size;
	if (_tmp1_ < _tmp3_) {
		result = -1;
		return result;
	}
	_tmp4_ = left;
	_tmp5_ = _tmp4_->size;
	_tmp6_ = right;
	_tmp7_ = _tmp6_->size;
	if (_tmp5_ > _tmp7_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}


gint cmp_nodes_age (node* left, node* right) {
	gint result = 0;
	node* _tmp0_;
	glong _tmp1_;
	node* _tmp2_;
	glong _tmp3_;
	node* _tmp4_;
	glong _tmp5_;
	node* _tmp6_;
	glong _tmp7_;
	_tmp0_ = left;
	_tmp1_ = _tmp0_->age;
	_tmp2_ = right;
	_tmp3_ = _tmp2_->age;
	if (_tmp1_ < _tmp3_) {
		result = -1;
		return result;
	}
	_tmp4_ = left;
	_tmp5_ = _tmp4_->age;
	_tmp6_ = right;
	_tmp7_ = _tmp6_->age;
	if (_tmp5_ > _tmp7_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}


gint cmp_nodes_age_reverse (node* left, node* right) {
	gint result = 0;
	node* _tmp0_;
	glong _tmp1_;
	node* _tmp2_;
	glong _tmp3_;
	node* _tmp4_;
	glong _tmp5_;
	node* _tmp6_;
	glong _tmp7_;
	_tmp0_ = left;
	_tmp1_ = _tmp0_->age;
	_tmp2_ = right;
	_tmp3_ = _tmp2_->age;
	if (_tmp1_ < _tmp3_) {
		result = 1;
		return result;
	}
	_tmp4_ = left;
	_tmp5_ = _tmp4_->age;
	_tmp6_ = right;
	_tmp7_ = _tmp6_->age;
	if (_tmp5_ > _tmp7_) {
		result = -1;
		return result;
	}
	result = 0;
	return result;
}


static GType files_display_type_get_type (void) {
	static volatile gsize files_display_type_type_id__volatile = 0;
	if (g_once_init_enter (&files_display_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FILES_DISPLAY_TYPE_name, "FILES_DISPLAY_TYPE_name", "name"}, {FILES_DISPLAY_TYPE_size, "FILES_DISPLAY_TYPE_size", "size"}, {FILES_DISPLAY_TYPE_age, "FILES_DISPLAY_TYPE_age", "age"}, {FILES_DISPLAY_TYPE_end, "FILES_DISPLAY_TYPE_end", "end"}, {0, NULL, NULL}};
		GType files_display_type_type_id;
		files_display_type_type_id = g_enum_register_static ("filesdisplay_type", values);
		g_once_init_leave (&files_display_type_type_id__volatile, files_display_type_type_id);
	}
	return files_display_type_type_id__volatile;
}


static void _node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (node_unref (var), NULL));
}


static void _g_list_free__node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _node_unref0_, NULL);
	g_list_free (self);
}


files* files_construct (GType object_type, world_wide* w, const gchar* dir_name) {
	files* self = NULL;
	world_wide* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	world_wide* _tmp3_;
	GList* _tmp4_;
	guint _tmp5_ = 0U;
	world_wide* _tmp6_;
	g_return_val_if_fail (dir_name != NULL, NULL);
	self = (files*) screen_construct (object_type);
	_tmp0_ = w;
	((screen*) self)->world = _tmp0_;
	_tmp1_ = dir_name;
	_tmp2_ = remove_slashes (_tmp1_);
	_g_free0 (self->path);
	self->path = _tmp2_;
	_tmp3_ = ((screen*) self)->world;
	_tmp4_ = _tmp3_->files_array;
	_tmp5_ = g_list_length (_tmp4_);
	self->priv->files_position = (gint) _tmp5_;
	_tmp6_ = ((screen*) self)->world;
	_tmp6_->files_array = g_list_append (_tmp6_->files_array, self);
	files_rescan (self);
	files_sort_name (self);
	return self;
}


files* files_new (world_wide* w, const gchar* dir_name) {
	return files_construct (TYPE_FILES, w, dir_name);
}


static void files_rescan (files* self) {
	glong _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->max_size = (glong) 0;
	while (TRUE) {
		GList* _tmp0_;
		guint _tmp1_ = 0U;
		GList* _tmp2_;
		GList* _tmp3_ = NULL;
		_tmp0_ = self->entry;
		_tmp1_ = g_list_length (_tmp0_);
		if (!(_tmp1_ > ((guint) 0))) {
			break;
		}
		_tmp2_ = self->entry;
		_tmp3_ = g_list_last (_tmp2_);
		self->entry = g_list_delete_link (self->entry, _tmp3_);
	}
	{
		const gchar* _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* dir;
		GFile* _tmp6_;
		GFileEnumerator* _tmp7_ = NULL;
		GFileEnumerator* e;
		GFileInfo* info = NULL;
		GTimeVal tv = {0};
		gboolean is_dir = FALSE;
		glong size = 0L;
		_tmp4_ = self->path;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		dir = _tmp5_;
		_tmp6_ = dir;
		_tmp7_ = g_file_enumerate_children (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED, 0, NULL, &_inner_error_);
		e = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dir);
			goto __catch4_g_error;
		}
		while (TRUE) {
			GFileEnumerator* _tmp8_;
			GFileInfo* _tmp9_ = NULL;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			GTimeVal _tmp13_ = {0};
			GFileInfo* _tmp14_;
			GFileType _tmp15_ = 0;
			glong _tmp16_ = 0L;
			gboolean _tmp17_;
			glong _tmp20_;
			GFileInfo* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gboolean _tmp23_;
			GTimeVal _tmp24_;
			glong _tmp25_;
			glong _tmp26_;
			node* _tmp27_;
			glong _tmp28_;
			glong _tmp29_;
			_tmp8_ = e;
			_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (info);
				_g_object_unref0 (e);
				_g_object_unref0 (dir);
				goto __catch4_g_error;
			}
			_g_object_unref0 (info);
			info = _tmp10_;
			_tmp11_ = info;
			if (!(_tmp11_ != NULL)) {
				break;
			}
			_tmp12_ = info;
			g_file_info_get_modification_time (_tmp12_, &_tmp13_);
			tv = _tmp13_;
			_tmp14_ = info;
			_tmp15_ = g_file_info_get_file_type (_tmp14_);
			is_dir = _tmp15_ == G_FILE_TYPE_DIRECTORY;
			_tmp17_ = is_dir;
			if (_tmp17_) {
				_tmp16_ = (glong) 0;
			} else {
				GFileInfo* _tmp18_;
				gint64 _tmp19_ = 0LL;
				_tmp18_ = info;
				_tmp19_ = g_file_info_get_size (_tmp18_);
				_tmp16_ = (glong) _tmp19_;
			}
			_tmp20_ = _tmp16_;
			size = _tmp20_;
			_tmp21_ = info;
			_tmp22_ = g_file_info_get_name (_tmp21_);
			_tmp23_ = is_dir;
			_tmp24_ = tv;
			_tmp25_ = _tmp24_.tv_sec;
			_tmp26_ = size;
			_tmp27_ = node_new (_tmp22_, _tmp23_, _tmp25_, _tmp26_);
			self->entry = g_list_append (self->entry, _tmp27_);
			_tmp28_ = size;
			_tmp29_ = self->priv->max_size;
			if (_tmp28_ > _tmp29_) {
				glong _tmp30_;
				_tmp30_ = size;
				self->priv->max_size = _tmp30_;
			}
		}
		_g_object_unref0 (info);
		_g_object_unref0 (e);
		_g_object_unref0 (dir);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		world_wide* _tmp31_;
		dbg* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GError* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = ((screen*) self)->world;
		_tmp32_ = _tmp31_->debug;
		_tmp33_ = self->path;
		_tmp34_ = g_strconcat ("Scan dir error: ", _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat (_tmp35_, ": ", NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = err;
		_tmp39_ = _tmp38_->message;
		_tmp40_ = g_strconcat (_tmp37_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		dbg_add (_tmp32_, _tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_error_free0 (err);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp42_ = self->priv->max_size;
	_tmp43_ = int_to_commas (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = strlen (_tmp44_);
	_tmp46_ = _tmp45_;
	self->priv->size_padding = _tmp46_;
	_g_free0 (_tmp44_);
}


static gchar* files_real_get_title (screen* base) {
	files * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	self = (files*) base;
	_tmp1_ = self->path;
	if (g_strcmp0 (_tmp1_, "/") == 0) {
		_tmp0_ = "";
	} else {
		_tmp0_ = "/";
	}
	_tmp2_ = self->path;
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup_printf ("  %s%s", _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gint files_real_get_size (screen* base) {
	files * self;
	gint result = 0;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	self = (files*) base;
	_tmp0_ = self->entry;
	_tmp1_ = g_list_length (_tmp0_);
	result = (gint) _tmp1_;
	return result;
}


static gchar* files_real_calc_target (screen* base, guint num) {
	files * self;
	gchar* result = NULL;
	guint _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
	self = (files*) base;
	_tmp0_ = num;
	_tmp1_ = self->entry;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp0_ <= _tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GList* _tmp6_;
		guint _tmp7_;
		gconstpointer _tmp8_ = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp3_ = self->path;
		_tmp4_ = g_strconcat (_tmp3_, "/", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->entry;
		_tmp7_ = num;
		_tmp8_ = g_list_nth_data (_tmp6_, _tmp7_);
		_tmp9_ = ((node*) _tmp8_)->name;
		_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = remove_slashes (_tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp5_);
		result = _tmp13_;
		return result;
	} else {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = self->path;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		return result;
	}
}


static gchar* files_real_get_line (screen* base, guint num) {
	files * self;
	gchar* result = NULL;
	GList* _tmp0_;
	guint _tmp1_;
	gconstpointer _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* short_name;
	gchar* _tmp5_;
	gchar* prefix;
	gboolean _tmp6_ = FALSE;
	world_wide* _tmp7_;
	screen* _tmp8_;
	gboolean _tmp11_;
	gchar* text = NULL;
	GDateTime* dt = NULL;
	filesdisplay_type _tmp13_;
	const gchar* _tmp51_ = NULL;
	GList* _tmp52_;
	guint _tmp53_;
	gconstpointer _tmp54_ = NULL;
	gboolean _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* suffix;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	self = (files*) base;
	_tmp0_ = self->entry;
	_tmp1_ = num;
	_tmp2_ = g_list_nth_data (_tmp0_, _tmp1_);
	_tmp3_ = ((node*) _tmp2_)->name;
	_tmp4_ = g_strdup (_tmp3_);
	short_name = _tmp4_;
	_tmp5_ = g_strdup ("  ");
	prefix = _tmp5_;
	_tmp7_ = ((screen*) self)->world;
	_tmp8_ = _tmp7_->playing_screen;
	if (_tmp8_ == ((screen*) self)) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = short_name;
		_tmp10_ = self->priv->playlist_position_string;
		_tmp6_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		gchar* _tmp12_ = NULL;
		_tmp12_ = screen_list_prefix ((screen*) self);
		_g_free0 (prefix);
		prefix = _tmp12_;
	}
	_tmp13_ = self->priv->display_mode;
	switch (_tmp13_) {
		case FILES_DISPLAY_TYPE_name:
		{
			GList* _tmp14_;
			guint _tmp15_;
			gconstpointer _tmp16_ = NULL;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = self->entry;
			_tmp15_ = num;
			_tmp16_ = g_list_nth_data (_tmp14_, _tmp15_);
			_tmp17_ = ((node*) _tmp16_)->name;
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (text);
			text = _tmp18_;
			break;
		}
		case FILES_DISPLAY_TYPE_size:
		{
			GList* _tmp19_;
			guint _tmp20_;
			gconstpointer _tmp21_ = NULL;
			glong _tmp22_;
			gchar* _tmp23_ = NULL;
			gint _tmp24_;
			const gchar* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp19_ = self->entry;
			_tmp20_ = num;
			_tmp21_ = g_list_nth_data (_tmp19_, _tmp20_);
			_tmp22_ = ((node*) _tmp21_)->size;
			_tmp23_ = int_to_commas (_tmp22_);
			_g_free0 (text);
			text = _tmp23_;
			_tmp24_ = self->priv->size_padding;
			_tmp25_ = text;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strnfill ((gsize) (_tmp24_ - _tmp27_), ' ');
			_tmp29_ = _tmp28_;
			_tmp30_ = text;
			_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp32_, " ", NULL);
			_g_free0 (text);
			text = _tmp33_;
			_g_free0 (_tmp32_);
			_g_free0 (_tmp29_);
			break;
		}
		case FILES_DISPLAY_TYPE_age:
		{
			GList* _tmp34_;
			guint _tmp35_;
			gconstpointer _tmp36_ = NULL;
			glong _tmp37_;
			GDateTime* _tmp38_;
			GDateTime* _tmp39_;
			gint _tmp40_ = 0;
			GDateTime* _tmp41_;
			gint _tmp42_ = 0;
			GDateTime* _tmp43_;
			gint _tmp44_ = 0;
			GDateTime* _tmp45_;
			gint _tmp46_ = 0;
			GDateTime* _tmp47_;
			gint _tmp48_ = 0;
			gchar* _tmp49_ = NULL;
			_tmp34_ = self->entry;
			_tmp35_ = num;
			_tmp36_ = g_list_nth_data (_tmp34_, _tmp35_);
			_tmp37_ = ((node*) _tmp36_)->age;
			_tmp38_ = g_date_time_new_from_unix_local ((gint64) _tmp37_);
			_g_date_time_unref0 (dt);
			dt = _tmp38_;
			_tmp39_ = dt;
			_tmp40_ = g_date_time_get_year (_tmp39_);
			_tmp41_ = dt;
			_tmp42_ = g_date_time_get_month (_tmp41_);
			_tmp43_ = dt;
			_tmp44_ = g_date_time_get_day_of_month (_tmp43_);
			_tmp45_ = dt;
			_tmp46_ = g_date_time_get_hour (_tmp45_);
			_tmp47_ = dt;
			_tmp48_ = g_date_time_get_minute (_tmp47_);
			_tmp49_ = g_strdup_printf ("%d/%02d/%02d %02d:%02d ", _tmp40_, _tmp42_, _tmp44_, _tmp46_, _tmp48_);
			_g_free0 (text);
			text = _tmp49_;
			break;
		}
		default:
		{
			gchar* _tmp50_;
			_tmp50_ = g_strdup ("<unhandled display type>");
			_g_free0 (text);
			text = _tmp50_;
			break;
		}
	}
	_tmp52_ = self->entry;
	_tmp53_ = num;
	_tmp54_ = g_list_nth_data (_tmp52_, _tmp53_);
	_tmp55_ = ((node*) _tmp54_)->is_dir;
	if (_tmp55_ == TRUE) {
		_tmp51_ = "/";
	} else {
		_tmp51_ = "";
	}
	_tmp56_ = _tmp51_;
	_tmp57_ = g_strdup (_tmp56_);
	suffix = _tmp57_;
	_tmp58_ = prefix;
	_tmp59_ = text;
	_tmp60_ = g_strconcat (_tmp58_, _tmp59_, NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = g_strconcat (_tmp61_, suffix, NULL);
	_tmp63_ = _tmp62_;
	_g_free0 (_tmp61_);
	result = _tmp63_;
	_g_free0 (suffix);
	_g_date_time_unref0 (dt);
	_g_free0 (text);
	_g_free0 (prefix);
	_g_free0 (short_name);
	return result;
}


void files_sort_name (files* self) {
	g_return_if_fail (self != NULL);
	self->entry = g_list_sort (self->entry, (GCompareFunc) cmp_nodes_name);
	self->priv->display_mode = FILES_DISPLAY_TYPE_name;
}


void files_sort_size (files* self) {
	g_return_if_fail (self != NULL);
	self->entry = g_list_sort (self->entry, (GCompareFunc) cmp_nodes_size);
	self->priv->display_mode = FILES_DISPLAY_TYPE_size;
}


void files_sort_age (files* self) {
	g_return_if_fail (self != NULL);
	self->entry = g_list_sort (self->entry, (GCompareFunc) cmp_nodes_age);
	self->priv->display_mode = FILES_DISPLAY_TYPE_age;
}


void files_sort_age_reverse (files* self) {
	g_return_if_fail (self != NULL);
	self->entry = g_list_sort (self->entry, (GCompareFunc) cmp_nodes_age_reverse);
	self->priv->display_mode = FILES_DISPLAY_TYPE_age;
}


static world_widescreen_type files_real_get_screen_type (screen* base) {
	files * self;
	world_widescreen_type result = 0;
	self = (files*) base;
	result = WORLD_WIDE_SCREEN_TYPE_file_list;
	return result;
}


static void files_real_draw (screen* base) {
	files * self;
	world_wide* _tmp0_;
	gint _tmp1_;
	self = (files*) base;
	_tmp0_ = ((screen*) self)->world;
	_tmp1_ = self->priv->files_position;
	_tmp0_->screen_files = _tmp1_;
	SCREEN_CLASS (files_parent_class)->draw (SCREEN (self));
}


void files_play_a_song (files* self, const gchar* name) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint index;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = files_find_entry (self, _tmp0_);
	index = _tmp1_;
	_tmp2_ = index;
	if (_tmp2_ < 0) {
		world_wide* _tmp3_;
		auditive* _tmp4_;
		_tmp3_ = ((screen*) self)->world;
		_tmp4_ = _tmp3_->player;
		auditive_stop (_tmp4_);
	} else {
		world_wide* _tmp5_;
		playlist* _tmp6_;
		world_wide* _tmp9_;
		world_wide* _tmp10_;
		auditive* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp5_ = ((screen*) self)->world;
		_tmp6_ = _tmp5_->play_screen;
		if (_tmp6_ != NULL) {
			world_wide* _tmp7_;
			playlist* _tmp8_;
			_tmp7_ = ((screen*) self)->world;
			_tmp8_ = _tmp7_->play_screen;
			playlist_empty (_tmp8_);
		}
		_tmp9_ = ((screen*) self)->world;
		_tmp9_->playing_screen = (screen*) self;
		_tmp10_ = ((screen*) self)->world;
		_tmp11_ = _tmp10_->player;
		_tmp12_ = self->path;
		_tmp13_ = g_strconcat (_tmp12_, "/", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = name;
		_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = remove_slashes (_tmp17_);
		_tmp19_ = _tmp18_;
		auditive_set_playing (_tmp11_, _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		_tmp20_ = name;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (self->priv->playlist_position_string);
		self->priv->playlist_position_string = _tmp21_;
	}
}


static void files_real_previous_song (screen* base) {
	files * self;
	world_wide* _tmp0_;
	world_wideplaying_type _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint index;
	gint _tmp12_;
	self = (files*) base;
	_tmp0_ = ((screen*) self)->world;
	_tmp1_ = _tmp0_->playing_state;
	if (_tmp1_ != WORLD_WIDE_PLAYING_TYPE_play) {
		return;
	}
	_tmp2_ = self->priv->playlist_position_string;
	_tmp3_ = files_find_entry (self, _tmp2_);
	index = _tmp3_;
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			gboolean _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GList* _tmp8_;
			gint _tmp9_;
			gconstpointer _tmp10_ = NULL;
			gboolean _tmp11_;
			_tmp5_ = _tmp4_;
			if (!_tmp5_) {
			}
			_tmp4_ = FALSE;
			_tmp6_ = index;
			index = _tmp6_ - 1;
			_tmp7_ = index;
			if (_tmp7_ < 0) {
				break;
			}
			_tmp8_ = self->entry;
			_tmp9_ = index;
			_tmp10_ = g_list_nth_data (_tmp8_, (guint) _tmp9_);
			_tmp11_ = ((node*) _tmp10_)->is_dir;
			if (!_tmp11_) {
				break;
			}
		}
	}
	_tmp12_ = index;
	if (_tmp12_ < 0) {
		world_wide* _tmp13_;
		auditive* _tmp14_;
		_tmp13_ = ((screen*) self)->world;
		_tmp14_ = _tmp13_->player;
		auditive_stop (_tmp14_);
	} else {
		gint _tmp15_;
		GList* _tmp16_;
		gint _tmp17_;
		gconstpointer _tmp18_ = NULL;
		const gchar* _tmp19_;
		_tmp15_ = index;
		screen_zoom_to ((screen*) self, _tmp15_);
		_tmp16_ = self->entry;
		_tmp17_ = index;
		_tmp18_ = g_list_nth_data (_tmp16_, (guint) _tmp17_);
		_tmp19_ = ((node*) _tmp18_)->name;
		files_play_a_song (self, _tmp19_);
	}
}


static void files_real_advance_song (screen* base) {
	files * self;
	world_wide* _tmp0_;
	world_wideplaying_type _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint index;
	gint _tmp15_;
	self = (files*) base;
	_tmp0_ = ((screen*) self)->world;
	_tmp1_ = _tmp0_->playing_state;
	if (_tmp1_ != WORLD_WIDE_PLAYING_TYPE_play) {
		return;
	}
	_tmp2_ = self->priv->playlist_position_string;
	_tmp3_ = files_find_entry (self, _tmp2_);
	index = _tmp3_;
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			gboolean _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GList* _tmp9_;
			guint _tmp10_ = 0U;
			GList* _tmp11_;
			gint _tmp12_;
			gconstpointer _tmp13_ = NULL;
			gboolean _tmp14_;
			_tmp5_ = _tmp4_;
			if (!_tmp5_) {
			}
			_tmp4_ = FALSE;
			_tmp6_ = index;
			if (_tmp6_ < 0) {
				break;
			}
			_tmp7_ = index;
			index = _tmp7_ + 1;
			_tmp8_ = index;
			_tmp9_ = self->entry;
			_tmp10_ = g_list_length (_tmp9_);
			if (((guint) _tmp8_) >= _tmp10_) {
				index = -1;
				break;
			}
			_tmp11_ = self->entry;
			_tmp12_ = index;
			_tmp13_ = g_list_nth_data (_tmp11_, (guint) _tmp12_);
			_tmp14_ = ((node*) _tmp13_)->is_dir;
			if (!_tmp14_) {
				break;
			}
		}
	}
	_tmp15_ = index;
	if (_tmp15_ < 0) {
		world_wide* _tmp16_;
		auditive* _tmp17_;
		_tmp16_ = ((screen*) self)->world;
		_tmp17_ = _tmp16_->player;
		auditive_stop (_tmp17_);
	} else {
		gint _tmp18_;
		GList* _tmp19_;
		gint _tmp20_;
		gconstpointer _tmp21_ = NULL;
		const gchar* _tmp22_;
		_tmp18_ = index;
		screen_zoom_to ((screen*) self, _tmp18_);
		_tmp19_ = self->entry;
		_tmp20_ = index;
		_tmp21_ = g_list_nth_data (_tmp19_, (guint) _tmp20_);
		_tmp22_ = ((node*) _tmp21_)->name;
		files_play_a_song (self, _tmp22_);
	}
}


static void files_real_continue_songs (screen* base) {
	files * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint index;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_ = 0;
	GList* _tmp7_;
	gint _tmp8_;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	world_wide* _tmp12_;
	auditive* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	self = (files*) base;
	_tmp0_ = self->priv->playlist_position_string;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		return;
	}
	_tmp1_ = self->priv->playlist_position_string;
	_tmp2_ = files_find_entry (self, _tmp1_);
	index = _tmp2_;
	_tmp3_ = index;
	if (_tmp3_ < 0) {
		return;
	}
	_tmp4_ = index;
	index = _tmp4_ + 1;
	_tmp5_ = index;
	_tmp6_ = screen_get_size ((screen*) self);
	if (_tmp5_ >= _tmp6_) {
		return;
	}
	_tmp7_ = self->entry;
	_tmp8_ = index;
	_tmp9_ = g_list_nth_data (_tmp7_, (guint) _tmp8_);
	_tmp10_ = ((node*) _tmp9_)->name;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->gapless_position_string);
	self->priv->gapless_position_string = _tmp11_;
	_tmp12_ = ((screen*) self)->world;
	_tmp13_ = _tmp12_->player;
	_tmp14_ = self->path;
	_tmp15_ = g_strconcat (_tmp14_, "/", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->gapless_position_string;
	_tmp18_ = g_strconcat (_tmp16_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = remove_slashes (_tmp19_);
	_tmp21_ = _tmp20_;
	auditive_continue_playing (_tmp13_, _tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
}


static void files_real_continue_songs_draw (screen* base) {
	files * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint index;
	gint _tmp5_;
	gint _tmp6_;
	world_wide* _tmp7_;
	auditive* _tmp8_;
	self = (files*) base;
	_tmp0_ = self->priv->gapless_position_string;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		return;
	}
	_tmp1_ = self->priv->gapless_position_string;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->playlist_position_string);
	self->priv->playlist_position_string = _tmp2_;
	_tmp3_ = self->priv->playlist_position_string;
	_tmp4_ = files_find_entry (self, _tmp3_);
	index = _tmp4_;
	_tmp5_ = index;
	if (_tmp5_ < 0) {
		return;
	}
	_tmp6_ = index;
	screen_zoom_to ((screen*) self, _tmp6_);
	_tmp7_ = ((screen*) self)->world;
	_tmp8_ = _tmp7_->player;
	auditive_draw (_tmp8_);
}


static void files_real_reset_stop (screen* base) {
	files * self;
	gchar* _tmp0_;
	self = (files*) base;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->playlist_position_string);
	self->priv->playlist_position_string = _tmp0_;
}


static void files_real_key_press (screen* base, gint key_num) {
	files * self;
	gchar* _tmp0_;
	gchar* name;
	gchar* _tmp1_;
	gchar* full_path;
	gint index = 0;
	gint _tmp2_ = 0;
	guint size;
	world_wide* _tmp3_;
	GList* _tmp4_;
	guint _tmp5_ = 0U;
	gint files_screen_count;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	guint _tmp9_;
	gint _tmp22_;
	self = (files*) base;
	_tmp0_ = g_strdup ("");
	name = _tmp0_;
	_tmp1_ = g_strdup ("");
	full_path = _tmp1_;
	_tmp2_ = screen_get_size ((screen*) self);
	size = (guint) _tmp2_;
	_tmp3_ = ((screen*) self)->world;
	_tmp4_ = _tmp3_->files_array;
	_tmp5_ = g_list_length (_tmp4_);
	files_screen_count = (gint) _tmp5_;
	_tmp6_ = ((screen*) self)->screen_pos;
	_tmp7_ = ((screen*) self)->row_pos;
	index = (gint) (_tmp6_ + _tmp7_);
	_tmp8_ = index;
	_tmp9_ = size;
	if (((guint) _tmp8_) >= _tmp9_) {
		index = -1;
	} else {
		GList* _tmp10_;
		gint _tmp11_;
		gconstpointer _tmp12_ = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		_tmp10_ = self->entry;
		_tmp11_ = index;
		_tmp12_ = g_list_nth_data (_tmp10_, (guint) _tmp11_);
		_tmp13_ = ((node*) _tmp12_)->name;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (name);
		name = _tmp14_;
		_tmp15_ = self->path;
		_tmp16_ = g_strconcat (_tmp15_, "/", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = name;
		_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = remove_slashes (_tmp20_);
		_g_free0 (full_path);
		full_path = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
	}
	_tmp22_ = key_num;
	switch (_tmp22_) {
		world_wide* _tmp60_;
		key_maps* _tmp61_;
		world_wide* _tmp67_;
		key_maps* _tmp68_;
		world_wide* _tmp79_;
		key_maps* _tmp80_;
		case '\n':
		{
			gint _tmp23_;
			GList* _tmp24_;
			gint _tmp25_;
			gconstpointer _tmp26_ = NULL;
			gboolean _tmp27_;
			_tmp23_ = index;
			if (_tmp23_ < 0) {
				break;
			}
			_tmp24_ = self->entry;
			_tmp25_ = index;
			_tmp26_ = g_list_nth_data (_tmp24_, (guint) _tmp25_);
			_tmp27_ = ((node*) _tmp26_)->is_dir;
			if (_tmp27_ == TRUE) {
				world_wide* _tmp41_;
				const gchar* _tmp42_;
				files* _tmp43_;
				files* new_win;
				files* _tmp44_;
				{
					gint _tmp28_;
					gint i;
					_tmp28_ = files_screen_count;
					i = _tmp28_ - 1;
					{
						gboolean _tmp29_;
						_tmp29_ = TRUE;
						while (TRUE) {
							gboolean _tmp30_;
							gint _tmp32_;
							gint _tmp33_;
							world_wide* _tmp34_;
							GList* _tmp35_;
							gint _tmp36_;
							gconstpointer _tmp37_ = NULL;
							files* a_file;
							files* _tmp38_;
							world_wide* _tmp39_;
							files* _tmp40_;
							_tmp30_ = _tmp29_;
							if (!_tmp30_) {
								gint _tmp31_;
								_tmp31_ = i;
								i = _tmp31_ - 1;
							}
							_tmp29_ = FALSE;
							_tmp32_ = i;
							_tmp33_ = self->priv->files_position;
							if (!(_tmp32_ > _tmp33_)) {
								break;
							}
							_tmp34_ = ((screen*) self)->world;
							_tmp35_ = _tmp34_->files_array;
							_tmp36_ = i;
							_tmp37_ = g_list_nth_data (_tmp35_, (guint) _tmp36_);
							a_file = (files*) _tmp37_;
							_tmp38_ = a_file;
							screen_unref (_tmp38_);
							_tmp39_ = ((screen*) self)->world;
							_tmp40_ = a_file;
							_tmp39_->files_array = g_list_remove (_tmp39_->files_array, _tmp40_);
						}
					}
				}
				_tmp41_ = ((screen*) self)->world;
				_tmp42_ = full_path;
				_tmp43_ = files_new (_tmp41_, _tmp42_);
				new_win = _tmp43_;
				_tmp44_ = new_win;
				screen_draw ((screen*) _tmp44_);
			} else {
				const gchar* _tmp45_;
				gboolean _tmp46_ = FALSE;
				_tmp45_ = name;
				_tmp46_ = g_str_has_suffix (_tmp45_, ".m3u");
				if (_tmp46_) {
					world_wide* _tmp47_;
					viewlist* _tmp48_;
					world_wide* _tmp51_;
					world_wide* _tmp52_;
					const gchar* _tmp53_;
					viewlist* _tmp54_;
					world_wide* _tmp55_;
					viewlist* _tmp56_;
					_tmp47_ = ((screen*) self)->world;
					_tmp48_ = _tmp47_->view_screen;
					if (_tmp48_ != NULL) {
						world_wide* _tmp49_;
						viewlist* _tmp50_;
						_tmp49_ = ((screen*) self)->world;
						_tmp50_ = _tmp49_->view_screen;
						playlist_empty ((playlist*) _tmp50_);
					}
					_tmp51_ = ((screen*) self)->world;
					_tmp52_ = ((screen*) self)->world;
					_tmp53_ = full_path;
					_tmp54_ = viewlist_new_view_start (_tmp52_, _tmp53_);
					_tmp51_->view_screen = _tmp54_;
					_tmp55_ = ((screen*) self)->world;
					_tmp56_ = _tmp55_->view_screen;
					screen_draw ((screen*) _tmp56_);
				} else {
					const gchar* _tmp57_;
					world_wide* _tmp58_;
					auditive* _tmp59_;
					_tmp57_ = name;
					files_play_a_song (self, _tmp57_);
					_tmp58_ = ((screen*) self)->world;
					_tmp59_ = _tmp58_->player;
					auditive_draw (_tmp59_);
				}
			}
			break;
		}
		_tmp60_ = ((screen*) self)->world;
		_tmp61_ = _tmp60_->keys;
		case KEY_MAPS_key_left:
		{
			gint _tmp62_;
			world_wide* _tmp63_;
			GList* _tmp64_;
			gint _tmp65_;
			gconstpointer _tmp66_ = NULL;
			_tmp62_ = self->priv->files_position;
			if (_tmp62_ <= 0) {
				break;
			}
			_tmp63_ = ((screen*) self)->world;
			_tmp64_ = _tmp63_->files_array;
			_tmp65_ = self->priv->files_position;
			_tmp66_ = g_list_nth_data (_tmp64_, (guint) (_tmp65_ - 1));
			screen_draw ((screen*) _tmp66_);
			break;
		}
		_tmp67_ = ((screen*) self)->world;
		_tmp68_ = _tmp67_->keys;
		case KEY_MAPS_key_right:
		{
			gint _tmp69_;
			gint _tmp70_;
			_tmp69_ = self->priv->files_position;
			_tmp70_ = files_screen_count;
			if (_tmp69_ < (_tmp70_ - 1)) {
				world_wide* _tmp71_;
				GList* _tmp72_;
				gint _tmp73_;
				gconstpointer _tmp74_ = NULL;
				_tmp71_ = ((screen*) self)->world;
				_tmp72_ = _tmp71_->files_array;
				_tmp73_ = self->priv->files_position;
				_tmp74_ = g_list_nth_data (_tmp72_, (guint) (_tmp73_ + 1));
				screen_draw ((screen*) _tmp74_);
			}
			break;
		}
		case '\t':
		{
			filesdisplay_type _tmp75_;
			gint num;
			gint _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			_tmp75_ = self->priv->display_mode;
			num = (gint) _tmp75_;
			_tmp76_ = num;
			num = _tmp76_ + 1;
			_tmp77_ = num;
			if (_tmp77_ >= ((gint) FILES_DISPLAY_TYPE_end)) {
				num = 0;
			}
			_tmp78_ = num;
			self->priv->display_mode = (filesdisplay_type) _tmp78_;
			screen_draw ((screen*) self);
			break;
		}
		_tmp79_ = ((screen*) self)->world;
		_tmp80_ = _tmp79_->keys;
		case KEY_MAPS_key_shift_tab:
		{
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			gint _tmp83_ = 0;
			gint new_index;
			gint _tmp84_;
			_tmp81_ = name;
			if (g_strcmp0 (_tmp81_, "") == 0) {
				break;
			}
			files_rescan (self);
			files_sort (self);
			_tmp82_ = name;
			_tmp83_ = files_find_entry (self, _tmp82_);
			new_index = _tmp83_;
			_tmp84_ = new_index;
			if (_tmp84_ >= 0) {
				gint _tmp85_;
				_tmp85_ = new_index;
				screen_zoom_to ((screen*) self, _tmp85_);
			} else {
				gint _tmp86_;
				((screen*) self)->row_pos = 0;
				_tmp86_ = ((screen*) self)->row_pos;
				((screen*) self)->screen_pos = _tmp86_;
			}
			screen_draw ((screen*) self);
			break;
		}
		case ';':
		{
			gint _tmp87_;
			files_rescan (self);
			files_sort_age_reverse (self);
			((screen*) self)->row_pos = 0;
			_tmp87_ = ((screen*) self)->row_pos;
			((screen*) self)->screen_pos = _tmp87_;
			self->priv->display_mode = FILES_DISPLAY_TYPE_name;
			screen_draw ((screen*) self);
			break;
		}
		default:
		{
			world_wide* _tmp88_;
			external* _tmp89_;
			gint _tmp90_;
			externalkey_handled _tmp91_ = 0;
			_tmp88_ = ((screen*) self)->world;
			_tmp89_ = _tmp88_->ext_screen;
			_tmp90_ = key_num;
			_tmp91_ = external_external_key_press (_tmp89_, _tmp90_);
			switch (_tmp91_) {
				case EXTERNAL_KEY_HANDLED_resync:
				{
					break;
				}
				case EXTERNAL_KEY_HANDLED_none:
				{
					gint _tmp92_;
					_tmp92_ = key_num;
					SCREEN_CLASS (files_parent_class)->key_press (SCREEN (self), _tmp92_);
					break;
				}
				default:
				break;
			}
			break;
		}
	}
	_g_free0 (full_path);
	_g_free0 (name);
}


static gint files_find_entry (files* self, const gchar* name) {
	gint result = 0;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			gint _tmp3_;
			GList* _tmp4_;
			guint _tmp5_ = 0U;
			const gchar* _tmp6_;
			GList* _tmp7_;
			gint _tmp8_;
			gconstpointer _tmp9_ = NULL;
			const gchar* _tmp10_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = i;
			_tmp4_ = self->entry;
			_tmp5_ = g_list_length (_tmp4_);
			if (!(((guint) _tmp3_) < _tmp5_)) {
				break;
			}
			_tmp6_ = name;
			_tmp7_ = self->entry;
			_tmp8_ = i;
			_tmp9_ = g_list_nth_data (_tmp7_, (guint) _tmp8_);
			_tmp10_ = ((node*) _tmp9_)->name;
			if (g_strcmp0 (_tmp6_, _tmp10_) == 0) {
				result = i;
				return result;
			}
		}
	}
	result = -1;
	return result;
}


void files_sort (files* self) {
	filesdisplay_type _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display_mode;
	switch (_tmp0_) {
		case FILES_DISPLAY_TYPE_name:
		{
			files_sort_name (self);
			break;
		}
		case FILES_DISPLAY_TYPE_size:
		{
			files_sort_size (self);
			break;
		}
		case FILES_DISPLAY_TYPE_age:
		{
			files_sort_age (self);
			break;
		}
		default:
		break;
	}
}


void files_zoom_to_name (files* self, const gchar* name) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint index;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = files_find_entry (self, _tmp0_);
	index = _tmp1_;
	_tmp2_ = index;
	if (_tmp2_ >= 0) {
		gint _tmp3_;
		_tmp3_ = index;
		screen_zoom_to ((screen*) self, _tmp3_);
	}
	return;
}


static void files_class_init (filesClass * klass) {
	files_parent_class = g_type_class_peek_parent (klass);
	SCREEN_CLASS (klass)->finalize = files_finalize;
	g_type_class_add_private (klass, sizeof (filesPrivate));
	SCREEN_CLASS (klass)->get_title = files_real_get_title;
	SCREEN_CLASS (klass)->get_size = files_real_get_size;
	SCREEN_CLASS (klass)->calc_target = files_real_calc_target;
	SCREEN_CLASS (klass)->get_line = files_real_get_line;
	SCREEN_CLASS (klass)->get_screen_type = files_real_get_screen_type;
	SCREEN_CLASS (klass)->draw = files_real_draw;
	SCREEN_CLASS (klass)->previous_song = files_real_previous_song;
	SCREEN_CLASS (klass)->advance_song = files_real_advance_song;
	SCREEN_CLASS (klass)->continue_songs = files_real_continue_songs;
	SCREEN_CLASS (klass)->continue_songs_draw = files_real_continue_songs_draw;
	SCREEN_CLASS (klass)->reset_stop = files_real_reset_stop;
	SCREEN_CLASS (klass)->key_press = files_real_key_press;
}


static void files_instance_init (files * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = FILES_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->playlist_position_string = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->gapless_position_string = _tmp1_;
}


static void files_finalize (screen* obj) {
	files * self;
	self = FILES (obj);
	_g_free0 (self->path);
	__g_list_free__node_unref0_0 (self->entry);
	_g_free0 (self->priv->playlist_position_string);
	_g_free0 (self->priv->gapless_position_string);
	SCREEN_CLASS (files_parent_class)->finalize (obj);
}


GType files_get_type (void) {
	static volatile gsize files_type_id__volatile = 0;
	if (g_once_init_enter (&files_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (filesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (files), 0, (GInstanceInitFunc) files_instance_init, NULL };
		GType files_type_id;
		files_type_id = g_type_register_static (TYPE_SCREEN, "files", &g_define_type_info, 0);
		g_once_init_leave (&files_type_id__volatile, files_type_id);
	}
	return files_type_id__volatile;
}


void start_from_new_path (world_wide* world, const gchar* full_path, gboolean do_draw, const gchar* zoom_into) {
	gchar** bits = NULL;
	gint bits_length1 = 0;
	gint _bits_size_ = 0;
	gchar* expand = NULL;
	gchar* node = NULL;
	gint i = 0;
	files* last = NULL;
	world_wide* _tmp0_;
	GList* _tmp1_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_ = NULL;
	world_wide* _tmp10_;
	files* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	files* _tmp37_;
	g_return_if_fail (full_path != NULL);
	g_return_if_fail (zoom_into != NULL);
	_tmp0_ = world;
	_tmp1_ = _tmp0_->files_array;
	{
		GList* a_file_collection = NULL;
		GList* a_file_it = NULL;
		a_file_collection = _tmp1_;
		for (a_file_it = a_file_collection; a_file_it != NULL; a_file_it = a_file_it->next) {
			files* a_file = NULL;
			a_file = a_file_it->data;
			{
				files* _tmp2_;
				world_wide* _tmp3_;
				files* _tmp4_;
				_tmp2_ = a_file;
				screen_unref (_tmp2_);
				_tmp3_ = world;
				_tmp4_ = a_file;
				_tmp3_->files_array = g_list_remove (_tmp3_->files_array, _tmp4_);
			}
		}
	}
	_tmp5_ = full_path;
	_tmp6_ = remove_slashes (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "/", 0);
	bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
	bits = _tmp9_;
	bits_length1 = _vala_array_length (_tmp8_);
	_bits_size_ = bits_length1;
	_g_free0 (_tmp7_);
	_tmp10_ = world;
	_tmp11_ = files_new (_tmp10_, "/");
	last = _tmp11_;
	_tmp12_ = g_strdup ("/");
	_g_free0 (expand);
	expand = _tmp12_;
	{
		gboolean _tmp13_;
		i = 0;
		_tmp13_ = TRUE;
		while (TRUE) {
			gboolean _tmp14_;
			gint _tmp16_;
			gchar** _tmp17_;
			gint _tmp17__length1;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gint _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			gint _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			world_wide* _tmp30_;
			const gchar* _tmp31_;
			files* _tmp32_;
			_tmp14_ = _tmp13_;
			if (!_tmp14_) {
				gint _tmp15_;
				_tmp15_ = i;
				i = _tmp15_ + 1;
			}
			_tmp13_ = FALSE;
			_tmp16_ = i;
			_tmp17_ = bits;
			_tmp17__length1 = bits_length1;
			if (!(_tmp16_ < _tmp17__length1)) {
				break;
			}
			_tmp18_ = bits;
			_tmp18__length1 = bits_length1;
			_tmp19_ = i;
			_tmp20_ = _tmp18_[_tmp19_];
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (node);
			node = _tmp21_;
			_tmp22_ = node;
			if (g_strcmp0 (_tmp22_, "") == 0) {
				continue;
			}
			_tmp23_ = expand;
			_tmp24_ = g_strconcat (_tmp23_, "/", NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = bits;
			_tmp26__length1 = bits_length1;
			_tmp27_ = i;
			_tmp28_ = _tmp26_[_tmp27_];
			_tmp29_ = g_strconcat (_tmp25_, _tmp28_, NULL);
			_g_free0 (expand);
			expand = _tmp29_;
			_g_free0 (_tmp25_);
			_tmp30_ = world;
			_tmp31_ = expand;
			_tmp32_ = files_new (_tmp30_, _tmp31_);
			last = _tmp32_;
		}
	}
	_tmp33_ = do_draw;
	if (_tmp33_ == FALSE) {
		_g_free0 (node);
		_g_free0 (expand);
		bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp34_ = zoom_into;
	if (g_strcmp0 (_tmp34_, "") != 0) {
		files* _tmp35_;
		const gchar* _tmp36_;
		_tmp35_ = last;
		_tmp36_ = zoom_into;
		files_zoom_to_name (_tmp35_, _tmp36_);
	}
	_tmp37_ = last;
	screen_draw ((screen*) _tmp37_);
	_g_free0 (node);
	_g_free0 (expand);
	bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



