"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _iterateJsdoc = _interopRequireDefault(require("../iterateJsdoc"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const anyWhitespaceLines = /^\s*$/u;
const atLeastTwoLinesWhitespace = /^[ \t]*\n[ \t]*\n\s*$/u;
var _default = (0, _iterateJsdoc.default)(({
  jsdoc,
  utils
}) => {
  const {
    description,
    descriptions,
    lastDescriptionLine
  } = utils.getDescription();
  const regex = jsdoc.tags.length ? anyWhitespaceLines : atLeastTwoLinesWhitespace;
  if (descriptions.length && regex.test(description)) {
    if (jsdoc.tags.length) {
      utils.reportJSDoc('There should be no blank lines in block descriptions followed by tags.', {
        line: lastDescriptionLine
      }, () => {
        utils.setBlockDescription(() => {
          // Remove all lines
          return [];
        });
      });
    } else {
      utils.reportJSDoc('There should be no extra blank lines in block descriptions not followed by tags.', {
        line: lastDescriptionLine
      }, () => {
        utils.setBlockDescription((info, seedTokens) => {
          return [
          // Keep the starting line
          {
            number: 0,
            source: '',
            tokens: seedTokens({
              ...info,
              description: ''
            })
          }];
        });
      });
    }
  }
}, {
  iterateAllJsdocs: true,
  meta: {
    docs: {
      description: 'Detects and removes extra lines of a blank block description',
      url: 'https://github.com/gajus/eslint-plugin-jsdoc#eslint-plugin-jsdoc-rules-no-blank-block-descriptions'
    },
    fixable: 'whitespace',
    schema: [],
    type: 'layout'
  }
});
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=noBlankBlockDescriptions.js.map