/// <reference types="node" />
import * as config from './config';
import * as tuf from './tuf';
import * as sigstore from './types/sigstore';
export declare function sign(payload: Buffer, options?: config.SignOptions): Promise<sigstore.SerializedBundle>;
export declare function attest(payload: Buffer, payloadType: string, options?: config.SignOptions): Promise<sigstore.SerializedBundle>;
export declare function verify(bundle: sigstore.SerializedBundle, payload?: Buffer, options?: config.VerifyOptions): Promise<void>;
declare const tufUtils: {
    client: (options?: config.TUFOptions) => Promise<tuf.TUF>;
    getTarget: (path: string, options?: config.TUFOptions) => Promise<string>;
};
export type { SignOptions, VerifyOptions } from './config';
export { InternalError, PolicyError, ValidationError, VerificationError, } from './error';
export * as utils from './sigstore-utils';
export type { TUF } from './tuf';
export type { SerializedBundle as Bundle, SerializedEnvelope as Envelope, } from './types/sigstore';
export { tufUtils as tuf };
export declare const DEFAULT_FULCIO_URL = "https://fulcio.sigstore.dev";
export declare const DEFAULT_REKOR_URL = "https://rekor.sigstore.dev";
