#!/usr/bin/env bash

if [[ $# -eq 0 ]]
then
    echo "Provide version number!"
    exit
fi

read -p "Updated the CHANGES file in doc-pak directory (y/n)? " ANSWER
if [[ $ANSWER != "y" ]]
then
    exit
fi

cp doc-pak/CHANGES doc-pak/changelog
gzip -9 doc-pak/changelog

autoconf
./configure --prefix=/usr
make clean
make
sudo checkinstall --install=no --type=debian --pkgname=bacon --pkgversion=$1 --pkgrelease=1 --pkggroup=devel --pkglicense=MIT --maintainer="Peter van Eerten \<peter@basic-converter.org\>" --provides=bacon --requires=enscript,xterm,indent,flex

rm doc-pak/changelog.gz
