/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  /usr/bin/gengetopt --file-name=cvc-create-cmdline --output-dir=. 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cvc-create-cmdline.h"

const char *gengetopt_args_info_purpose = "Create a card verifiable certificate";

const char *gengetopt_args_info_usage = "Usage: cvc-create [OPTIONS]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                 Print help and exit",
  "  -V, --version              Print version and exit",
  "      --out-cert=FILENAME    Where to save the certificate\n                               (default=`CHR.cvcert')",
  "      --role=ENUM            The terminal's role  (possible values=\"cvca\",\n                               \"dv_domestic\", \"dv_foreign\", \"terminal\")",
  "      --type=ENUM            Type of the terminal (Authentication Terminal,\n                               Inspection System or Signature Terminal)\n                               (possible values=\"at\", \"is\", \"st\",\n                               \"derived_from_signer\"\n                               default=`derived_from_signer')",
  "      --issued=YYMMDD        Date the certificate was issued  (default=`today')",
  "      --expires=YYMMDD       Date until the certicate is valid",
  "      --sign-with=FILENAME   Private key for signing the new certificate",
  "      --scheme=ENUM          Signature scheme that the new terminal will use\n                               (possible values=\"ECDSA_SHA_1\",\n                               \"ECDSA_SHA_224\", \"ECDSA_SHA_256\",\n                               \"ECDSA_SHA_384\", \"ECDSA_SHA_512\",\n                               \"RSA_v1_5_SHA_1\", \"RSA_v1_5_SHA_256\",\n                               \"RSA_v1_5_SHA_512\", \"RSA_PSS_SHA_1\",\n                               \"RSA_PSS_SHA_256\", \"RSA_PSS_SHA_512\")",
  "\n Mode: csr\n  The properties of the certificate are derived from the given signing request.",
  "      --csr=FILENAME         Certificate signing request with the attributes",
  "\n Mode: manual\n  The properties of the certificate are derived from the command line switches.",
  "      --chr=CCH...HSSSSS     Certificate holder reference (2 characters ISO\n                               3166-1 ALPHA-2 country code, 0-9 characters\n                               ISO/IEC 8859-1 holder mnemonic, 5 characters\n                               ISO/IEC 8859-1 numeric or alphanumeric sequence\n                               number)",
  "      --sign-as=FILENAME     CV certificate of the entity signing the new\n                               certificate  (default=`self signed')",
  "      --key=FILENAME         Private key of the Terminal  (default=`derived\n                               from signer')",
  "      --out-key=FILENAME     Where to save the derived private key\n                               (default=`CHR.pkcs8')",
  "\nOptions for an Authentication Terminal (AT):",
  "      --out-desc=FILENAME    Where to save the encoded certificate description\n                               (default=`CHR.desc')",
  "      --cert-desc=FILENAME   Terms of usage as part of the certificate\n                               description (*.txt, *.html or *.pdf)",
  "      --issuer-name=STRING   Name of the issuer of this certificate\n                               (certificate description)",
  "      --issuer-url=URL       URL that points to informations about the issuer\n                               of this certificate (certificate description)",
  "      --subject-name=STRING  Name of the holder of this certificate\n                               (certificate description)",
  "      --subject-url=URL      URL that points to informations about the subject\n                               of this certificate (certificate description)",
  "      --write-dg17           Allow writing DG 17 (Normal Place of Residence)\n                               (default=off)",
  "      --write-dg18           Allow writing DG 18 (Community ID)  (default=off)",
  "      --write-dg19           Allow writing DG 19 (Residence Permit I)\n                               (default=off)",
  "      --write-dg20           Allow writing DG 20 (Residence Permit II)\n                               (default=off)",
  "      --write-dg21           Allow writing DG 21 (Optional Data)  (default=off)",
  "      --at-rfu32             Allow RFU R/W Access bit 32  (default=off)",
  "      --at-rfu31             Allow RFU R/W Access bit 31  (default=off)",
  "      --at-rfu30             Allow RFU R/W Access bit 30  (default=off)",
  "      --at-rfu29             Allow RFU R/W Access bit 29  (default=off)",
  "      --read-dg1             Allow reading DG 1   (Document Type)\n                               (default=off)",
  "      --read-dg2             Allow reading DG 2   (Issuing State)\n                               (default=off)",
  "      --read-dg3             Allow reading DG 3   (Date of Expiry)\n                               (default=off)",
  "      --read-dg4             Allow reading DG 4   (Given Names)  (default=off)",
  "      --read-dg5             Allow reading DG 5   (Family Names)  (default=off)",
  "      --read-dg6             Allow reading DG 6   (Religious/Artistic Name)\n                               (default=off)",
  "      --read-dg7             Allow reading DG 7   (Academic Title)\n                               (default=off)",
  "      --read-dg8             Allow reading DG 8   (Date of Birth)\n                               (default=off)",
  "      --read-dg9             Allow reading DG 9   (Place of Birth)\n                               (default=off)",
  "      --read-dg10            Allow reading DG 10  (Nationality)  (default=off)",
  "      --read-dg11            Allow reading DG 11  (Sex)  (default=off)",
  "      --read-dg12            Allow reading DG 12  (Optional Data)\n                               (default=off)",
  "      --read-dg13            Allow reading DG 13  (default=off)",
  "      --read-dg14            Allow reading DG 14  (default=off)",
  "      --read-dg15            Allow reading DG 15  (default=off)",
  "      --read-dg16            Allow reading DG 16  (default=off)",
  "      --read-dg17            Allow reading DG 17  (Normal Place of Residence)\n                               (default=off)",
  "      --read-dg18            Allow reading DG 18  (Community ID)  (default=off)",
  "      --read-dg19            Allow reading DG 19  (Residence Permit I)\n                               (default=off)",
  "      --read-dg20            Allow reading DG 20  (Residence Permit II)\n                               (default=off)",
  "      --read-dg21            Allow reading DG 21  (Optional Data)\n                               (default=off)",
  "      --install-qual-cert    Allow installing qualified certificate\n                               (default=off)",
  "      --install-cert         Allow installing certificate  (default=off)",
  "      --pin-management       Allow PIN management  (default=off)",
  "      --can-allowed          CAN allowed  (default=off)",
  "      --privileged           Privileged terminal  (default=off)",
  "      --rid                  Allow restricted identification  (default=off)",
  "      --verify-community     Allow community ID verification  (default=off)",
  "      --verify-age           Allow age verification  (default=off)",
  "\nOptions for a Signature Terminal (ST):",
  "      --st-rfu5              Allow RFU bit 5  (default=off)",
  "      --st-rfu4              Allow RFU bit 4  (default=off)",
  "      --st-rfu3              Allow RFU bit 3  (default=off)",
  "      --st-rfu2              Allow RFU bit 2  (default=off)",
  "      --gen-qualified-sig    Generate qualified electronic signature\n                               (default=off)",
  "      --gen-sig              Generate electronic signature  (default=off)",
  "\nOptions for an Inspection System (IS):",
  "      --read-eid             Read access to eID application (Deprecated)\n                               (default=off)",
  "      --is-rfu4              Allow RFU bit 4  (default=off)",
  "      --is-rfu3              Allow RFU bit 3  (default=off)",
  "      --is-rfu2              Allow RFU bit 2  (default=off)",
  "      --read-iris            Read access to ePassport application: DG 4 (Iris)\n                               (default=off)",
  "      --read-finger          Read access to ePassport application: DG 3\n                               (Fingerprint)  (default=off)",
  "\nReport bugs to https://github.com/frankmorgner/openpace/issues\n\nWritten by Frank Morgner <frankmorgner@gmail.com>",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_ENUM
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

const char *cmdline_parser_role_values[] = {"cvca", "dv_domestic", "dv_foreign", "terminal", 0}; /*< Possible values for role. */
const char *cmdline_parser_type_values[] = {"at", "is", "st", "derived_from_signer", 0}; /*< Possible values for type. */
const char *cmdline_parser_scheme_values[] = {"ECDSA_SHA_1", "ECDSA_SHA_224", "ECDSA_SHA_256", "ECDSA_SHA_384", "ECDSA_SHA_512", "RSA_v1_5_SHA_1", "RSA_v1_5_SHA_256", "RSA_v1_5_SHA_512", "RSA_PSS_SHA_1", "RSA_PSS_SHA_256", "RSA_PSS_SHA_512", 0}; /*< Possible values for scheme. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->out_cert_given = 0 ;
  args_info->role_given = 0 ;
  args_info->type_given = 0 ;
  args_info->issued_given = 0 ;
  args_info->expires_given = 0 ;
  args_info->sign_with_given = 0 ;
  args_info->scheme_given = 0 ;
  args_info->csr_given = 0 ;
  args_info->chr_given = 0 ;
  args_info->sign_as_given = 0 ;
  args_info->key_given = 0 ;
  args_info->out_key_given = 0 ;
  args_info->out_desc_given = 0 ;
  args_info->cert_desc_given = 0 ;
  args_info->issuer_name_given = 0 ;
  args_info->issuer_url_given = 0 ;
  args_info->subject_name_given = 0 ;
  args_info->subject_url_given = 0 ;
  args_info->write_dg17_given = 0 ;
  args_info->write_dg18_given = 0 ;
  args_info->write_dg19_given = 0 ;
  args_info->write_dg20_given = 0 ;
  args_info->write_dg21_given = 0 ;
  args_info->at_rfu32_given = 0 ;
  args_info->at_rfu31_given = 0 ;
  args_info->at_rfu30_given = 0 ;
  args_info->at_rfu29_given = 0 ;
  args_info->read_dg1_given = 0 ;
  args_info->read_dg2_given = 0 ;
  args_info->read_dg3_given = 0 ;
  args_info->read_dg4_given = 0 ;
  args_info->read_dg5_given = 0 ;
  args_info->read_dg6_given = 0 ;
  args_info->read_dg7_given = 0 ;
  args_info->read_dg8_given = 0 ;
  args_info->read_dg9_given = 0 ;
  args_info->read_dg10_given = 0 ;
  args_info->read_dg11_given = 0 ;
  args_info->read_dg12_given = 0 ;
  args_info->read_dg13_given = 0 ;
  args_info->read_dg14_given = 0 ;
  args_info->read_dg15_given = 0 ;
  args_info->read_dg16_given = 0 ;
  args_info->read_dg17_given = 0 ;
  args_info->read_dg18_given = 0 ;
  args_info->read_dg19_given = 0 ;
  args_info->read_dg20_given = 0 ;
  args_info->read_dg21_given = 0 ;
  args_info->install_qual_cert_given = 0 ;
  args_info->install_cert_given = 0 ;
  args_info->pin_management_given = 0 ;
  args_info->can_allowed_given = 0 ;
  args_info->privileged_given = 0 ;
  args_info->rid_given = 0 ;
  args_info->verify_community_given = 0 ;
  args_info->verify_age_given = 0 ;
  args_info->st_rfu5_given = 0 ;
  args_info->st_rfu4_given = 0 ;
  args_info->st_rfu3_given = 0 ;
  args_info->st_rfu2_given = 0 ;
  args_info->gen_qualified_sig_given = 0 ;
  args_info->gen_sig_given = 0 ;
  args_info->read_eid_given = 0 ;
  args_info->is_rfu4_given = 0 ;
  args_info->is_rfu3_given = 0 ;
  args_info->is_rfu2_given = 0 ;
  args_info->read_iris_given = 0 ;
  args_info->read_finger_given = 0 ;
  args_info->csr_mode_counter = 0 ;
  args_info->manual_mode_counter = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->out_cert_arg = gengetopt_strdup ("CHR.cvcert");
  args_info->out_cert_orig = NULL;
  args_info->role_arg = role__NULL;
  args_info->role_orig = NULL;
  args_info->type_arg = type_arg_derived_from_signer;
  args_info->type_orig = NULL;
  args_info->issued_arg = gengetopt_strdup ("today");
  args_info->issued_orig = NULL;
  args_info->expires_arg = NULL;
  args_info->expires_orig = NULL;
  args_info->sign_with_arg = NULL;
  args_info->sign_with_orig = NULL;
  args_info->scheme_arg = scheme__NULL;
  args_info->scheme_orig = NULL;
  args_info->csr_arg = NULL;
  args_info->csr_orig = NULL;
  args_info->chr_arg = NULL;
  args_info->chr_orig = NULL;
  args_info->sign_as_arg = gengetopt_strdup ("self signed");
  args_info->sign_as_orig = NULL;
  args_info->key_arg = gengetopt_strdup ("derived from signer");
  args_info->key_orig = NULL;
  args_info->out_key_arg = gengetopt_strdup ("CHR.pkcs8");
  args_info->out_key_orig = NULL;
  args_info->out_desc_arg = gengetopt_strdup ("CHR.desc");
  args_info->out_desc_orig = NULL;
  args_info->cert_desc_arg = NULL;
  args_info->cert_desc_orig = NULL;
  args_info->issuer_name_arg = NULL;
  args_info->issuer_name_orig = NULL;
  args_info->issuer_url_arg = NULL;
  args_info->issuer_url_orig = NULL;
  args_info->subject_name_arg = NULL;
  args_info->subject_name_orig = NULL;
  args_info->subject_url_arg = NULL;
  args_info->subject_url_orig = NULL;
  args_info->write_dg17_flag = 0;
  args_info->write_dg18_flag = 0;
  args_info->write_dg19_flag = 0;
  args_info->write_dg20_flag = 0;
  args_info->write_dg21_flag = 0;
  args_info->at_rfu32_flag = 0;
  args_info->at_rfu31_flag = 0;
  args_info->at_rfu30_flag = 0;
  args_info->at_rfu29_flag = 0;
  args_info->read_dg1_flag = 0;
  args_info->read_dg2_flag = 0;
  args_info->read_dg3_flag = 0;
  args_info->read_dg4_flag = 0;
  args_info->read_dg5_flag = 0;
  args_info->read_dg6_flag = 0;
  args_info->read_dg7_flag = 0;
  args_info->read_dg8_flag = 0;
  args_info->read_dg9_flag = 0;
  args_info->read_dg10_flag = 0;
  args_info->read_dg11_flag = 0;
  args_info->read_dg12_flag = 0;
  args_info->read_dg13_flag = 0;
  args_info->read_dg14_flag = 0;
  args_info->read_dg15_flag = 0;
  args_info->read_dg16_flag = 0;
  args_info->read_dg17_flag = 0;
  args_info->read_dg18_flag = 0;
  args_info->read_dg19_flag = 0;
  args_info->read_dg20_flag = 0;
  args_info->read_dg21_flag = 0;
  args_info->install_qual_cert_flag = 0;
  args_info->install_cert_flag = 0;
  args_info->pin_management_flag = 0;
  args_info->can_allowed_flag = 0;
  args_info->privileged_flag = 0;
  args_info->rid_flag = 0;
  args_info->verify_community_flag = 0;
  args_info->verify_age_flag = 0;
  args_info->st_rfu5_flag = 0;
  args_info->st_rfu4_flag = 0;
  args_info->st_rfu3_flag = 0;
  args_info->st_rfu2_flag = 0;
  args_info->gen_qualified_sig_flag = 0;
  args_info->gen_sig_flag = 0;
  args_info->read_eid_flag = 0;
  args_info->is_rfu4_flag = 0;
  args_info->is_rfu3_flag = 0;
  args_info->is_rfu2_flag = 0;
  args_info->read_iris_flag = 0;
  args_info->read_finger_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->out_cert_help = gengetopt_args_info_help[2] ;
  args_info->role_help = gengetopt_args_info_help[3] ;
  args_info->type_help = gengetopt_args_info_help[4] ;
  args_info->issued_help = gengetopt_args_info_help[5] ;
  args_info->expires_help = gengetopt_args_info_help[6] ;
  args_info->sign_with_help = gengetopt_args_info_help[7] ;
  args_info->scheme_help = gengetopt_args_info_help[8] ;
  args_info->csr_help = gengetopt_args_info_help[10] ;
  args_info->chr_help = gengetopt_args_info_help[12] ;
  args_info->sign_as_help = gengetopt_args_info_help[13] ;
  args_info->key_help = gengetopt_args_info_help[14] ;
  args_info->out_key_help = gengetopt_args_info_help[15] ;
  args_info->out_desc_help = gengetopt_args_info_help[17] ;
  args_info->cert_desc_help = gengetopt_args_info_help[18] ;
  args_info->issuer_name_help = gengetopt_args_info_help[19] ;
  args_info->issuer_url_help = gengetopt_args_info_help[20] ;
  args_info->subject_name_help = gengetopt_args_info_help[21] ;
  args_info->subject_url_help = gengetopt_args_info_help[22] ;
  args_info->write_dg17_help = gengetopt_args_info_help[23] ;
  args_info->write_dg18_help = gengetopt_args_info_help[24] ;
  args_info->write_dg19_help = gengetopt_args_info_help[25] ;
  args_info->write_dg20_help = gengetopt_args_info_help[26] ;
  args_info->write_dg21_help = gengetopt_args_info_help[27] ;
  args_info->at_rfu32_help = gengetopt_args_info_help[28] ;
  args_info->at_rfu31_help = gengetopt_args_info_help[29] ;
  args_info->at_rfu30_help = gengetopt_args_info_help[30] ;
  args_info->at_rfu29_help = gengetopt_args_info_help[31] ;
  args_info->read_dg1_help = gengetopt_args_info_help[32] ;
  args_info->read_dg2_help = gengetopt_args_info_help[33] ;
  args_info->read_dg3_help = gengetopt_args_info_help[34] ;
  args_info->read_dg4_help = gengetopt_args_info_help[35] ;
  args_info->read_dg5_help = gengetopt_args_info_help[36] ;
  args_info->read_dg6_help = gengetopt_args_info_help[37] ;
  args_info->read_dg7_help = gengetopt_args_info_help[38] ;
  args_info->read_dg8_help = gengetopt_args_info_help[39] ;
  args_info->read_dg9_help = gengetopt_args_info_help[40] ;
  args_info->read_dg10_help = gengetopt_args_info_help[41] ;
  args_info->read_dg11_help = gengetopt_args_info_help[42] ;
  args_info->read_dg12_help = gengetopt_args_info_help[43] ;
  args_info->read_dg13_help = gengetopt_args_info_help[44] ;
  args_info->read_dg14_help = gengetopt_args_info_help[45] ;
  args_info->read_dg15_help = gengetopt_args_info_help[46] ;
  args_info->read_dg16_help = gengetopt_args_info_help[47] ;
  args_info->read_dg17_help = gengetopt_args_info_help[48] ;
  args_info->read_dg18_help = gengetopt_args_info_help[49] ;
  args_info->read_dg19_help = gengetopt_args_info_help[50] ;
  args_info->read_dg20_help = gengetopt_args_info_help[51] ;
  args_info->read_dg21_help = gengetopt_args_info_help[52] ;
  args_info->install_qual_cert_help = gengetopt_args_info_help[53] ;
  args_info->install_cert_help = gengetopt_args_info_help[54] ;
  args_info->pin_management_help = gengetopt_args_info_help[55] ;
  args_info->can_allowed_help = gengetopt_args_info_help[56] ;
  args_info->privileged_help = gengetopt_args_info_help[57] ;
  args_info->rid_help = gengetopt_args_info_help[58] ;
  args_info->verify_community_help = gengetopt_args_info_help[59] ;
  args_info->verify_age_help = gengetopt_args_info_help[60] ;
  args_info->st_rfu5_help = gengetopt_args_info_help[62] ;
  args_info->st_rfu4_help = gengetopt_args_info_help[63] ;
  args_info->st_rfu3_help = gengetopt_args_info_help[64] ;
  args_info->st_rfu2_help = gengetopt_args_info_help[65] ;
  args_info->gen_qualified_sig_help = gengetopt_args_info_help[66] ;
  args_info->gen_sig_help = gengetopt_args_info_help[67] ;
  args_info->read_eid_help = gengetopt_args_info_help[69] ;
  args_info->is_rfu4_help = gengetopt_args_info_help[70] ;
  args_info->is_rfu3_help = gengetopt_args_info_help[71] ;
  args_info->is_rfu2_help = gengetopt_args_info_help[72] ;
  args_info->read_iris_help = gengetopt_args_info_help[73] ;
  args_info->read_finger_help = gengetopt_args_info_help[74] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->out_cert_arg));
  free_string_field (&(args_info->out_cert_orig));
  free_string_field (&(args_info->role_orig));
  free_string_field (&(args_info->type_orig));
  free_string_field (&(args_info->issued_arg));
  free_string_field (&(args_info->issued_orig));
  free_string_field (&(args_info->expires_arg));
  free_string_field (&(args_info->expires_orig));
  free_string_field (&(args_info->sign_with_arg));
  free_string_field (&(args_info->sign_with_orig));
  free_string_field (&(args_info->scheme_orig));
  free_string_field (&(args_info->csr_arg));
  free_string_field (&(args_info->csr_orig));
  free_string_field (&(args_info->chr_arg));
  free_string_field (&(args_info->chr_orig));
  free_string_field (&(args_info->sign_as_arg));
  free_string_field (&(args_info->sign_as_orig));
  free_string_field (&(args_info->key_arg));
  free_string_field (&(args_info->key_orig));
  free_string_field (&(args_info->out_key_arg));
  free_string_field (&(args_info->out_key_orig));
  free_string_field (&(args_info->out_desc_arg));
  free_string_field (&(args_info->out_desc_orig));
  free_string_field (&(args_info->cert_desc_arg));
  free_string_field (&(args_info->cert_desc_orig));
  free_string_field (&(args_info->issuer_name_arg));
  free_string_field (&(args_info->issuer_name_orig));
  free_string_field (&(args_info->issuer_url_arg));
  free_string_field (&(args_info->issuer_url_orig));
  free_string_field (&(args_info->subject_name_arg));
  free_string_field (&(args_info->subject_name_orig));
  free_string_field (&(args_info->subject_url_arg));
  free_string_field (&(args_info->subject_url_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->out_cert_given)
    write_into_file(outfile, "out-cert", args_info->out_cert_orig, 0);
  if (args_info->role_given)
    write_into_file(outfile, "role", args_info->role_orig, cmdline_parser_role_values);
  if (args_info->type_given)
    write_into_file(outfile, "type", args_info->type_orig, cmdline_parser_type_values);
  if (args_info->issued_given)
    write_into_file(outfile, "issued", args_info->issued_orig, 0);
  if (args_info->expires_given)
    write_into_file(outfile, "expires", args_info->expires_orig, 0);
  if (args_info->sign_with_given)
    write_into_file(outfile, "sign-with", args_info->sign_with_orig, 0);
  if (args_info->scheme_given)
    write_into_file(outfile, "scheme", args_info->scheme_orig, cmdline_parser_scheme_values);
  if (args_info->csr_given)
    write_into_file(outfile, "csr", args_info->csr_orig, 0);
  if (args_info->chr_given)
    write_into_file(outfile, "chr", args_info->chr_orig, 0);
  if (args_info->sign_as_given)
    write_into_file(outfile, "sign-as", args_info->sign_as_orig, 0);
  if (args_info->key_given)
    write_into_file(outfile, "key", args_info->key_orig, 0);
  if (args_info->out_key_given)
    write_into_file(outfile, "out-key", args_info->out_key_orig, 0);
  if (args_info->out_desc_given)
    write_into_file(outfile, "out-desc", args_info->out_desc_orig, 0);
  if (args_info->cert_desc_given)
    write_into_file(outfile, "cert-desc", args_info->cert_desc_orig, 0);
  if (args_info->issuer_name_given)
    write_into_file(outfile, "issuer-name", args_info->issuer_name_orig, 0);
  if (args_info->issuer_url_given)
    write_into_file(outfile, "issuer-url", args_info->issuer_url_orig, 0);
  if (args_info->subject_name_given)
    write_into_file(outfile, "subject-name", args_info->subject_name_orig, 0);
  if (args_info->subject_url_given)
    write_into_file(outfile, "subject-url", args_info->subject_url_orig, 0);
  if (args_info->write_dg17_given)
    write_into_file(outfile, "write-dg17", 0, 0 );
  if (args_info->write_dg18_given)
    write_into_file(outfile, "write-dg18", 0, 0 );
  if (args_info->write_dg19_given)
    write_into_file(outfile, "write-dg19", 0, 0 );
  if (args_info->write_dg20_given)
    write_into_file(outfile, "write-dg20", 0, 0 );
  if (args_info->write_dg21_given)
    write_into_file(outfile, "write-dg21", 0, 0 );
  if (args_info->at_rfu32_given)
    write_into_file(outfile, "at-rfu32", 0, 0 );
  if (args_info->at_rfu31_given)
    write_into_file(outfile, "at-rfu31", 0, 0 );
  if (args_info->at_rfu30_given)
    write_into_file(outfile, "at-rfu30", 0, 0 );
  if (args_info->at_rfu29_given)
    write_into_file(outfile, "at-rfu29", 0, 0 );
  if (args_info->read_dg1_given)
    write_into_file(outfile, "read-dg1", 0, 0 );
  if (args_info->read_dg2_given)
    write_into_file(outfile, "read-dg2", 0, 0 );
  if (args_info->read_dg3_given)
    write_into_file(outfile, "read-dg3", 0, 0 );
  if (args_info->read_dg4_given)
    write_into_file(outfile, "read-dg4", 0, 0 );
  if (args_info->read_dg5_given)
    write_into_file(outfile, "read-dg5", 0, 0 );
  if (args_info->read_dg6_given)
    write_into_file(outfile, "read-dg6", 0, 0 );
  if (args_info->read_dg7_given)
    write_into_file(outfile, "read-dg7", 0, 0 );
  if (args_info->read_dg8_given)
    write_into_file(outfile, "read-dg8", 0, 0 );
  if (args_info->read_dg9_given)
    write_into_file(outfile, "read-dg9", 0, 0 );
  if (args_info->read_dg10_given)
    write_into_file(outfile, "read-dg10", 0, 0 );
  if (args_info->read_dg11_given)
    write_into_file(outfile, "read-dg11", 0, 0 );
  if (args_info->read_dg12_given)
    write_into_file(outfile, "read-dg12", 0, 0 );
  if (args_info->read_dg13_given)
    write_into_file(outfile, "read-dg13", 0, 0 );
  if (args_info->read_dg14_given)
    write_into_file(outfile, "read-dg14", 0, 0 );
  if (args_info->read_dg15_given)
    write_into_file(outfile, "read-dg15", 0, 0 );
  if (args_info->read_dg16_given)
    write_into_file(outfile, "read-dg16", 0, 0 );
  if (args_info->read_dg17_given)
    write_into_file(outfile, "read-dg17", 0, 0 );
  if (args_info->read_dg18_given)
    write_into_file(outfile, "read-dg18", 0, 0 );
  if (args_info->read_dg19_given)
    write_into_file(outfile, "read-dg19", 0, 0 );
  if (args_info->read_dg20_given)
    write_into_file(outfile, "read-dg20", 0, 0 );
  if (args_info->read_dg21_given)
    write_into_file(outfile, "read-dg21", 0, 0 );
  if (args_info->install_qual_cert_given)
    write_into_file(outfile, "install-qual-cert", 0, 0 );
  if (args_info->install_cert_given)
    write_into_file(outfile, "install-cert", 0, 0 );
  if (args_info->pin_management_given)
    write_into_file(outfile, "pin-management", 0, 0 );
  if (args_info->can_allowed_given)
    write_into_file(outfile, "can-allowed", 0, 0 );
  if (args_info->privileged_given)
    write_into_file(outfile, "privileged", 0, 0 );
  if (args_info->rid_given)
    write_into_file(outfile, "rid", 0, 0 );
  if (args_info->verify_community_given)
    write_into_file(outfile, "verify-community", 0, 0 );
  if (args_info->verify_age_given)
    write_into_file(outfile, "verify-age", 0, 0 );
  if (args_info->st_rfu5_given)
    write_into_file(outfile, "st-rfu5", 0, 0 );
  if (args_info->st_rfu4_given)
    write_into_file(outfile, "st-rfu4", 0, 0 );
  if (args_info->st_rfu3_given)
    write_into_file(outfile, "st-rfu3", 0, 0 );
  if (args_info->st_rfu2_given)
    write_into_file(outfile, "st-rfu2", 0, 0 );
  if (args_info->gen_qualified_sig_given)
    write_into_file(outfile, "gen-qualified-sig", 0, 0 );
  if (args_info->gen_sig_given)
    write_into_file(outfile, "gen-sig", 0, 0 );
  if (args_info->read_eid_given)
    write_into_file(outfile, "read-eid", 0, 0 );
  if (args_info->is_rfu4_given)
    write_into_file(outfile, "is-rfu4", 0, 0 );
  if (args_info->is_rfu3_given)
    write_into_file(outfile, "is-rfu3", 0, 0 );
  if (args_info->is_rfu2_given)
    write_into_file(outfile, "is-rfu2", 0, 0 );
  if (args_info->read_iris_given)
    write_into_file(outfile, "read-iris", 0, 0 );
  if (args_info->read_finger_given)
    write_into_file(outfile, "read-finger", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->role_given)
    {
      fprintf (stderr, "%s: '--role' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (! args_info->expires_given)
    {
      fprintf (stderr, "%s: '--expires' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (! args_info->sign_with_given)
    {
      fprintf (stderr, "%s: '--sign-with' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (! args_info->scheme_given)
    {
      fprintf (stderr, "%s: '--scheme' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (args_info->manual_mode_counter && ! args_info->chr_given)
    {
      fprintf (stderr, "%s: '--chr' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  
  /* checks for dependences among options */
  if (args_info->issuer_name_given && ! args_info->cert_desc_given)
    {
      fprintf (stderr, "%s: '--issuer-name' option depends on option 'cert-desc'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->issuer_url_given && ! args_info->cert_desc_given)
    {
      fprintf (stderr, "%s: '--issuer-url' option depends on option 'cert-desc'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->subject_name_given && ! args_info->cert_desc_given)
    {
      fprintf (stderr, "%s: '--subject-name' option depends on option 'cert-desc'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->subject_url_given && ! args_info->cert_desc_given)
    {
      fprintf (stderr, "%s: '--subject-url' option depends on option 'cert-desc'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_ENUM:
    if (val) *((int *)field) = found;
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


static int check_modes(
  int given1[], const char *options1[],
                       int given2[], const char *options2[])
{
  int i = 0, j = 0, errors = 0;
  
  while (given1[i] >= 0) {
    if (given1[i]) {
      while (given2[j] >= 0) {
        if (given2[j]) {
          ++errors;
          fprintf(stderr, "%s: option %s conflicts with option %s\n",
                  package_name, options1[i], options2[j]);
        }
        ++j;
      }
    }
    ++i;
  }
  
  return errors;
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "out-cert",	1, NULL, 0 },
        { "role",	1, NULL, 0 },
        { "type",	1, NULL, 0 },
        { "issued",	1, NULL, 0 },
        { "expires",	1, NULL, 0 },
        { "sign-with",	1, NULL, 0 },
        { "scheme",	1, NULL, 0 },
        { "csr",	1, NULL, 0 },
        { "chr",	1, NULL, 0 },
        { "sign-as",	1, NULL, 0 },
        { "key",	1, NULL, 0 },
        { "out-key",	1, NULL, 0 },
        { "out-desc",	1, NULL, 0 },
        { "cert-desc",	1, NULL, 0 },
        { "issuer-name",	1, NULL, 0 },
        { "issuer-url",	1, NULL, 0 },
        { "subject-name",	1, NULL, 0 },
        { "subject-url",	1, NULL, 0 },
        { "write-dg17",	0, NULL, 0 },
        { "write-dg18",	0, NULL, 0 },
        { "write-dg19",	0, NULL, 0 },
        { "write-dg20",	0, NULL, 0 },
        { "write-dg21",	0, NULL, 0 },
        { "at-rfu32",	0, NULL, 0 },
        { "at-rfu31",	0, NULL, 0 },
        { "at-rfu30",	0, NULL, 0 },
        { "at-rfu29",	0, NULL, 0 },
        { "read-dg1",	0, NULL, 0 },
        { "read-dg2",	0, NULL, 0 },
        { "read-dg3",	0, NULL, 0 },
        { "read-dg4",	0, NULL, 0 },
        { "read-dg5",	0, NULL, 0 },
        { "read-dg6",	0, NULL, 0 },
        { "read-dg7",	0, NULL, 0 },
        { "read-dg8",	0, NULL, 0 },
        { "read-dg9",	0, NULL, 0 },
        { "read-dg10",	0, NULL, 0 },
        { "read-dg11",	0, NULL, 0 },
        { "read-dg12",	0, NULL, 0 },
        { "read-dg13",	0, NULL, 0 },
        { "read-dg14",	0, NULL, 0 },
        { "read-dg15",	0, NULL, 0 },
        { "read-dg16",	0, NULL, 0 },
        { "read-dg17",	0, NULL, 0 },
        { "read-dg18",	0, NULL, 0 },
        { "read-dg19",	0, NULL, 0 },
        { "read-dg20",	0, NULL, 0 },
        { "read-dg21",	0, NULL, 0 },
        { "install-qual-cert",	0, NULL, 0 },
        { "install-cert",	0, NULL, 0 },
        { "pin-management",	0, NULL, 0 },
        { "can-allowed",	0, NULL, 0 },
        { "privileged",	0, NULL, 0 },
        { "rid",	0, NULL, 0 },
        { "verify-community",	0, NULL, 0 },
        { "verify-age",	0, NULL, 0 },
        { "st-rfu5",	0, NULL, 0 },
        { "st-rfu4",	0, NULL, 0 },
        { "st-rfu3",	0, NULL, 0 },
        { "st-rfu2",	0, NULL, 0 },
        { "gen-qualified-sig",	0, NULL, 0 },
        { "gen-sig",	0, NULL, 0 },
        { "read-eid",	0, NULL, 0 },
        { "is-rfu4",	0, NULL, 0 },
        { "is-rfu3",	0, NULL, 0 },
        { "is-rfu2",	0, NULL, 0 },
        { "read-iris",	0, NULL, 0 },
        { "read-finger",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hV", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);


        case 0:	/* Long option with no short option */
          /* Where to save the certificate.  */
          if (strcmp (long_options[option_index].name, "out-cert") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->out_cert_arg), 
                 &(args_info->out_cert_orig), &(args_info->out_cert_given),
                &(local_args_info.out_cert_given), optarg, 0, "CHR.cvcert", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "out-cert", '-',
                additional_error))
              goto failure;
          
          }
          /* The terminal's role.  */
          else if (strcmp (long_options[option_index].name, "role") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->role_arg), 
                 &(args_info->role_orig), &(args_info->role_given),
                &(local_args_info.role_given), optarg, cmdline_parser_role_values, 0, ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "role", '-',
                additional_error))
              goto failure;
          
          }
          /* Type of the terminal (Authentication Terminal, Inspection System or Signature Terminal).  */
          else if (strcmp (long_options[option_index].name, "type") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->type_arg), 
                 &(args_info->type_orig), &(args_info->type_given),
                &(local_args_info.type_given), optarg, cmdline_parser_type_values, "derived_from_signer", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "type", '-',
                additional_error))
              goto failure;
          
          }
          /* Date the certificate was issued.  */
          else if (strcmp (long_options[option_index].name, "issued") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->issued_arg), 
                 &(args_info->issued_orig), &(args_info->issued_given),
                &(local_args_info.issued_given), optarg, 0, "today", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "issued", '-',
                additional_error))
              goto failure;
          
          }
          /* Date until the certicate is valid.  */
          else if (strcmp (long_options[option_index].name, "expires") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->expires_arg), 
                 &(args_info->expires_orig), &(args_info->expires_given),
                &(local_args_info.expires_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "expires", '-',
                additional_error))
              goto failure;
          
          }
          /* Private key for signing the new certificate.  */
          else if (strcmp (long_options[option_index].name, "sign-with") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->sign_with_arg), 
                 &(args_info->sign_with_orig), &(args_info->sign_with_given),
                &(local_args_info.sign_with_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "sign-with", '-',
                additional_error))
              goto failure;
          
          }
          /* Signature scheme that the new terminal will use.  */
          else if (strcmp (long_options[option_index].name, "scheme") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->scheme_arg), 
                 &(args_info->scheme_orig), &(args_info->scheme_given),
                &(local_args_info.scheme_given), optarg, cmdline_parser_scheme_values, 0, ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "scheme", '-',
                additional_error))
              goto failure;
          
          }
          /* Certificate signing request with the attributes.  */
          else if (strcmp (long_options[option_index].name, "csr") == 0)
          {
            args_info->csr_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->csr_arg), 
                 &(args_info->csr_orig), &(args_info->csr_given),
                &(local_args_info.csr_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "csr", '-',
                additional_error))
              goto failure;
          
          }
          /* Certificate holder reference (2 characters ISO 3166-1 ALPHA-2 country code, 0-9 characters ISO/IEC 8859-1 holder mnemonic, 5 characters ISO/IEC 8859-1 numeric or alphanumeric sequence number).  */
          else if (strcmp (long_options[option_index].name, "chr") == 0)
          {
            args_info->manual_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->chr_arg), 
                 &(args_info->chr_orig), &(args_info->chr_given),
                &(local_args_info.chr_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "chr", '-',
                additional_error))
              goto failure;
          
          }
          /* CV certificate of the entity signing the new certificate.  */
          else if (strcmp (long_options[option_index].name, "sign-as") == 0)
          {
            args_info->manual_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->sign_as_arg), 
                 &(args_info->sign_as_orig), &(args_info->sign_as_given),
                &(local_args_info.sign_as_given), optarg, 0, "self signed", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "sign-as", '-',
                additional_error))
              goto failure;
          
          }
          /* Private key of the Terminal.  */
          else if (strcmp (long_options[option_index].name, "key") == 0)
          {
            args_info->manual_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->key_arg), 
                 &(args_info->key_orig), &(args_info->key_given),
                &(local_args_info.key_given), optarg, 0, "derived from signer", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "key", '-',
                additional_error))
              goto failure;
          
          }
          /* Where to save the derived private key.  */
          else if (strcmp (long_options[option_index].name, "out-key") == 0)
          {
            args_info->manual_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->out_key_arg), 
                 &(args_info->out_key_orig), &(args_info->out_key_given),
                &(local_args_info.out_key_given), optarg, 0, "CHR.pkcs8", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "out-key", '-',
                additional_error))
              goto failure;
          
          }
          /* Where to save the encoded certificate description.  */
          else if (strcmp (long_options[option_index].name, "out-desc") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->out_desc_arg), 
                 &(args_info->out_desc_orig), &(args_info->out_desc_given),
                &(local_args_info.out_desc_given), optarg, 0, "CHR.desc", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "out-desc", '-',
                additional_error))
              goto failure;
          
          }
          /* Terms of usage as part of the certificate description (*.txt, *.html or *.pdf).  */
          else if (strcmp (long_options[option_index].name, "cert-desc") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cert_desc_arg), 
                 &(args_info->cert_desc_orig), &(args_info->cert_desc_given),
                &(local_args_info.cert_desc_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cert-desc", '-',
                additional_error))
              goto failure;
          
          }
          /* Name of the issuer of this certificate (certificate description).  */
          else if (strcmp (long_options[option_index].name, "issuer-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->issuer_name_arg), 
                 &(args_info->issuer_name_orig), &(args_info->issuer_name_given),
                &(local_args_info.issuer_name_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "issuer-name", '-',
                additional_error))
              goto failure;
          
          }
          /* URL that points to informations about the issuer of this certificate (certificate description).  */
          else if (strcmp (long_options[option_index].name, "issuer-url") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->issuer_url_arg), 
                 &(args_info->issuer_url_orig), &(args_info->issuer_url_given),
                &(local_args_info.issuer_url_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "issuer-url", '-',
                additional_error))
              goto failure;
          
          }
          /* Name of the holder of this certificate (certificate description).  */
          else if (strcmp (long_options[option_index].name, "subject-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->subject_name_arg), 
                 &(args_info->subject_name_orig), &(args_info->subject_name_given),
                &(local_args_info.subject_name_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "subject-name", '-',
                additional_error))
              goto failure;
          
          }
          /* URL that points to informations about the subject of this certificate (certificate description).  */
          else if (strcmp (long_options[option_index].name, "subject-url") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->subject_url_arg), 
                 &(args_info->subject_url_orig), &(args_info->subject_url_given),
                &(local_args_info.subject_url_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "subject-url", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow writing DG 17 (Normal Place of Residence).  */
          else if (strcmp (long_options[option_index].name, "write-dg17") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->write_dg17_flag), 0, &(args_info->write_dg17_given),
                &(local_args_info.write_dg17_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "write-dg17", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow writing DG 18 (Community ID).  */
          else if (strcmp (long_options[option_index].name, "write-dg18") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->write_dg18_flag), 0, &(args_info->write_dg18_given),
                &(local_args_info.write_dg18_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "write-dg18", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow writing DG 19 (Residence Permit I).  */
          else if (strcmp (long_options[option_index].name, "write-dg19") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->write_dg19_flag), 0, &(args_info->write_dg19_given),
                &(local_args_info.write_dg19_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "write-dg19", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow writing DG 20 (Residence Permit II).  */
          else if (strcmp (long_options[option_index].name, "write-dg20") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->write_dg20_flag), 0, &(args_info->write_dg20_given),
                &(local_args_info.write_dg20_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "write-dg20", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow writing DG 21 (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "write-dg21") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->write_dg21_flag), 0, &(args_info->write_dg21_given),
                &(local_args_info.write_dg21_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "write-dg21", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU R/W Access bit 32.  */
          else if (strcmp (long_options[option_index].name, "at-rfu32") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->at_rfu32_flag), 0, &(args_info->at_rfu32_given),
                &(local_args_info.at_rfu32_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "at-rfu32", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU R/W Access bit 31.  */
          else if (strcmp (long_options[option_index].name, "at-rfu31") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->at_rfu31_flag), 0, &(args_info->at_rfu31_given),
                &(local_args_info.at_rfu31_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "at-rfu31", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU R/W Access bit 30.  */
          else if (strcmp (long_options[option_index].name, "at-rfu30") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->at_rfu30_flag), 0, &(args_info->at_rfu30_given),
                &(local_args_info.at_rfu30_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "at-rfu30", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU R/W Access bit 29.  */
          else if (strcmp (long_options[option_index].name, "at-rfu29") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->at_rfu29_flag), 0, &(args_info->at_rfu29_given),
                &(local_args_info.at_rfu29_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "at-rfu29", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 1   (Document Type).  */
          else if (strcmp (long_options[option_index].name, "read-dg1") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg1_flag), 0, &(args_info->read_dg1_given),
                &(local_args_info.read_dg1_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg1", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 2   (Issuing State).  */
          else if (strcmp (long_options[option_index].name, "read-dg2") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg2_flag), 0, &(args_info->read_dg2_given),
                &(local_args_info.read_dg2_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg2", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 3   (Date of Expiry).  */
          else if (strcmp (long_options[option_index].name, "read-dg3") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg3_flag), 0, &(args_info->read_dg3_given),
                &(local_args_info.read_dg3_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg3", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 4   (Given Names).  */
          else if (strcmp (long_options[option_index].name, "read-dg4") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg4_flag), 0, &(args_info->read_dg4_given),
                &(local_args_info.read_dg4_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg4", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 5   (Family Names).  */
          else if (strcmp (long_options[option_index].name, "read-dg5") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg5_flag), 0, &(args_info->read_dg5_given),
                &(local_args_info.read_dg5_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg5", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 6   (Religious/Artistic Name).  */
          else if (strcmp (long_options[option_index].name, "read-dg6") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg6_flag), 0, &(args_info->read_dg6_given),
                &(local_args_info.read_dg6_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg6", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 7   (Academic Title).  */
          else if (strcmp (long_options[option_index].name, "read-dg7") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg7_flag), 0, &(args_info->read_dg7_given),
                &(local_args_info.read_dg7_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg7", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 8   (Date of Birth).  */
          else if (strcmp (long_options[option_index].name, "read-dg8") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg8_flag), 0, &(args_info->read_dg8_given),
                &(local_args_info.read_dg8_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg8", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 9   (Place of Birth).  */
          else if (strcmp (long_options[option_index].name, "read-dg9") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg9_flag), 0, &(args_info->read_dg9_given),
                &(local_args_info.read_dg9_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg9", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 10  (Nationality).  */
          else if (strcmp (long_options[option_index].name, "read-dg10") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg10_flag), 0, &(args_info->read_dg10_given),
                &(local_args_info.read_dg10_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg10", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 11  (Sex).  */
          else if (strcmp (long_options[option_index].name, "read-dg11") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg11_flag), 0, &(args_info->read_dg11_given),
                &(local_args_info.read_dg11_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg11", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 12  (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "read-dg12") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg12_flag), 0, &(args_info->read_dg12_given),
                &(local_args_info.read_dg12_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg12", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 13.  */
          else if (strcmp (long_options[option_index].name, "read-dg13") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg13_flag), 0, &(args_info->read_dg13_given),
                &(local_args_info.read_dg13_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg13", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 14.  */
          else if (strcmp (long_options[option_index].name, "read-dg14") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg14_flag), 0, &(args_info->read_dg14_given),
                &(local_args_info.read_dg14_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg14", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 15.  */
          else if (strcmp (long_options[option_index].name, "read-dg15") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg15_flag), 0, &(args_info->read_dg15_given),
                &(local_args_info.read_dg15_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg15", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 16.  */
          else if (strcmp (long_options[option_index].name, "read-dg16") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg16_flag), 0, &(args_info->read_dg16_given),
                &(local_args_info.read_dg16_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg16", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 17  (Normal Place of Residence).  */
          else if (strcmp (long_options[option_index].name, "read-dg17") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg17_flag), 0, &(args_info->read_dg17_given),
                &(local_args_info.read_dg17_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg17", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 18  (Community ID).  */
          else if (strcmp (long_options[option_index].name, "read-dg18") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg18_flag), 0, &(args_info->read_dg18_given),
                &(local_args_info.read_dg18_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg18", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 19  (Residence Permit I).  */
          else if (strcmp (long_options[option_index].name, "read-dg19") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg19_flag), 0, &(args_info->read_dg19_given),
                &(local_args_info.read_dg19_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg19", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 20  (Residence Permit II).  */
          else if (strcmp (long_options[option_index].name, "read-dg20") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg20_flag), 0, &(args_info->read_dg20_given),
                &(local_args_info.read_dg20_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg20", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow reading DG 21  (Optional Data).  */
          else if (strcmp (long_options[option_index].name, "read-dg21") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_dg21_flag), 0, &(args_info->read_dg21_given),
                &(local_args_info.read_dg21_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-dg21", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow installing qualified certificate.  */
          else if (strcmp (long_options[option_index].name, "install-qual-cert") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->install_qual_cert_flag), 0, &(args_info->install_qual_cert_given),
                &(local_args_info.install_qual_cert_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "install-qual-cert", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow installing certificate.  */
          else if (strcmp (long_options[option_index].name, "install-cert") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->install_cert_flag), 0, &(args_info->install_cert_given),
                &(local_args_info.install_cert_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "install-cert", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow PIN management.  */
          else if (strcmp (long_options[option_index].name, "pin-management") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->pin_management_flag), 0, &(args_info->pin_management_given),
                &(local_args_info.pin_management_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "pin-management", '-',
                additional_error))
              goto failure;
          
          }
          /* CAN allowed.  */
          else if (strcmp (long_options[option_index].name, "can-allowed") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->can_allowed_flag), 0, &(args_info->can_allowed_given),
                &(local_args_info.can_allowed_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "can-allowed", '-',
                additional_error))
              goto failure;
          
          }
          /* Privileged terminal.  */
          else if (strcmp (long_options[option_index].name, "privileged") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->privileged_flag), 0, &(args_info->privileged_given),
                &(local_args_info.privileged_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "privileged", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow restricted identification.  */
          else if (strcmp (long_options[option_index].name, "rid") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->rid_flag), 0, &(args_info->rid_given),
                &(local_args_info.rid_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "rid", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow community ID verification.  */
          else if (strcmp (long_options[option_index].name, "verify-community") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->verify_community_flag), 0, &(args_info->verify_community_given),
                &(local_args_info.verify_community_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "verify-community", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow age verification.  */
          else if (strcmp (long_options[option_index].name, "verify-age") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->verify_age_flag), 0, &(args_info->verify_age_given),
                &(local_args_info.verify_age_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "verify-age", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU bit 5.  */
          else if (strcmp (long_options[option_index].name, "st-rfu5") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->st_rfu5_flag), 0, &(args_info->st_rfu5_given),
                &(local_args_info.st_rfu5_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "st-rfu5", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU bit 4.  */
          else if (strcmp (long_options[option_index].name, "st-rfu4") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->st_rfu4_flag), 0, &(args_info->st_rfu4_given),
                &(local_args_info.st_rfu4_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "st-rfu4", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU bit 3.  */
          else if (strcmp (long_options[option_index].name, "st-rfu3") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->st_rfu3_flag), 0, &(args_info->st_rfu3_given),
                &(local_args_info.st_rfu3_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "st-rfu3", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU bit 2.  */
          else if (strcmp (long_options[option_index].name, "st-rfu2") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->st_rfu2_flag), 0, &(args_info->st_rfu2_given),
                &(local_args_info.st_rfu2_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "st-rfu2", '-',
                additional_error))
              goto failure;
          
          }
          /* Generate qualified electronic signature.  */
          else if (strcmp (long_options[option_index].name, "gen-qualified-sig") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->gen_qualified_sig_flag), 0, &(args_info->gen_qualified_sig_given),
                &(local_args_info.gen_qualified_sig_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "gen-qualified-sig", '-',
                additional_error))
              goto failure;
          
          }
          /* Generate electronic signature.  */
          else if (strcmp (long_options[option_index].name, "gen-sig") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->gen_sig_flag), 0, &(args_info->gen_sig_given),
                &(local_args_info.gen_sig_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "gen-sig", '-',
                additional_error))
              goto failure;
          
          }
          /* Read access to eID application (Deprecated).  */
          else if (strcmp (long_options[option_index].name, "read-eid") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_eid_flag), 0, &(args_info->read_eid_given),
                &(local_args_info.read_eid_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-eid", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU bit 4.  */
          else if (strcmp (long_options[option_index].name, "is-rfu4") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->is_rfu4_flag), 0, &(args_info->is_rfu4_given),
                &(local_args_info.is_rfu4_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "is-rfu4", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU bit 3.  */
          else if (strcmp (long_options[option_index].name, "is-rfu3") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->is_rfu3_flag), 0, &(args_info->is_rfu3_given),
                &(local_args_info.is_rfu3_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "is-rfu3", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow RFU bit 2.  */
          else if (strcmp (long_options[option_index].name, "is-rfu2") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->is_rfu2_flag), 0, &(args_info->is_rfu2_given),
                &(local_args_info.is_rfu2_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "is-rfu2", '-',
                additional_error))
              goto failure;
          
          }
          /* Read access to ePassport application: DG 4 (Iris).  */
          else if (strcmp (long_options[option_index].name, "read-iris") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_iris_flag), 0, &(args_info->read_iris_given),
                &(local_args_info.read_iris_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-iris", '-',
                additional_error))
              goto failure;
          
          }
          /* Read access to ePassport application: DG 3 (Fingerprint).  */
          else if (strcmp (long_options[option_index].name, "read-finger") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->read_finger_flag), 0, &(args_info->read_finger_given),
                &(local_args_info.read_finger_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "read-finger", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (args_info->csr_mode_counter && args_info->manual_mode_counter) {
    int csr_given[] = {args_info->csr_given,  -1};
    const char *csr_desc[] = {"--csr",  0};
    int manual_given[] = {args_info->chr_given, args_info->sign_as_given, args_info->key_given, args_info->out_key_given,  -1};
    const char *manual_desc[] = {"--chr", "--sign-as", "--key", "--out-key",  0};
    error_occurred += check_modes(csr_given, csr_desc, manual_given, manual_desc);
  }
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
