'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 1998-2000 Scriptics Corporation.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH entry n 8.3 Tk "Tk Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
entry \- Create and manipulate 'entry' one-line text entry widgets
.SH SYNOPSIS
\fBentry\fR \fIpathName \fR?\fIoptions\fR?
.SO
\-background	\-highlightthickness	\-selectbackground
\-borderwidth	\-insertbackground	\-selectborderwidth
\-cursor	\-insertborderwidth	\-selectforeground
\-exportselection	\-insertofftime	\-takefocus
\-font	\-insertontime	\-textvariable
\-foreground	\-insertwidth	\-xscrollcommand
\-highlightbackground	\-justify
\-highlightcolor	\-relief
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-disabledbackground disabledBackground DisabledBackground
Specifies the background color to use when the entry is disabled.  If
this option is the empty string, the normal background color is used.
.OP \-disabledforeground disabledForeground DisabledForeground
Specifies the foreground color to use when the entry is disabled.  If
this option is the empty string, the normal foreground color is used.
.OP "\-invalidcommand or \-invcmd" invalidCommand InvalidCommand
Specifies a script to eval when \fB\-validatecommand\fR returns 0.
Setting it to {} disables this feature (the default).  The best use
of this option is to set it to \fIbell\fR.  See \fBVALIDATION\fR
below for more information.
.OP \-readonlybackground readonlyBackground ReadonlyBackground
Specifies the background color to use when the entry is readonly.  If
this option is the empty string, the normal background color is used.
.OP \-show show Show
If this option is specified, then the true contents of the entry
are not displayed in the window.
Instead, each character in the entry's value will be displayed as
the first character in the value of this option, such as
.QW * .
This is useful, for example, if the entry is to be used to enter
a password.
If characters in the entry are selected and copied elsewhere, the
information copied will be what is displayed, not the true contents
of the entry.
.OP \-state state State
Specifies one of three states for the entry:  \fBnormal\fR,
\fBdisabled\fR, or \fBreadonly\fR.  If the entry is readonly, then the
value may not be changed using widget commands and no insertion cursor
will be displayed, even if the input focus is in the widget; the
contents of the widget may still be selected.  If the entry is
disabled, the value may not be changed, no insertion cursor will be
displayed, the contents will not be selectable, and the entry may
be displayed in a different color, depending on the values of the
\fB\-disabledforeground\fR and \fB\-disabledbackground\fR options.
.OP \-validate validate Validate
Specifies the mode in which validation should operate: \fBnone\fR,
\fBfocus\fR, \fBfocusin\fR, \fBfocusout\fR, \fBkey\fR, or \fBall\fR.
It defaults to \fBnone\fR.  When you want validation, you must explicitly
state which mode you wish to use.  See \fBVALIDATION\fR below for more.
.OP "\-validatecommand or \-vcmd" validateCommand ValidateCommand
Specifies a script to eval when you want to validate the input into
the entry widget.  Setting it to {} disables this feature (the default).
This command must return a valid Tcl boolean value.  If it returns 0 (or
the valid Tcl boolean equivalent) then it means you reject the new edition
and it will not occur and the \fB\-invalidcommand\fR will be evaluated if it
is set. If it returns 1, then the new edition occurs.
See \fBVALIDATION\fR below for more information.
.OP \-width width Width
Specifies an integer value indicating the desired width of the entry window,
in average-size characters of the widget's font.
If the value is less than or equal to zero, the widget picks a
size just large enough to hold its current text.
.BE
.SH DESCRIPTION
.PP
The \fBentry\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into an entry widget.
Additional options, described above, may be specified on the
command line or in the option database
to configure aspects of the entry such as its colors, font,
and relief.  The \fBentry\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
An entry is a widget that displays a one-line text string and
allows that string to be edited using widget commands described below, which
are typically bound to keystrokes and mouse actions.
When first created, an entry's string is empty.
A portion of the entry may be selected as described below.
If an entry is exporting its selection (see the \fB\-exportselection\fR
option), then it will observe the standard X11 protocols for handling the
selection;  entry selections are available as type \fBSTRING\fR.
Entries also observe the standard Tk rules for dealing with the
input focus.  When an entry has the input focus it displays an
\fIinsertion cursor\fR to indicate where new characters will be
inserted.
.PP
Entries are capable of displaying strings that are too long to
fit entirely within the widget's window.  In this case, only a
portion of the string will be displayed;  commands described below
may be used to change the view in the window.  Entries use
the standard \fB\-xscrollcommand\fR mechanism for interacting with
scrollbars (see the description of the \fB\-xscrollcommand\fR option
for details).  They also support scanning, as described below.
.SH VALIDATION
.PP
Validation works by setting the \fB\-validatecommand\fR option to a
script (\fIvalidateCommand\fR) which will be evaluated according to
the \fB\-validate\fR option as follows:
.PP
.IP \fBnone\fR 10
Default.  This means no validation will occur.
.IP \fBfocus\fR 10
\fIvalidateCommand\fR will be called when the entry receives or
loses focus.
.IP \fBfocusin\fR 10
\fIvalidateCommand\fR will be called when the entry receives focus.
.IP \fBfocusout\fR 10
\fIvalidateCommand\fR will be called when the entry loses focus.
.IP \fBkey\fR 10
\fIvalidateCommand\fR will be called when the entry is edited.
.IP \fBall\fR 10
\fIvalidateCommand\fR will be called for all above conditions.
.PP
It is possible to perform percent substitutions on the value of the
\fB\-validatecommand\fR and \fB\-invalidcommand\fR options,
just as you would in a \fBbind\fR script.  The following substitutions
are recognized:
.PP
.IP \fB%d\fR 5
Type of action: 1 for \fBinsert\fR, 0 for \fBdelete\fR,
or \-1 for focus, forced or textvariable validation.
.IP \fB%i\fR 5
Index of char string to be inserted/deleted, if any, otherwise \-1.
.IP \fB%P\fR 5
The value of the entry if the edit is allowed.  If you are configuring the
entry widget to have a new textvariable, this will be the value of that
textvariable.
.IP \fB%s\fR 5
The current value of entry prior to editing.
.IP \fB%S\fR 5
The text string being inserted/deleted, if any, {} otherwise.
.IP \fB%v\fR 5
The type of validation currently set.
.IP \fB%V\fR 5
The type of validation that triggered the callback
(key, focusin, focusout, forced).
.IP \fB%W\fR 5
The name of the entry widget.
.PP
In general, the \fB\-textvariable\fR and \fB\-validatecommand\fR options can be
dangerous to mix.  Any problems have been overcome so that using the
\fB\-validatecommand\fR will not interfere with the traditional behavior of
the entry widget.  Using the \fB\-textvariable\fR for read-only purposes will
never cause problems.  The danger comes when you try set the
\fB\-textvariable\fR to something that the \fB\-validatecommand\fR would not
accept, which causes \fB\-validate\fR to become \fInone\fR (the
\fB\-invalidcommand\fR will not be triggered).  The same happens
when an error occurs evaluating the \fB\-validatecommand\fR.
.PP
Primarily, an error will occur when the \fB\-validatecommand\fR or
\fB\-invalidcommand\fR encounters an error in its script while evaluating or
\fB\-validatecommand\fR does not return a valid Tcl boolean value.  The
\fB\-validate\fR option will also set itself to \fBnone\fR when you edit the
entry widget from within either the \fB\-validatecommand\fR or the
\fB\-invalidcommand\fR.  Such editions will override the one that was being
validated.  If you wish to edit the entry widget (for example set it to {})
during validation and still have the \fB\-validate\fR option set, you should
include the command
.CS
after idle {%W config \-validate %v}
.CE
in the \fB\-validatecommand\fR or \fB\-invalidcommand\fR (whichever one you
were editing the entry widget from).  It is also recommended to not set an
associated \fB\-textvariable\fR during validation, as that can cause the
entry widget to become out of sync with the \fB\-textvariable\fR.
.SH "WIDGET COMMAND"
.PP
The \fBentry\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName subcommand \fR?\fIarg arg ...\fR?
.CE
\fISubcommand\fR and the \fIarg\fRs
determine the exact behavior of the command.
.SS INDICES
.PP
Many of the widget commands for entries take one or more indices as
arguments.  An index specifies a particular character in the entry's
string, in any of the following ways:
.TP 12
\fInumber\fR
Specifies the character as a numerical index, where 0 corresponds
to the first character in the string.
.TP 12
\fBanchor\fR
Indicates the anchor point for the selection, which is set with the
\fBselect from\fR and \fBselect adjust\fR widget commands.
.TP 12
\fBend\fR
Indicates the character just after the last one in the entry's string.
This is equivalent to specifying a numerical index equal to the length
of the entry's string.
.TP 12
\fBinsert\fR
Indicates the character adjacent to and immediately following the
insertion cursor.
.TP 12
\fBsel.first\fR
Indicates the first character in the selection.  It is an error to
use this form if the selection is not in the entry window.
.TP 12
\fBsel.last\fR
Indicates the character just after the last one in the selection.
It is an error to use this form if the selection is not in the
entry window.
.TP 12
\fB@\fInumber\fR
In this form, \fInumber\fR is treated as an x-coordinate in the
entry's window;  the character spanning that x-coordinate is used.
For example,
.QW \fB@0\fR
indicates the left-most character in the window.
.LP
Abbreviations may be used for any of the forms above, e.g.
.QW \fBe\fR
or
.QW \fBsel.f\fR .
In general, out-of-range indices are automatically rounded to the
nearest legal value.
.SS SUBCOMMANDS
.PP
The following commands are possible for entry widgets:
.TP
\fIpathName \fBbbox \fIindex\fR
Returns a list of four numbers describing the bounding box of the
character given by \fIindex\fR.
The first two elements of the list give the x and y coordinates of
the upper-left corner of the screen area covered by the character
(in pixels relative to the widget) and the last two elements give
the width and height of the character, in pixels.
The bounding box may refer to a region outside the visible area
of the window.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBentry\fR
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBentry\fR
command.
.TP
\fIpathName \fBdelete \fIfirst \fR?\fIlast\fR?
Delete one or more elements of the entry.
\fIFirst\fR is the index of the first character to delete, and
\fIlast\fR is the index of the character just after the last
one to delete.
If \fIlast\fR is not specified it defaults to \fIfirst\fR+1,
i.e. a single character is deleted.
This command returns an empty string.
.TP
\fIpathName \fBget\fR
Returns the entry's string.
.TP
\fIpathName \fBicursor \fIindex\fR
Arrange for the insertion cursor to be displayed just before the character
given by \fIindex\fR.  Returns an empty string.
.TP
\fIpathName \fBindex\fI index\fR
Returns the numerical index corresponding to \fIindex\fR.
.TP
\fIpathName \fBinsert \fIindex string\fR
Insert the characters of \fIstring\fR just before the character
indicated by \fIindex\fR.  Returns an empty string.
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on entries.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx\fR
Records \fIx\fR and the current view in the entry window;  used in
conjunction with later \fBscan dragto\fR commands.  Typically this
command is associated with a mouse button press in the widget.  It
returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx\fR
This command computes the difference between its \fIx\fR argument
and the \fIx\fR argument to the last \fBscan mark\fR command for
the widget.  It then adjusts the view left or right by 10 times the
difference in x-coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the entry at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBselection \fIoption arg\fR
This command is used to adjust the selection within an entry.  It
has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBselection adjust \fIindex\fR
Locate the end of the selection nearest to the character given by
\fIindex\fR, and adjust that end of the selection to be at \fIindex\fR
(i.e. including but not going beyond \fIindex\fR).  The other
end of the selection is made the anchor point for future
\fBselect to\fR commands.  If the selection
is not currently in the entry, then a new selection is created to
include the characters between \fIindex\fR and the most recent
selection anchor point, inclusive.
Returns an empty string.
.TP
\fIpathName \fBselection clear\fR
Clear the selection if it is currently in this widget.  If the
selection is not in this widget then the command has no effect.
Returns an empty string.
.TP
\fIpathName \fBselection from \fIindex\fR
Set the selection anchor point to just before the character
given by \fIindex\fR.  Does not change the selection.
Returns an empty string.
.TP
\fIpathName \fBselection present\fR
Returns 1 if there is are characters selected in the entry,
0 if nothing is selected.
.TP
\fIpathName \fBselection range \fIstart\fR \fIend\fR
Sets the selection to include the characters starting with
the one indexed by \fIstart\fR and ending with the one just
before \fIend\fR.
If \fIend\fR refers to the same character as \fIstart\fR or an
earlier one, then the entry's selection is cleared.
.TP
\fIpathName \fBselection to \fIindex\fR
If \fIindex\fR is before the anchor point, set the selection
to the characters from \fIindex\fR up to but not including
the anchor point.
If \fIindex\fR is the same as the anchor point, do nothing.
If \fIindex\fR is after the anchor point, set the selection
to the characters from the anchor point up to but not including
\fIindex\fR.
The anchor point is determined by the most recent \fBselect from\fR
or \fBselect adjust\fR command in this widget.
If the selection is not in this widget then a new selection is
created using the most recent anchor point specified for the widget.
Returns an empty string.
.RE
.TP
\fIpathName \fBvalidate\fR
This command is used to force an evaluation of the \fB\-validatecommand\fR
independent of the conditions specified by the \fB\-validate\fR option.
This is done by temporarily setting the \fB\-validate\fR option to \fBall\fR.
It returns 0 or 1.
.TP
\fIpathName \fBxview \fIargs\fR
This command is used to query and change the horizontal position of the
text in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName \fBxview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the entry's text is off-screen to the left, the middle 40% is visible
in the window, and 40% of the text is off-screen to the right.
These are the same values passed to scrollbars via the \fB\-xscrollcommand\fR
option.
.TP
\fIpathName \fBxview\fR \fIindex\fR
Adjusts the view in the window so that the character given by \fIindex\fR
is displayed at the left edge of the window.
.TP
\fIpathName \fBxview moveto\fI fraction\fR
Adjusts the view in the window so that the character \fIfraction\fR of the
way through the text appears at the left edge of the window.
\fIFraction\fR must be a fraction between 0 and 1.
.TP
\fIpathName \fBxview scroll \fInumber what\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right by
\fInumber\fR average-width characters on the display;  if it is
\fBpages\fR then the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then characters farther to the left
become visible;  if it is positive then characters farther to the right
become visible.
.RE
.SH "DEFAULT BINDINGS"
.PP
Tk automatically creates class bindings for entries that give them
the following default behavior. In the descriptions below,
.QW word
refers to a contiguous group of letters, digits, or
.QW _
characters, or any single character other than these.
.IP [1]
Clicking mouse button 1 positions the insertion cursor
just before the character underneath the mouse cursor, sets the
input focus to this widget, and clears any selection in the widget.
Dragging with mouse button 1 strokes out a selection between
the insertion cursor and the character under the mouse.
.IP [2]
Double-clicking with mouse button 1 selects the word under the mouse
and positions the insertion cursor at the end of the word.
Dragging after a double click will stroke out a selection consisting
of whole words.
.IP [3]
Triple-clicking with mouse button 1 selects all of the text in the
entry and positions the insertion cursor at the end of the line.
.IP [4]
The ends of the selection can be adjusted by dragging with mouse
button 1 while the Shift key is down;  this will adjust the end
of the selection that was nearest to the mouse cursor when button
1 was pressed.
If the button is double-clicked before dragging then the selection
will be adjusted in units of whole words.
.IP [5]
Clicking mouse button 1 with the Control key down will position the
insertion cursor in the entry without affecting the selection.
.IP [6]
If any normal printing characters are typed in an entry, they are
inserted at the point of the insertion cursor.
.IP [7]
The view in the entry can be adjusted by dragging with mouse button 2.
If mouse button 2 is clicked without moving the mouse, the selection
is copied into the entry at the position of the mouse cursor.
.IP [8]
If the mouse is dragged out of the entry on the left or right sides
while button 1 is pressed, the entry will automatically scroll to
make more text visible (if there is more text off-screen on the side
where the mouse left the window).
.IP [9]
The Left and Right keys move the insertion cursor one character to the
left or right;  they also clear any selection in the entry and set
the selection anchor.
If Left or Right is typed with the Shift key down, then the insertion
cursor moves and the selection is extended to include the new character.
Control-Left and Control-Right move the insertion cursor by words, and
Control-Shift-Left and Control-Shift-Right move the insertion cursor
by words and also extend the selection.
Control-b and Control-f behave the same as Left and Right, respectively.
Meta-b and Meta-f behave the same as Control-Left and Control-Right,
respectively.
.IP [10]
The Home key, or Control-a, will move the insertion cursor to the
beginning of the entry and clear any selection in the entry.
Shift-Home moves the insertion cursor to the beginning of the entry
and also extends the selection to that point.
.IP [11]
The End key, or Control-e, will move the insertion cursor to the
end of the entry and clear any selection in the entry.
Shift-End moves the cursor to the end and extends the selection
to that point.
.IP [12]
The Select key and Control-Space set the selection anchor to the position
of the insertion cursor.  They do not affect the current selection.
Shift-Select and Control-Shift-Space adjust the selection to the
current position of the insertion cursor, selecting from the anchor
to the insertion cursor if there was not any selection previously.
.IP [13]
Control-/ selects all the text in the entry.
.IP [14]
Control-\e clears any selection in the entry.
.IP [15]
The F16 key (labelled Copy on many Sun workstations) or Meta-w
copies the selection in the widget to the clipboard, if there is a selection.
.IP [16]
The F20 key (labelled Cut on many Sun workstations) or Control-w
copies the selection in the widget to the clipboard and deletes
the selection.
If there is no selection in the widget then these keys have no effect.
.IP [17]
The F18 key (labelled Paste on many Sun workstations) or Control-y
inserts the contents of the clipboard at the position of the
insertion cursor.
.IP [18]
The Delete key deletes the selection, if there is one in the entry.
If there is no selection, it deletes the character to the right of
the insertion cursor.
.IP [19]
The BackSpace key and Control-h delete the selection, if there is one
in the entry.
If there is no selection, it deletes the character to the left of
the insertion cursor.
.IP [20]
Control-d deletes the character to the right of the insertion cursor.
.IP [21]
Meta-d deletes the word to the right of the insertion cursor.
.IP [22]
Control-k deletes all the characters to the right of the insertion
cursor.
.IP [23]
Control-t reverses the order of the two characters to the right of
the insertion cursor.
.PP
If the entry is disabled using the \fB\-state\fR option, then the entry's
view can still be adjusted and text in the entry can still be selected,
but no insertion cursor will be displayed and no text modifications will
take place
except if the entry is linked to a variable using the \fB\-textvariable\fR
option, in which case any changes to the variable are reflected by the
entry whatever the value of its \fB\-state\fR option.
.PP
The behavior of entries can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.SH "SEE ALSO"
ttk::entry(n)
.SH KEYWORDS
entry, widget
'\" Local Variables:
'\" mode: nroff
'\" End:
