/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.raw;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.PrimaryIndex;
import com.sleepycat.client.persist.SecondaryIndex;
import com.sleepycat.client.persist.StoreConfig;
import com.sleepycat.client.persist.StoreExistsException;
import com.sleepycat.client.persist.StoreNotFoundException;
import com.sleepycat.client.persist.evolve.IncompatibleClassException;
import com.sleepycat.client.persist.evolve.Mutations;
import com.sleepycat.client.persist.impl.Store;
import com.sleepycat.client.persist.model.EntityModel;
import com.sleepycat.client.persist.raw.RawObject;

public class RawStore {
    private Store store;

    public RawStore(SEnvironment sEnvironment, String string, StoreConfig storeConfig) throws StoreNotFoundException, SDatabaseException {
        try {
            this.store = new Store(sEnvironment, string, storeConfig, true);
        }
        catch (StoreExistsException storeExistsException) {
            throw DbCompat.unexpectedException(storeExistsException);
        }
        catch (IncompatibleClassException incompatibleClassException) {
            throw DbCompat.unexpectedException(incompatibleClassException);
        }
    }

    public PrimaryIndex<Object, RawObject> getPrimaryIndex(String string) throws SDatabaseException {
        return this.store.getPrimaryIndex(Object.class, null, RawObject.class, string);
    }

    public SecondaryIndex<Object, Object, RawObject> getSecondaryIndex(String string, String string2) throws SDatabaseException {
        return this.store.getSecondaryIndex(this.getPrimaryIndex(string), RawObject.class, string, Object.class, null, string2);
    }

    public SEnvironment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    public void close() throws SDatabaseException {
        this.store.close();
    }
}

