/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.collections.BaseIterator;
import com.sleepycat.client.collections.DataCursor;
import com.sleepycat.client.collections.DataView;
import com.sleepycat.client.collections.StoredCollection;
import java.util.Set;

public class StoredValueSet<E>
extends StoredCollection<E>
implements Set<E> {
    public StoredValueSet(SDatabase sDatabase, EntryBinding<E> entryBinding, boolean bl) {
        super(new DataView(sDatabase, null, entryBinding, null, bl, null));
    }

    public StoredValueSet(SDatabase sDatabase, EntityBinding<E> entityBinding, boolean bl) {
        super(new DataView(sDatabase, null, null, entityBinding, bl, null));
    }

    StoredValueSet(DataView dataView) {
        super(dataView);
    }

    @Override
    public boolean add(E e) {
        if (this.view.isSecondary()) {
            throw new UnsupportedOperationException("Add not allowed with index");
        }
        if (this.view.range.isSingleKey()) {
            if (!this.view.dupsAllowed) {
                throw new UnsupportedOperationException("Duplicates required");
            }
            DataCursor dataCursor = null;
            boolean bl = this.beginAutoCommit();
            try {
                dataCursor = new DataCursor(this.view, true);
                dataCursor.useRangeKey();
                SOperationStatus sOperationStatus = dataCursor.putNoDupData(null, e, null, true);
                this.closeCursor(dataCursor);
                this.commitAutoCommit(bl);
                return sOperationStatus == SOperationStatus.SUCCESS;
            }
            catch (Exception exception) {
                this.closeCursor(dataCursor);
                throw this.handleException(exception, bl);
            }
        }
        if (this.view.entityBinding == null) {
            throw new UnsupportedOperationException("Add requires entity binding");
        }
        return this.add(null, e);
    }

    @Override
    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    @Override
    E makeIteratorData(BaseIterator baseIterator, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        return (E)this.view.makeValue(sDatabaseEntry2, sDatabaseEntry3);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

