/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SJoinConfig;
import com.sleepycat.client.SJoinCursor;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.collections.DataView;
import com.sleepycat.client.collections.MyRangeCursor;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.keyrange.KeyRange;
import com.sleepycat.client.util.keyrange.RangeCursor;
import java.nio.ByteOrder;

final class DataCursor
implements Cloneable {
    static final int REPOS_EXACT = 0;
    static final int REPOS_NEXT = 1;
    static final int REPOS_EOF = 2;
    private RangeCursor cursor;
    private SJoinCursor joinCursor;
    private DataView view;
    private KeyRange range;
    private boolean writeAllowed;
    private boolean readUncommitted;
    private SDatabaseEntry keyThang;
    private SDatabaseEntry valueThang;
    private SDatabaseEntry primaryKeyThang;
    private SDatabaseEntry otherThang;
    private DataCursor[] indexCursorsToClose;

    DataCursor(DataView dataView, boolean bl) throws SDatabaseException {
        this.init(dataView, bl, null, null);
    }

    DataCursor(DataView dataView, boolean bl, SCursorConfig sCursorConfig) throws SDatabaseException {
        this.init(dataView, bl, sCursorConfig, null);
    }

    DataCursor(DataView dataView, boolean bl, Object object) throws SDatabaseException {
        this.init(dataView, bl, null, dataView.subRange(dataView.range, object));
    }

    DataCursor(DataView dataView, boolean bl, Object object, boolean bl2, Object object2, boolean bl3) throws SDatabaseException {
        this.init(dataView, bl, null, dataView.subRange(dataView.range, object, bl2, object2, bl3));
    }

    DataCursor(DataView dataView, DataCursor[] dataCursorArray, SJoinConfig sJoinConfig, boolean bl) throws SDatabaseException {
        if (dataView.isSecondary()) {
            throw new IllegalArgumentException("The primary collection in a join must not be a secondary database");
        }
        SCursor[] sCursorArray = new SCursor[dataCursorArray.length];
        for (int i = 0; i < sCursorArray.length; ++i) {
            sCursorArray[i] = dataCursorArray[i].cursor.getCursor();
        }
        this.joinCursor = dataView.db.join(sCursorArray, sJoinConfig);
        this.init(dataView, false, null, null);
        if (bl) {
            this.indexCursorsToClose = dataCursorArray;
        }
    }

    DataCursor cloneCursor() throws SDatabaseException {
        DataCursor dataCursor;
        this.checkNoJoinCursor();
        try {
            dataCursor = (DataCursor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        dataCursor.initThangs();
        KeyRange.copy(this.keyThang, dataCursor.keyThang);
        KeyRange.copy(this.valueThang, dataCursor.valueThang);
        if (this.primaryKeyThang != this.keyThang) {
            KeyRange.copy(this.primaryKeyThang, dataCursor.primaryKeyThang);
        }
        dataCursor.cursor = this.cursor.dup(true);
        return dataCursor;
    }

    RangeCursor getCursor() {
        return this.cursor;
    }

    private void init(DataView dataView, boolean bl, SCursorConfig sCursorConfig, KeyRange keyRange) throws SDatabaseException {
        if (sCursorConfig == null) {
            sCursorConfig = dataView.cursorConfig;
        }
        this.view = dataView;
        this.writeAllowed = bl && dataView.writeAllowed;
        this.range = keyRange != null ? keyRange : dataView.range;
        this.readUncommitted = sCursorConfig.getReadUncommitted() || dataView.currentTxn.isReadUncommitted();
        this.initThangs();
        if (this.joinCursor == null) {
            this.cursor = new MyRangeCursor(this.range, sCursorConfig, dataView, this.writeAllowed);
        }
    }

    private void initThangs() {
        this.keyThang = new SDatabaseEntry();
        this.primaryKeyThang = this.view.isSecondary() ? new SDatabaseEntry() : this.keyThang;
        this.valueThang = new SDatabaseEntry();
    }

    private void setThangs(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.keyThang.setData(KeyRange.copyBytes(byArray));
        if (this.keyThang != this.primaryKeyThang) {
            this.primaryKeyThang.setData(KeyRange.copyBytes(byArray2));
        }
        this.valueThang.setData(KeyRange.copyBytes(byArray3));
    }

    void close() throws SDatabaseException {
        DataCursor[] dataCursorArray;
        if (this.joinCursor != null) {
            dataCursorArray = this.joinCursor;
            this.joinCursor = null;
            dataCursorArray.close();
        }
        if (this.cursor != null) {
            dataCursorArray = this.cursor.getCursor();
            this.cursor = null;
            this.view.currentTxn.closeCursor((SCursor)dataCursorArray);
        }
        if (this.indexCursorsToClose != null) {
            dataCursorArray = this.indexCursorsToClose;
            this.indexCursorsToClose = null;
            for (int i = 0; i < dataCursorArray.length; ++i) {
                dataCursorArray[i].close();
            }
        }
    }

    int repositionRange(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) throws SDatabaseException {
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(this.getLockMode(bl));
        DbCompat.OpResult opResult = null;
        this.setThangs(byArray, byArray2, byArray3);
        if (this.view.dupsAllowed) {
            opResult = this.cursor.getSearchBothRange(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions);
        }
        if (opResult == null || !opResult.isSuccess()) {
            opResult = this.cursor.getSearchKeyRange(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions);
        }
        if (opResult.isSuccess()) {
            if (!KeyRange.equalBytes(byArray, 0, byArray.length, this.keyThang.getData(), this.keyThang.getOffset(), this.keyThang.getSize())) {
                return 1;
            }
            if (this.view.dupsAllowed) {
                byte[] byArray4;
                SDatabaseEntry sDatabaseEntry = this.view.isSecondary() ? this.primaryKeyThang : this.valueThang;
                byte[] byArray5 = byArray4 = this.view.isSecondary() ? byArray2 : byArray3;
                if (!KeyRange.equalBytes(byArray4, 0, byArray4.length, sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), sDatabaseEntry.getSize())) {
                    return 1;
                }
            }
            return 0;
        }
        return 2;
    }

    boolean repositionExact(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) throws SDatabaseException {
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(this.getLockMode(bl));
        this.setThangs(byArray, byArray2, byArray3);
        DbCompat.OpResult opResult = this.view.recNumRenumber ? this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions) : this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions);
        return opResult.isSuccess();
    }

    DataView getView() {
        return this.view;
    }

    KeyRange getRange() {
        return this.range;
    }

    boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    Object getCurrentKey() {
        return this.view.makeKey(this.keyThang, this.primaryKeyThang);
    }

    Object getCurrentValue() {
        return this.view.makeValue(this.primaryKeyThang, this.valueThang);
    }

    SDatabaseEntry getKeyThang() {
        return this.keyThang;
    }

    SDatabaseEntry getPrimaryKeyThang() {
        return this.primaryKeyThang;
    }

    SDatabaseEntry getValueThang() {
        return this.valueThang;
    }

    boolean hasRecNumAccess() {
        return this.view.recNumAccess;
    }

    int getCurrentRecordNumber() throws SDatabaseException {
        if (this.view.btreeRecNumDb) {
            if (this.otherThang == null) {
                this.otherThang = new SDatabaseEntry();
            }
            DbCompat.getCurrentRecordNumber(this.cursor.getCursor(), this.otherThang, this.getLockMode(false));
            return DbCompat.getRecordNumber(this.otherThang, this.getServerByteOrder());
        }
        return DbCompat.getRecordNumber(this.keyThang, this.getServerByteOrder());
    }

    private ByteOrder getServerByteOrder() {
        return this.view.getServerByteOrder();
    }

    SOperationStatus getCurrent(boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(this.getLockMode(bl))).status();
    }

    SOperationStatus getFirst(boolean bl) throws SDatabaseException {
        SLockMode sLockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, sLockMode);
        }
        return this.cursor.getFirst(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(sLockMode)).status();
    }

    SOperationStatus getNext(boolean bl) throws SDatabaseException {
        SLockMode sLockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, sLockMode);
        }
        return this.cursor.getNext(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(sLockMode)).status();
    }

    SOperationStatus getNextNoDup(boolean bl) throws SDatabaseException {
        SLockMode sLockMode = this.getLockMode(bl);
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(sLockMode);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, sLockMode);
        }
        if (this.view.dupsView) {
            return this.cursor.getNext(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions).status();
        }
        return this.cursor.getNextNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions).status();
    }

    SOperationStatus getNextDup(boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return null;
        }
        return this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(this.getLockMode(bl))).status();
    }

    SOperationStatus getLast(boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getLast(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(this.getLockMode(bl))).status();
    }

    SOperationStatus getPrev(boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getPrev(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(this.getLockMode(bl))).status();
    }

    SOperationStatus getPrevNoDup(boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        SLockMode sLockMode = this.getLockMode(bl);
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(sLockMode);
        if (this.view.dupsView) {
            return null;
        }
        return this.cursor.getPrevNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions).status();
    }

    SOperationStatus getPrevDup(boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return null;
        }
        return this.cursor.getPrevDup(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(this.getLockMode(bl))).status();
    }

    SOperationStatus getSearchKey(Object object, Object object2, boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            if (this.view.useKey(object, object2, this.primaryKeyThang, this.view.dupsRange)) {
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                return this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(this.getLockMode(bl))).status();
            }
        } else if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            return this.doGetSearchKey(bl);
        }
        return SOperationStatus.NOTFOUND;
    }

    private SOperationStatus doGetSearchKey(boolean bl) throws SDatabaseException {
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(this.getLockMode(bl));
        if (this.view.btreeRecNumAccess) {
            return this.cursor.getSearchRecordNumber(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions).status();
        }
        return this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions).status();
    }

    SOperationStatus getSearchKeyRange(Object object, Object object2, boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(this.getLockMode(bl));
        if (this.view.dupsView) {
            if (this.view.useKey(object, object2, this.primaryKeyThang, this.view.dupsRange)) {
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                return this.cursor.getSearchBothRange(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions).status();
            }
        } else if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            return this.cursor.getSearchKeyRange(this.keyThang, this.primaryKeyThang, this.valueThang, opReadOptions).status();
        }
        return SOperationStatus.NOTFOUND;
    }

    SOperationStatus findBoth(Object object, Object object2, boolean bl) throws SDatabaseException {
        this.checkNoJoinCursor();
        DbCompat.OpReadOptions opReadOptions = DbCompat.OpReadOptions.make(this.getLockMode(bl));
        this.view.useValue(object2, this.valueThang, null);
        if (this.view.dupsView) {
            if (this.view.useKey(object, object2, this.primaryKeyThang, this.view.dupsRange)) {
                SOperationStatus sOperationStatus;
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                if (this.otherThang == null) {
                    this.otherThang = new SDatabaseEntry();
                }
                if ((sOperationStatus = this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.otherThang, opReadOptions).status()) == SOperationStatus.SUCCESS && KeyRange.equalBytes(this.otherThang, this.valueThang)) {
                    return sOperationStatus;
                }
            }
        } else if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            if (this.view.isSecondary()) {
                if (this.otherThang == null) {
                    this.otherThang = new SDatabaseEntry();
                }
                SOperationStatus sOperationStatus = this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.otherThang, opReadOptions).status();
                while (sOperationStatus == SOperationStatus.SUCCESS) {
                    if (KeyRange.equalBytes(this.otherThang, this.valueThang)) {
                        return sOperationStatus;
                    }
                    sOperationStatus = this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.otherThang, opReadOptions).status();
                }
            } else {
                return this.cursor.getSearchBoth(this.keyThang, null, this.valueThang, opReadOptions).status();
            }
        }
        return SOperationStatus.NOTFOUND;
    }

    SOperationStatus findValue(Object object, boolean bl) throws SDatabaseException {
        SOperationStatus sOperationStatus;
        this.checkNoJoinCursor();
        if (!(this.view.entityBinding == null || this.view.isSecondary() || !bl && this.view.dupsAllowed)) {
            return this.findBoth(null, object, false);
        }
        if (this.otherThang == null) {
            this.otherThang = new SDatabaseEntry();
        }
        this.view.useValue(object, this.otherThang, null);
        SOperationStatus sOperationStatus2 = sOperationStatus = bl ? this.getFirst(false) : this.getLast(false);
        while (sOperationStatus == SOperationStatus.SUCCESS && !KeyRange.equalBytes(this.valueThang, this.otherThang)) {
            sOperationStatus = bl ? this.getNext(false) : this.getPrev(false);
        }
        return sOperationStatus;
    }

    int count() throws SDatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return 1;
        }
        return this.cursor.count();
    }

    SOperationStatus putCurrent(Object object) throws SDatabaseException {
        boolean bl;
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, this.keyThang);
        boolean bl2 = bl = this.view.dupsOrdered && !this.view.ordered;
        if (bl) {
            if (this.otherThang == null) {
                this.otherThang = new SDatabaseEntry();
            }
            this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.otherThang, DbCompat.OpReadOptions.EMPTY);
            if (KeyRange.equalBytes(this.valueThang, this.otherThang)) {
                return SOperationStatus.SUCCESS;
            }
            throw new IllegalArgumentException("Current data differs from put data with sorted duplicates");
        }
        return this.cursor.putCurrent(this.valueThang);
    }

    SOperationStatus putAfter(Object object) throws SDatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, null);
        return this.cursor.putAfter(this.keyThang, this.valueThang);
    }

    SOperationStatus putBefore(Object object) throws SDatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, this.keyThang);
        return this.cursor.putBefore(this.keyThang, this.valueThang);
    }

    SOperationStatus put(Object object, Object object2, Object[] objectArray, boolean bl) throws SDatabaseException {
        this.initForPut(object, object2, objectArray, bl);
        return this.cursor.put(this.keyThang, this.valueThang);
    }

    SOperationStatus putNoOverwrite(Object object, Object object2, boolean bl) throws SDatabaseException {
        this.initForPut(object, object2, null, bl);
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    SOperationStatus putNoDupData(Object object, Object object2, Object[] objectArray, boolean bl) throws SDatabaseException {
        this.initForPut(object, object2, objectArray, bl);
        if (this.view.dupsOrdered) {
            return this.cursor.putNoDupData(this.keyThang, this.valueThang);
        }
        if (this.view.dupsAllowed) {
            SOperationStatus sOperationStatus = this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, DbCompat.OpReadOptions.make(this.getLockMode(false))).status();
            if (sOperationStatus == SOperationStatus.SUCCESS) {
                return SOperationStatus.KEYEXIST;
            }
            return this.cursor.put(this.keyThang, this.valueThang);
        }
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    private void initForPut(Object object, Object object2, Object[] objectArray, boolean bl) throws SDatabaseException {
        this.checkWriteAllowed(false);
        if (!bl && !this.view.useKey(object, object2, this.keyThang, this.range)) {
            throw new IllegalArgumentException("key out of range");
        }
        if (objectArray != null) {
            SOperationStatus sOperationStatus;
            objectArray[0] = null;
            if (!this.view.dupsAllowed && (sOperationStatus = this.doGetSearchKey(true)) == SOperationStatus.SUCCESS) {
                objectArray[0] = this.getCurrentValue();
            }
        }
        this.view.useValue(object2, this.valueThang, this.keyThang);
    }

    void useRangeKey() {
        if (!this.range.isSingleKey()) {
            throw DbCompat.unexpectedState();
        }
        KeyRange.copy(this.range.getSingleKey(), this.keyThang);
    }

    SOperationStatus delete() throws SDatabaseException {
        this.checkWriteAllowed(true);
        return this.cursor.delete();
    }

    SLockMode getLockMode(boolean bl) {
        if (this.readUncommitted) {
            return SLockMode.READ_UNCOMMITTED;
        }
        if (bl) {
            return this.view.currentTxn.getWriteLockMode();
        }
        return SLockMode.DEFAULT;
    }

    private void checkNoJoinCursor() {
        if (this.joinCursor != null) {
            throw new UnsupportedOperationException("Not allowed with a join cursor");
        }
    }

    private void checkWriteAllowed(boolean bl) {
        this.checkNoJoinCursor();
        if (!this.writeAllowed || !bl && this.view.isSecondary()) {
            throw new UnsupportedOperationException("Writing is not allowed");
        }
    }
}

