/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SEnvironmentConfig;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.STransactionConfig;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class CurrentTransaction {
    private static WeakHashMap<SEnvironment, CurrentTransaction> envMap = new WeakHashMap();
    private SLockMode writeLockMode;
    private boolean cdbMode;
    private boolean txnMode;
    private boolean lockingMode;
    private ThreadLocal localTrans = new ThreadLocal();
    private ThreadLocal localCdbCursors;
    private WeakReference<SEnvironment> envRef;

    public static CurrentTransaction getInstance(SEnvironment sEnvironment) {
        CurrentTransaction currentTransaction = CurrentTransaction.getInstanceInternal(sEnvironment);
        return currentTransaction.isTxnMode() ? currentTransaction : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CurrentTransaction getInstanceInternal(SEnvironment sEnvironment) {
        WeakHashMap<SEnvironment, CurrentTransaction> weakHashMap = envMap;
        synchronized (weakHashMap) {
            CurrentTransaction currentTransaction = envMap.get(sEnvironment);
            if (currentTransaction == null) {
                currentTransaction = new CurrentTransaction(sEnvironment);
                envMap.put(sEnvironment, currentTransaction);
            }
            return currentTransaction;
        }
    }

    private CurrentTransaction(SEnvironment sEnvironment) {
        this.envRef = new WeakReference<SEnvironment>(sEnvironment);
        try {
            SEnvironmentConfig sEnvironmentConfig = sEnvironment.getConfig();
            this.txnMode = sEnvironmentConfig.getTransactional();
            this.lockingMode = DbCompat.getInitializeLocking(sEnvironmentConfig);
            this.writeLockMode = this.txnMode || this.lockingMode ? SLockMode.RMW : SLockMode.DEFAULT;
            this.cdbMode = DbCompat.getInitializeCDB(sEnvironmentConfig);
            if (this.cdbMode) {
                this.localCdbCursors = new ThreadLocal();
            }
        }
        catch (SDatabaseException sDatabaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
        }
    }

    final boolean isLockingMode() {
        return this.lockingMode;
    }

    final boolean isTxnMode() {
        return this.txnMode;
    }

    final boolean isCdbMode() {
        return this.cdbMode;
    }

    final SLockMode getWriteLockMode() {
        return this.writeLockMode;
    }

    public final SEnvironment getEnvironment() {
        return (SEnvironment)this.envRef.get();
    }

    public final STransaction getTransaction() {
        Trans trans = (Trans)this.localTrans.get();
        return trans != null ? trans.txn : null;
    }

    boolean isAutoCommitAllowed() throws SDatabaseException {
        return this.getTransaction() == null && DbCompat.getThreadTransaction(this.getEnvironment()) == null;
    }

    public final STransaction beginTransaction(STransactionConfig sTransactionConfig) throws SDatabaseException {
        SEnvironment sEnvironment = this.getEnvironment();
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null) {
            if (trans.txn != null) {
                STransaction sTransaction = trans.txn;
                trans = new Trans(trans, sTransactionConfig);
                trans.txn = sEnvironment.beginTransaction(sTransaction, sTransactionConfig);
                this.localTrans.set(trans);
            } else {
                trans.txn = sEnvironment.beginTransaction(null, sTransactionConfig);
                trans.config = sTransactionConfig;
            }
        } else {
            trans = new Trans(null, sTransactionConfig);
            trans.txn = sEnvironment.beginTransaction(null, sTransactionConfig);
            this.localTrans.set(trans);
        }
        return trans.txn;
    }

    public final STransaction commitTransaction() throws SDatabaseException, IllegalStateException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.txn != null) {
            STransaction sTransaction = this.closeTxn(trans);
            trans.txn.commit();
            return sTransaction;
        }
        throw new IllegalStateException("No transaction is active");
    }

    public final STransaction abortTransaction() throws SDatabaseException, IllegalStateException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.txn != null) {
            STransaction sTransaction = this.closeTxn(trans);
            trans.txn.abort();
            return sTransaction;
        }
        throw new IllegalStateException("No transaction is active");
    }

    final boolean isReadUncommitted() {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.config != null) {
            return trans.config.getReadUncommitted();
        }
        return false;
    }

    private STransaction closeTxn(Trans trans) {
        this.localTrans.set(trans.parent);
        return trans.parent != null ? trans.parent.txn : null;
    }

    SCursor openCursor(SDatabase sDatabase, SCursorConfig sCursorConfig, boolean bl, STransaction sTransaction) throws SDatabaseException {
        if (this.cdbMode) {
            SCursor sCursor;
            SCursorConfig sCursorConfig2;
            List list;
            CdbCursors cdbCursors = null;
            WeakHashMap<SDatabase, CdbCursors> weakHashMap = (WeakHashMap<SDatabase, CdbCursors>)this.localCdbCursors.get();
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap<SDatabase, CdbCursors>();
                this.localCdbCursors.set(weakHashMap);
            } else {
                cdbCursors = (CdbCursors)weakHashMap.get(sDatabase);
            }
            if (cdbCursors == null) {
                cdbCursors = new CdbCursors();
                weakHashMap.put(sDatabase, cdbCursors);
            }
            if (bl) {
                if (cdbCursors.readCursors.size() > 0) {
                    throw new IllegalStateException("Cannot open CDB write cursor when read cursor is open");
                }
                list = cdbCursors.writeCursors;
                sCursorConfig2 = new SCursorConfig();
                DbCompat.setWriteCursor(sCursorConfig2, true);
            } else {
                list = cdbCursors.readCursors;
                sCursorConfig2 = null;
            }
            if (list.size() > 0) {
                SCursor sCursor2 = (SCursor)list.get(0);
                sCursor = sCursor2.dup(false);
            } else {
                sCursor = sDatabase.openCursor(null, sCursorConfig2);
            }
            list.add(sCursor);
            return sCursor;
        }
        return sDatabase.openCursor(sTransaction, sCursorConfig);
    }

    SCursor dupCursor(SCursor sCursor, boolean bl, boolean bl2) throws SDatabaseException {
        if (this.cdbMode) {
            SDatabase sDatabase;
            CdbCursors cdbCursors;
            WeakHashMap weakHashMap = (WeakHashMap)this.localCdbCursors.get();
            if (weakHashMap != null && (cdbCursors = (CdbCursors)weakHashMap.get(sDatabase = sCursor.getDatabase())) != null) {
                List list;
                List list2 = list = bl ? cdbCursors.writeCursors : cdbCursors.readCursors;
                if (list.contains(sCursor)) {
                    SCursor sCursor2 = sCursor.dup(bl2);
                    list.add(sCursor2);
                    return sCursor2;
                }
            }
            throw new IllegalStateException("SCursor to dup not tracked");
        }
        return sCursor.dup(bl2);
    }

    void closeCursor(SCursor sCursor) throws SDatabaseException {
        if (sCursor == null) {
            return;
        }
        if (this.cdbMode) {
            SDatabase sDatabase;
            CdbCursors cdbCursors;
            WeakHashMap weakHashMap = (WeakHashMap)this.localCdbCursors.get();
            if (weakHashMap != null && (cdbCursors = (CdbCursors)weakHashMap.get(sDatabase = sCursor.getDatabase())) != null && (cdbCursors.readCursors.remove(sCursor) || cdbCursors.writeCursors.remove(sCursor))) {
                sCursor.close();
                return;
            }
            throw new IllegalStateException("Closing CDB cursor that was not known to be open");
        }
        sCursor.close();
    }

    boolean isCDBCursorOpen(SDatabase sDatabase) {
        CdbCursors cdbCursors;
        WeakHashMap weakHashMap;
        return this.cdbMode && (weakHashMap = (WeakHashMap)this.localCdbCursors.get()) != null && (cdbCursors = (CdbCursors)weakHashMap.get(sDatabase)) != null && (cdbCursors.readCursors.size() > 0 || cdbCursors.writeCursors.size() > 0);
    }

    static final class CdbCursors {
        List writeCursors = new ArrayList();
        List readCursors = new ArrayList();

        CdbCursors() {
        }
    }

    private static class Trans {
        private Trans parent;
        private STransaction txn;
        private STransactionConfig config;

        private Trans(Trans trans, STransactionConfig sTransactionConfig) {
            this.parent = trans;
            this.config = sTransactionConfig;
        }
    }
}

