/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.util.FastOutputStream;
import com.sleepycat.client.util.PackedInteger;
import com.sleepycat.client.util.UtfOps;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TupleOutput
extends FastOutputStream {
    static final int NULL_STRING_UTF_VALUE = -1;

    public TupleOutput() {
    }

    public TupleOutput(byte[] byArray) {
        super(byArray);
    }

    public final TupleOutput writeBytes(String string) {
        this.writeBytes(string.toCharArray());
        return this;
    }

    public final TupleOutput writeChars(String string) {
        this.writeChars(string.toCharArray());
        return this;
    }

    public final TupleOutput writeString(String string) {
        if (string != null) {
            this.writeString(string.toCharArray());
        } else {
            this.writeFast(-1);
        }
        this.writeFast(0);
        return this;
    }

    public final TupleOutput writeChar(int n) {
        this.writeFast((byte)(n >>> 8));
        this.writeFast((byte)n);
        return this;
    }

    public final TupleOutput writeBoolean(boolean bl) {
        this.writeFast(bl ? 1 : 0);
        return this;
    }

    public final TupleOutput writeByte(int n) {
        this.writeUnsignedByte(n ^ 0x80);
        return this;
    }

    public final TupleOutput writeShort(int n) {
        this.writeUnsignedShort(n ^ 0x8000);
        return this;
    }

    public final TupleOutput writeInt(int n) {
        this.writeUnsignedInt(n ^ Integer.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeLong(long l) {
        this.writeUnsignedLong(l ^ Long.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeFloat(float f) {
        this.writeUnsignedInt(Float.floatToIntBits(f));
        return this;
    }

    public final TupleOutput writeDouble(double d) {
        this.writeUnsignedLong(Double.doubleToLongBits(d));
        return this;
    }

    public final TupleOutput writeSortedFloat(float f) {
        int n;
        this.writeUnsignedInt(n ^= (n = Float.floatToIntBits(f)) < 0 ? -1 : Integer.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeSortedDouble(double d) {
        long l;
        this.writeUnsignedLong(l ^= (l = Double.doubleToLongBits(d)) < 0L ? -1L : Long.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeBytes(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.writeFast((byte)cArray[i]);
        }
        return this;
    }

    public final TupleOutput writeChars(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.writeFast((byte)(cArray[i] >>> 8));
            this.writeFast((byte)cArray[i]);
        }
        return this;
    }

    public final TupleOutput writeString(char[] cArray) {
        if (cArray.length == 0) {
            return this;
        }
        int n = UtfOps.getByteLength(cArray);
        this.makeSpace(n);
        UtfOps.charsToBytes(cArray, 0, this.getBufferBytes(), this.getBufferLength(), cArray.length);
        this.addSize(n);
        return this;
    }

    public final TupleOutput writeUnsignedByte(int n) {
        this.writeFast(n);
        return this;
    }

    public final TupleOutput writeUnsignedShort(int n) {
        this.writeFast((byte)(n >>> 8));
        this.writeFast((byte)n);
        return this;
    }

    public final TupleOutput writeUnsignedInt(long l) {
        this.writeFast((byte)(l >>> 24));
        this.writeFast((byte)(l >>> 16));
        this.writeFast((byte)(l >>> 8));
        this.writeFast((byte)l);
        return this;
    }

    private final TupleOutput writeUnsignedLong(long l) {
        this.writeFast((byte)(l >>> 56));
        this.writeFast((byte)(l >>> 48));
        this.writeFast((byte)(l >>> 40));
        this.writeFast((byte)(l >>> 32));
        this.writeFast((byte)(l >>> 24));
        this.writeFast((byte)(l >>> 16));
        this.writeFast((byte)(l >>> 8));
        this.writeFast((byte)l);
        return this;
    }

    public final TupleOutput writePackedInt(int n) {
        this.makeSpace(5);
        int n2 = this.getBufferLength();
        int n3 = PackedInteger.writeInt(this.getBufferBytes(), n2, n);
        this.addSize(n3 - n2);
        return this;
    }

    public final TupleOutput writePackedLong(long l) {
        this.makeSpace(9);
        int n = this.getBufferLength();
        int n2 = PackedInteger.writeLong(this.getBufferBytes(), n, l);
        this.addSize(n2 - n);
        return this;
    }

    public final TupleOutput writeSortedPackedInt(int n) {
        this.makeSpace(5);
        int n2 = this.getBufferLength();
        int n3 = PackedInteger.writeSortedInt(this.getBufferBytes(), n2, n);
        this.addSize(n3 - n2);
        return this;
    }

    public final TupleOutput writeSortedPackedLong(long l) {
        this.makeSpace(9);
        int n = this.getBufferLength();
        int n2 = PackedInteger.writeSortedLong(this.getBufferBytes(), n, l);
        this.addSize(n2 - n);
        return this;
    }

    public final TupleOutput writeBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("BigInteger byte array is larger than 0x7fff bytes");
        }
        byte by = byArray[0];
        this.writeShort(by < 0 ? -byArray.length : byArray.length);
        this.writeByte(by);
        this.writeFast(byArray, 1, byArray.length - 1);
        return this;
    }

    public static int getBigIntegerByteLength(BigInteger bigInteger) {
        return 2 + (bigInteger.bitLength() + 1 + 7) / 8;
    }

    public final TupleOutput writeBigDecimal(BigDecimal bigDecimal) {
        int n = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue();
        this.writePackedInt(n);
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        this.writePackedInt(n2);
        this.writeFast(byArray, 0, n2);
        return this;
    }

    public static int getBigDecimalMaxByteLength(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        return 10 + bigInteger.toByteArray().length;
    }

    public final TupleOutput writeSortedBigDecimal(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        int n = bigDecimal2.scale();
        BigInteger bigInteger = bigDecimal2.unscaledValue();
        int n2 = bigDecimal2.signum();
        String string = bigInteger.abs().toString();
        int n3 = string.length() - 1;
        BigDecimal bigDecimal3 = new BigDecimal(bigInteger, n3);
        int n4 = (n3 - n) * n2;
        this.writeByte(n2);
        this.writeSortedPackedInt(n4);
        this.writeSortedNormalizedBigDecimal(bigDecimal3);
        return this;
    }

    private final TupleOutput writeSortedNormalizedBigDecimal(BigDecimal bigDecimal) {
        int n = bigDecimal.precision();
        int n2 = bigDecimal.scale();
        int n3 = bigDecimal.signum();
        String string = bigDecimal.abs().toPlainString();
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        while (n4 < string.length()) {
            int n5;
            char c;
            if ((c = string.charAt(n4++)) != '.') {
                stringBuilder.append(c);
            }
            if (n4 == string.length() && stringBuilder.length() < 9) {
                n5 = 9 - stringBuilder.length();
                for (int i = 0; i < n5; ++i) {
                    stringBuilder.append("0");
                }
            }
            if (stringBuilder.length() != 9) continue;
            n5 = Integer.valueOf(stringBuilder.toString());
            if (n3 < 0) {
                n5 = -n5;
            }
            n5 = n5 < 0 ? n5 - 1 : n5;
            this.writeSortedPackedInt(n5);
            stringBuilder.setLength(0);
        }
        this.writeSortedPackedInt(-1);
        return this;
    }

    public static int getSortedBigDecimalMaxByteLength(BigDecimal bigDecimal) {
        String string = bigDecimal.stripTrailingZeros().unscaledValue().abs().toString();
        int n = (string.length() + 8) / 9;
        return 6 + 5 * n + 1;
    }
}

