# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sugar_stats import sniffers
from sugar_stats.collector import Collector as _Collector
from sugar_stats.rrd import Rrd


class Collector(_Collector):

    def __init__(self, backend=None):
        if backend is None:
            backend = _FakeBackend()
        _Collector.__init__(self, [cls() for cls in sniffers.each()], backend)


class _FakeBackend(object):

    step = 0
