#!/usr/bin/env python

# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import optparse
from os.path import dirname, join, realpath
from gettext import gettext as _

from gevent.wsgi import WSGIServer
from sugar_network import sugar


SRC_ROOT = dirname(realpath(__file__))


host = optparse.Option(
        _('address to listen for Web clients'),
        default='127.0.0.1')

port = optparse.Option(
        _('address to listen for Web clients'),
        default=5000)


class Application(application.Daemon):

    httpd = None

    def start(self):
        application.logdir.value = sugar.profile_path('logs')
        application.rundir.value = sugar.profile_path('run')
        application.Daemon.start(self)

    def run(self):
        app = self._get_app()
        self.httpd = WSGIServer((host.value, port.value), app)
        self.httpd.serve_forever()

    def shutdown(self):
        if self.httpd is not None:
            self.httpd.stop()

    @application.command(_('Run application in debug mode'))
    def debug(self):
        app = self._get_app()
        app.debug = True
        app.run(host=host.value, port=port.value)

    def _get_app(self):
        try:
            from mejorar_sistema.app import app
        except ImportError:
            # Reuse from sources diretory
            sys.path.insert(0, join(SRC_ROOT, 'app'))
            from app import app
        return app


optparse.Option.seek('mejorar-sistema')
optparse.Option.seek('mejorar-sistema',
        [application.debug, application.foreground])

app = Application(
        name='mejorar-sistema',
        description=_('Flask server to serve Sugar Network users'),
        epilog=_('See http://wiki.sugarlabs.org/go/Platform_Team/' \
                 'Sugar_Network/Browser.'),
        config_files=[
            '/etc/sweets.conf',
            '~/.config/sweets/config',
            sugar.profile_path('sweets.conf'),
            ])
app.start()
