#!/usr/bin/env python

# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# sugar-lint: disable

import sys

from sugar_network.resources.volume import Volume


if len(sys.argv) != 2:
    print 'Usage: %s PATH' % sys.argv[0]
    exit(1)

volume = Volume(sys.argv[1])
try:
    volume.populate()

    for context in volume['context'].find(limit=1000000, layer='deleted')[0]:
        print 'Hide all relatives for %s' % context.guid
        for document in ('artifact', 'feedback', 'implementation'):
            for child in volume[document].find(limit=1000000, context=context.guid)[0]:
                if 'deleted' not in child['layer']:
                    volume[document].update(child.guid, layer=['deleted'])
finally:
    volume.close()
