#!/usr/bin/env python
# sugar-lint: disable

import json

import restkit

from __init__ import tests
from tests import Resource

import restful_document as rd
import active_document as ad

from restful_document import env, router


class UserTest(tests.Test):

    def setUp(self):
        tests.Test.setUp(self)
        env.principal.authenticated.clear()
        env.request.environ = {}

    def test_Register(self):
        self.httpd(8000, [rd.User])
        rest = Resource('http://localhost:8000')

        props = {
            'nickname': 'foo',
            'color': '',
            'machine_sn': 'machine_sn',
            'machine_uuid': 'machine_uuid',
            }

        props['pubkey'] = tests.INVALID_DSS_PUBKEY
        self.assertRaises(restkit.Unauthorized, rest.post, '/user', payload=json.dumps(props), headers=tests.creds())

        props['pubkey'] = tests.VALID_DSS_PUBKEY
        reply = json.loads(rest.post('/user', payload=json.dumps(props), headers=tests.creds()).body_string())
        self.assertEqual(tests.UID_FOR_PUBKEY, reply['guid'])

    def test_Authenticate(self):

        def set_headers(user):
            env.request.environ['HTTP_SUGAR_USER'] = user
            env.request.environ['HTTP_SUGAR_USER_SIGNATURE'] = tests.sign(user)

        props = {
            'nickname': 'foo',
            'color': '',
            'machine_sn': 'machine_sn',
            'machine_uuid': 'machine_uuid',
            'pubkey': tests.VALID_DSS_PUBKEY,
            }
        self.httpd(8888, [rd.User])
        rest = Resource('http://localhost:8888')
        rest.post('/user', payload=json.dumps(props), headers=tests.creds())
        self.httpdown(8888)

        with ad.Master([rd.User]):
            env.principal.user = None

            set_headers('foo')
            self.assertRaises(env.Unauthorized, router._authenticate)
            self.assertEqual(None, env.principal.user)

            set_headers(tests.UID_FOR_PUBKEY)
            router._authenticate()
            self.assertEqual(tests.UID_FOR_PUBKEY, env.principal.user)






if __name__ == '__main__':
    tests.main()
