/*
 * $Id: os_os2.h,v 4.3 1996/03/16 21:53:00 mikes Exp $
 *
 * Program:	Operating system dependent routines - Ultrix 4.1
 *
 *
 * Michael Seibel
 * Networks and Distributed Computing
 * Computing and Communications
 * University of Washington
 * Administration Builiding, AG-44
 * Seattle, Washington, 98195, USA
 * Internet: mikes@cac.washington.edu
 *
 * Please address all bugs and comments to "pine-bugs@cac.washington.edu"
 *
 *
 * Pine and Pico are registered trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior written
 * permission of the University of Washington.
 * 
 * Pine, Pico, and Pilot software and its included text are Copyright
 * 1989-1996 by the University of Washington.
 * 
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this distribution.
 */

#ifndef	OSDEP_H
#define	OSDEP_H

#include	<stdlib.h>
#include	<string.h>
#include	<signal.h>
#include	<ctype.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<dirent.h>
#define INCL_BASE
#define INCL_NOPM
#define INCL_VIO
#define INCL_KBD
#define INCL_MOU
#define INCL_DOS
#include	<os2.h>


/* define machine specifics */
#define	IBMPC	1

#define	_O_RDONLY O_RDONLY

/*
 * type qsort expects
 */
#define	QSType	void
#define QcompType const void


/*
 * File name separators, char and string
 */
#define	C_FILESEP	'\\'
#define	S_FILESEP	"\\"


/*
 * What and where the tool that checks spelling is located.  If this is
 * undefined, then the spelling checker is not compiled into pico.
 */
#define	SPELLER "ispell"


/*
 * Mode passed chmod() to make tmp files exclusively user read/write-able
 */
#define	MODE_READONLY	(S_IREAD | S_IWRITE)


#ifdef	maindef
/*	possible names and paths of help files under different OSs	*/

char *pathname[] = {
	"picorc",
	"pico.hlp",
	"\\usr\\local\\",
	"\\usr\\lib\\",
	""
};

#define	NPNAMES	(sizeof(pathname)/sizeof(char *))

jmp_buf got_hup;

struct KBSTREE *kpadseqs = NULL;

int os2_fflush(FILE *f);

#ifndef fflush
#define fflush os2_fflush
#endif

#endif

int kbd_ready();
int kbd_getkey();
int kbd_peek();
void kbd_flush();

#endif	/* !OSDEP_H */
