/** \file sg_traits.hxx
 * Provides a char_traits declaration for systems without it.
 * \internal
 */

#ifndef _SG_TRAITS_HXX
#define _SG_TRAITS_HXX

#include <simgear/compiler.h>

#ifndef SG_HAVE_TRAITS

// Dummy up some char traits for now.
template<class charT> struct char_traits{};

SG_TEMPLATE_NULL
struct char_traits<char>
{
    typedef char      char_type;
    typedef int       int_type;
    typedef streampos pos_type;
    typedef streamoff off_type;

    static int_type eof() { return EOF; }
};
#endif // SG_HAVE_TRAITS

#endif // _SG_TRAITS_HXX
