/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.validation;

import java.io.PrintStream;

import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;

/**
 * Implements all validation listeners and messages about validation
 * events to <code>PrintStream</code>. Default <code>PrintStream</code> is
 * <code>System.out</code>.
 *
 * @author Maxim Mazin
 * @version Revision: 1
 */
public class ValidationMessenger implements
        StructureListener,
        ConsistencyListener,
        CompletenessListener {
    PrintStream out;

    public ValidationMessenger() {
        this(System.out);
    }

    public ValidationMessenger(PrintStream out) {
        this.out = out;
    }

    public void noInitState(StateMachine sm, State state) {
        out.println(sm+"> Composite state " + state + " has no initial substate.");
    }

    public void redundantInitStates(StateMachine sm, State state, int initStatesNumber) {
        out.println(sm+"> Composite state " + state + " has " + initStatesNumber +" initial substates.");
    }

    public void unattainableState(StateMachine sm, State state) {
        out.println(sm+"> State " + state + " is unattainable.");
    }

    public void incompleteGuardSet(StateMachine sm, State state, Event event, Guard guard) {
        out.println(sm+"> The system of transitions from state "+state+
                           " on event " + event + " is incomplete." +
                           " Transition is defined only for " + guard);
    }

    public void inconsistentGuardSet(StateMachine sm, Transition t1, Transition t2, Guard guard) {
        out.println(sm+"> Transitions " + t1 +  " and " + t2 + " are inconsistent. " +
                           "Both transite on guard " + guard);
    }

    public void redundantElseTransitions(StateMachine sm, State state, Event e, int elseTransitionsNumber) {
        out.println(sm+"> State " + state + " has " + elseTransitionsNumber + " for event " + e + ". It is too much");
    }

    public void notRootStateMachineHasEventProviders(StateMachine sm) {
        out.println(sm+"> Not root StateMachine " + sm + " has associated EventProviders.");
    }

    public void badTransitionFromInitState(StateMachine sm, Transition transition) {
        out.println(sm+"> Bad transition ["+ transition+"] from init state [" + transition.getSourceState() + "] of state machine ["+sm+"].");
    }

    public void noTransitionFromInitState(StateMachine sm, State initState) {
        out.println(sm+"> No outgoing transitions from init state [" + initState + "] of state machine ["+sm+"].");
    }

    public void redundantTransitionsFromInitState(StateMachine sm, State initState, int transitionsNumber) {
        out.println(sm+"> Init state [" + initState + "] of state machine ["+sm+"] has ["+transitionsNumber+"] outgoing transitions.");
    }


    public void incomingTransitionToInitState(StateMachine sm, Transition transition) {
        out.println(sm+"> Init state [" + transition.getTargetState()+ "] of state machine ["+sm+"] has incoming transition ["+transition+"].");
    }


    public void outgoingTransitionFromFinalState(StateMachine sm, Transition transition) {
        out.println(sm+"> Final state [" + transition.getSourceState()+ "] of state machine ["+sm+"] has outgoing transition ["+transition+"].");
    }


    public void noEventOnTransition(StateMachine sm, Transition transition) {
        out.println(sm+"> Transition [" + transition+ "]  from non-init state of state machine ["+sm+"] has no event.");
    }
}
