/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;

/**
 * Listenes to structure errors. Handles attainable composite states
 * that have no initial substate.
 *
 * @author Maxim Mazin
 * @version Revision: 1
 */
public interface StructureListener {
    /**
     * CallBack. Is called when unattainable state is found.
     * @param state unattainable state.
     * @param sm <code>StateMachine</code> that contains <code>state</code>.
     */
    void unattainableState(StateMachine sm, State state);
    
    /**
     * Is called when composite attainable state without
     * initial state is found.
     * @param state composite state without initial state.
     * @param sm state machine that contains this state.
     */
    void noInitState(StateMachine sm, State state);

    /**
     * Is called when attainable composite state has more then one initial state.
     * @param state composite state that has more then one initial state
     * @param sm state machine that contains this state.
     * @param initStatesNumber
     */
    void redundantInitStates(StateMachine sm, State state, int initStatesNumber);

    /**
     * Called when not root state machine has associated event providers that is 
     * prohibited.
     * @param sm
     */
    void notRootStateMachineHasEventProviders(StateMachine sm);

    /**
     * Called when transition from init state has trigger event or
     * guard condition.  
     * @param sm
     */
    void badTransitionFromInitState(StateMachine sm, Transition transition);    
    
    /**
     * Called when there is no transition from 
     * init state. 
     */
    void noTransitionFromInitState(StateMachine sm, State initState);
    
    /**
     * Called when there is more then one transition from 
     * init state. 
     */
    void redundantTransitionsFromInitState(StateMachine sm, State initState, int transitionsNumber);

    /**
     * Called when there is incoming transition to init state. 
     */
    void incomingTransitionToInitState(StateMachine sm, Transition transition);

    /**
     * Called when there is outgoing transition from final state.
     */
    void outgoingTransitionFromFinalState(StateMachine sm, Transition transition);
    
    /**
     * Called when there is no event on transition from non-init state
     */
    void noEventOnTransition(StateMachine sm, Transition transition);
}