/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;

/**
 * Listener of inconsistent transition pairs.
 *
 * @author Maxim Mazin
 * @version Revision: 1
 */
public interface ConsistencyListener {

    /**
     * CallBack. This method is invoked when inconsistent transition pair
     * is found.
     * @param sm <code>StateMachine</code> that contains these transitions.
     * @param t1 first <code>Transition</code> in pair.
     * @param t2 second <code>Transition</code> in pair.
     * @param guard intersection of the guards on transitions <code>t1, t2</code>.
     * If guard on the <code>t1</code> xor <code>t2</code> are conjunced with
     * <code>guard</code> the guard conditions set will became consistent.
     */
    void inconsistentGuardSet(StateMachine sm, Transition t1, Transition t2, Guard guard);

    void redundantElseTransitions(StateMachine sm, State state, Event event, int elseTransitionsNumber);
}