/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.util;

import java.io.*;

/**
 * <p>
 * Object deep copy helper. Utilizes serialization approach.
 * </p>
 * <p>
 * Do not use in critical application parts due to low performance.
 * </p>
 */
public class DeepCopyHelper {

    /**
     * Transform given object into byte array.
     * 
     * @param o
     * @return
     * @throws IOException
     */
	public static byte[] toByteArray(Serializable o) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
		ObjectOutputStream oos = new ObjectOutputStream(baos);

		oos.writeObject(o);

		byte buf[] = baos.toByteArray();
		oos.close();

		return buf;
	}

	/**
	 * Deserialize object from given byte array
	 * @param buf
	 * @return
	 * @throws IOException
	 * @throws ClassNotFoundException
	 */
	public static Object fromByteArray(byte[] buf) throws IOException, ClassNotFoundException {
		ByteArrayInputStream bais = new ByteArrayInputStream(buf);
		ObjectInputStream ois = new ObjectInputStream(bais);

		Object o = ois.readObject();
		ois.close();

		return o;
	}

	/**
	 * Creates deep copy of given object. Newly creates object has no
	 * references to it's originator.
	 * 
	 * @param o
	 * @return
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public static Object deepCopy(Serializable o) throws ClassNotFoundException, IOException {
		return fromByteArray(toByteArray(o));
	}
}