/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.transform.xml;

/**
 * XML tags and attribnute names
 *
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public interface XML {
    public static final String DTD_RESOURCE =
            "com/evelopers/unimod/transform/xml/resources/statemachine.dtd";
    public static final String PUBLIC_ID =
            "-//eVelopers Corp.//DTD State machine model V1.0//EN";
    public static final String SYSTEM_ID =
            "http://www.evelopers.com/dtd/unimod/statemachine.dtd";

    public interface Tag {

        public static final String MODEL = "model";

        public static final String CONTROLLED_OBJECT = "controlledObject";

        public static final String ROOT_STATE_MACHINE = "rootStateMachine";

        public static final String STATE_MACHINE_REF = "stateMachineRef";

        public static final String STATE_MACHINE = "stateMachine";

        public static final String CONFIG_STORE = "configStore";
        
        public static final String EVENT_PROVIDER = "eventProvider";        

        public static final String ASSOCIATION = "association";

        public static final String STATE = "state";

        public static final String OUTPUT_ACTION = "outputAction";

        public static final String TRANSITION = "transition";

    }

    public interface Attribute {

        public static final String NAME = "name";

        public static final String CLASS = "class";

        public static final String TARGET_REF = "targetRef";

        public static final String SUPPLIER_ROLE = "supplierRole";

        public static final String CLIENT_ROLE = "clientRole";
        
        public static final String TYPE = "type";

        public static final String IDENT = "ident";

        public static final String SOURCE_REF = "sourceRef";

        public static final String EVENT = "event";

        public static final String GUARD = "guard";
    }

    public interface Path {

        public static final String MODEL = Tag.MODEL;

        public static final String CONTROLLED_OBJECT = Path.MODEL + "/" + Tag.CONTROLLED_OBJECT;

        public static final String EVENT_PROVIDER = Path.MODEL + "/" + Tag.EVENT_PROVIDER;

        public static final String EVENT_PROVIDER_ASSOCIATION = Path.EVENT_PROVIDER + "/" + Tag.ASSOCIATION;
        
        public static final String ROOT_STATE_MACHINE = Path.MODEL + "/" + Tag.ROOT_STATE_MACHINE + "/" + Tag.STATE_MACHINE_REF;

        public static final String STATE_MACHINE = Path.MODEL + "/" + Tag.STATE_MACHINE;

        public static final String CONFIG_STORE = Path.STATE_MACHINE + "/" + Tag.CONFIG_STORE;

        public static final String STATE_MACHINE_ASSOCIATION = Path.STATE_MACHINE + "/" + Tag.ASSOCIATION;

        public static final String TOP_STATE = Path.STATE_MACHINE + "/" + Tag.STATE;

        public static final String SUB_STATE = "*/" + Tag.STATE + "/" + Tag.STATE;

        public static final String SUBMACHINE = "*/" + Tag.STATE + "/" + Tag.STATE_MACHINE_REF;

        public static final String OUTPUT_ACTION = "*/" + Tag.TRANSITION + "/" + Tag.OUTPUT_ACTION;

        public static final String ON_ENTER_ACTION = "*/" + Tag.STATE + "/" + Tag.OUTPUT_ACTION;

        public static final String TRANSITION = Path.STATE_MACHINE + "/" + Tag.TRANSITION;

    }
}
