/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime.interpretation;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.runtime.AbstractEventProcessor;
import com.evelopers.unimod.runtime.ControlledObjectsMap;
import com.evelopers.unimod.runtime.EventManager;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.QueuedHandler;
import com.evelopers.unimod.runtime.StrictHandler;

/**
 * Enrty point for runtime model engine based on interpretation.
 *
 * @author Maxim Mazin
 */
public class InterpretationHelper {
    private static InterpretationHelper instance;

    public static InterpretationHelper getInstance() {
        if (instance == null) {
            instance = new InterpretationHelper();
        }
        return instance;
    }

    public AbstractEventProcessor createEventProcessor(Model model) {
        return new InterpretationEventProcessor(model);
    }

    public InterpretationObjectsManager createObjectsManager(Model model) {
        return new InterpretationObjectsManager(model);
    }

    public ModelEngine createBuildInModelEngine(Model model, ControlledObjectsMap controlledObjectsMap, boolean useEventQueue) throws CommonException {
        EventManager eventManager;
        if (useEventQueue) {
            eventManager = new QueuedHandler();
        } else {
            eventManager = new StrictHandler();
        }
        AbstractEventProcessor eventProcessor = createEventProcessor(model);
        return ModelEngine.createBuildIn(eventManager, eventProcessor, controlledObjectsMap);
    }

    public ModelEngine createStandAloneModelEngine(Model model, boolean useEventQueue) throws CommonException {
        EventManager eventManager;
        if (useEventQueue) {
            eventManager = new QueuedHandler();
        } else {
            eventManager = new StrictHandler();
        }
        AbstractEventProcessor eventProcessor = createEventProcessor(model);
        InterpretationObjectsManager objectsManager = createObjectsManager(model);
        return ModelEngine.createStandAlone(eventManager, eventProcessor,
                objectsManager.getControlledObjectsManager(),
                objectsManager.getEventProvidersManager());
    }
}