// $ANTLR : "GuardInterpreter.g" -> "GuardInterpreter.java"$

/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime.interpretation;


import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.parser.ConstNode;
import com.evelopers.unimod.parser.IdentNode;
import com.evelopers.unimod.parser.InterpreterException;
import com.evelopers.unimod.runtime.context.StateMachineContext;


/**
 * AST Tree Interpreter
 */
public class GuardInterpreter extends antlr.TreeParser       implements GuardInterpreterTokenTypes
 {

	private CalculatedInputActions inputActions;
	private StateMachineContext context;

	/**
	  * Interpret expression of given guard.
	  * Returns "true" if given Guard is {@link com.evelopers.unimod.core.stateworks.Guard#ELSE}.
	  */
	public static boolean interpret(Guard c, StateMachineContext context,
	                                CalculatedInputActions inputActions)
	                                throws InterpreterException {
		if (c.equals(Guard.ELSE)) {
			return true;
		}

		return interpret(c.getAST(), context, inputActions);
	}
	
	/**
	  * Interpret expression of given guard.
	  * Returns "true" if given Guard is {@link com.evelopers.unimod.core.stateworks.Guard#ELSE}.
	  * TODO: make pool of interpreters
	  */
	public static boolean interpret(AST ast, StateMachineContext context,
	                                CalculatedInputActions inputActions)
	                                throws InterpreterException {
		try {
			GuardInterpreter i = new GuardInterpreter();
			i.setInputActions(inputActions);
			i.setContext(context);
			return i.s(ast);
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}
	
	private void setInputActions(CalculatedInputActions inputActions) {
	    this.inputActions = inputActions;
	}

	private void setContext(StateMachineContext context) {
	    this.context = context;
	}
public GuardInterpreter() {
	tokenNames = _tokenNames;
}

	public final boolean  s(AST _t) throws RecognitionException, InterpreterException {
		boolean r;
		
		AST s_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
			boolean a, b;
		int i, j;
			r = false; 
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OR:
			{
				AST __t2 = _t;
				AST tmp1_AST_in = (AST)_t;
				match(_t,OR);
				_t = _t.getFirstChild();
				a=s(_t);
				_t = _retTree;
				b=s(_t);
				_t = _retTree;
				_t = __t2;
				_t = _t.getNextSibling();
				r = a || b;
				break;
			}
			case AND:
			{
				AST __t3 = _t;
				AST tmp2_AST_in = (AST)_t;
				match(_t,AND);
				_t = _t.getFirstChild();
				a=s(_t);
				_t = _retTree;
				b=s(_t);
				_t = _retTree;
				_t = __t3;
				_t = _t.getNextSibling();
				r = a && b;
				break;
			}
			case NOT:
			{
				AST __t4 = _t;
				AST tmp3_AST_in = (AST)_t;
				match(_t,NOT);
				_t = _t.getFirstChild();
				a=s(_t);
				_t = _retTree;
				_t = __t4;
				_t = _t.getNextSibling();
				r = !a;
				break;
			}
			case EQUAL:
			{
				AST __t5 = _t;
				AST tmp4_AST_in = (AST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				i=i5(_t);
				_t = _retTree;
				j=i5(_t);
				_t = _retTree;
				_t = __t5;
				_t = _t.getNextSibling();
				r = i == j;
				break;
			}
			case NEQUAL:
			{
				AST __t6 = _t;
				AST tmp5_AST_in = (AST)_t;
				match(_t,NEQUAL);
				_t = _t.getFirstChild();
				i=i5(_t);
				_t = _retTree;
				j=i5(_t);
				_t = _retTree;
				_t = __t6;
				_t = _t.getNextSibling();
				r = i != j;
				break;
			}
			case GE:
			{
				AST __t7 = _t;
				AST tmp6_AST_in = (AST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				i=i5(_t);
				_t = _retTree;
				j=i5(_t);
				_t = _retTree;
				_t = __t7;
				_t = _t.getNextSibling();
				r = i >= j;
				break;
			}
			case GT:
			{
				AST __t8 = _t;
				AST tmp7_AST_in = (AST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				i=i5(_t);
				_t = _retTree;
				j=i5(_t);
				_t = _retTree;
				_t = __t8;
				_t = _t.getNextSibling();
				r = i >  j;
				break;
			}
			case LE:
			{
				AST __t9 = _t;
				AST tmp8_AST_in = (AST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				i=i5(_t);
				_t = _retTree;
				j=i5(_t);
				_t = _retTree;
				_t = __t9;
				_t = _t.getNextSibling();
				r = i <= j;
				break;
			}
			case LT:
			{
				AST __t10 = _t;
				AST tmp9_AST_in = (AST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				i=i5(_t);
				_t = _retTree;
				j=i5(_t);
				_t = _retTree;
				_t = __t10;
				_t = _t.getNextSibling();
				r = i <  j;
				break;
			}
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				r = inputActions.getBool(((IdentNode)id).getAction(), context);
				break;
			}
			case TRUE:
			{
				AST tmp10_AST_in = (AST)_t;
				match(_t,TRUE);
				_t = _t.getNextSibling();
				r = true;
				break;
			}
			case FALSE:
			{
				AST tmp11_AST_in = (AST)_t;
				match(_t,FALSE);
				_t = _t.getNextSibling();
				r = false;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return r;
	}
	
	public final int  i5(AST _t) throws RecognitionException, InterpreterException {
		int r;
		
		AST i5_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST c = null;
		
			r = 0;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				r = inputActions.getNum(((IdentNode)id).getAction(), context);
				break;
			}
			case CONST_NUM:
			{
				c = (AST)_t;
				match(_t,CONST_NUM);
				_t = _t.getNextSibling();
				r = ((ConstNode)c).getValue();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return r;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"TRUE",
		"FALSE",
		"OR",
		"AND",
		"NOT",
		"LPAREN",
		"RPAREN",
		"EQUAL",
		"NEQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"IDENT",
		"CONST_BOOL",
		"CONST_NUM",
		"WS",
		"DIGIT",
		"LETTER",
		"NAME",
		"CONST_BOOL_OR_IDENT"
	};
	
	}
	
