/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime.interpretation;

import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.parser.InterpreterException;
import com.evelopers.unimod.runtime.context.StateMachineContext;

import java.util.HashMap;
import java.util.Map;

/**
 * Map of {@link com.evelopers.unimod.core.stateworks.Action} that was already calculated
 * during expression interpreting. It allows to calculate Actions' values only once during
 * event processing.
 * 
 * @author vgurov
 */
abstract class CalculatedInputActions {
	private Map results = new HashMap();
    private ActionExecutor actionExecutor;

    public CalculatedInputActions(ActionExecutor actionExecutor) {
        this.actionExecutor = actionExecutor;
    }

	public int getNum(Action action, StateMachineContext context) throws InterpreterException {
		Integer result;
		
		if (results.get(action) == null) {

            fireBefore(context, action);
            result = new Integer(actionExecutor.executeNum(action, context));
            fireAfter(context, action, result);

            results.put(action, result);
		} else {
			result = (Integer) results.get(action);
		}
		
		return result.intValue();
	}

    public boolean getBool(Action action, StateMachineContext context) throws InterpreterException {
		Boolean result;
		
		if (results.get(action) == null) {
            fireBefore(context, action);
			result = new Boolean(actionExecutor.executeBool(action, context));
            fireAfter(context, action, result);

			results.put(action, result);
		} else {
			result = (Boolean) results.get(action);
		}
		
		return result.booleanValue();
	}

    /**
     * Does nothing may be overriden to send notification
     *
     * @param action
     */
    protected abstract void fireBefore(StateMachineContext context, Action action);

    /**
     * Does nothing may be overriden to send notification
     *
     * @param action
     * @param result
     */
    protected abstract void fireAfter(StateMachineContext context, Action action, Object result);
    
}
