/*
 * Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.runtime.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * Simple state machine context implementation.
 * 
 * Stores Application and User contexts as global contexts,
 * creates new Event context for every call to {@link #create} method.  
 */
public class StateMachineContextImpl implements StateMachineContext, Serializable {

	private static Context APP_CONTEXT = new ContextImpl();
	private static Context USER_CONTEXT = new ContextImpl();

	public static StateMachineContext create() {
		return new StateMachineContextImpl(APP_CONTEXT, USER_CONTEXT, new ContextImpl());
	}
	
	private Context appContext;
	private Context userContext;
	private Context eventContext;
	
	public StateMachineContextImpl(Context app, Context user, Context event) {
		this.appContext = app;
		this.userContext = user;
		this.eventContext = event;		
	}

	public Context getApplicationContext() {
		return appContext;
	}
  
	public Context getUserContext() {
		return userContext;
	}

	public Context getEventContext() {
		return eventContext;
	}

	public static class ContextImpl implements Context, Serializable {
  	
		private Map m = new HashMap(); 
  	
		public void setParameter(String name, Object data) {
			m.put(name, data);
		}
    
		public Object getParameter(String name) {
			return m.get(name);
		}
    
		public Object[] getParameterValues(String name) {
			return null;
		}
    
		public Enumeration getParameterNames() {
		    return Collections.enumeration(m.keySet());			
		}
	}
	
}