package com.evelopers.unimod.runtime.context;

import java.util.Enumeration;

/**
 * <p>
 * State Machine Context - bridge to environment. 
 * <p>
 * </p>
 * Consist of three contexts:
 * <li> Application Context - global context, lives as long as entire application lives;
 * <li> User Context - associated with user session, lives as long as user works with application;
 * <li> Event Context - it's life starts with start moment of event processing and ends with
 * execution of last action during event processing.
 * </p> 
 */
public interface StateMachineContext {

 /**
  * Desribes methods that any context must implement. 
  */
  public interface Context {
  	
  	/**
  	 * Assigns given data to given parameter name
  	 * 
  	 * @param name parameter name
  	 * @param data parameter value
  	 */
    public void setParameter(String name, Object data);
    
    /**
     * Returns value of parameter
     * 
     * @param name parameter name
     * @return parameter value
     */
    public Object getParameter(String name);
    
    /**
     * Returns all values of parameter with given name
     *  
     * @param name parameter name
     * @return values array 
     */
    public Object[] getParameterValues(String name);
    
    /**
     * Returns all parameters names in context
     * 
     * @return all parameters names
     */
    public Enumeration getParameterNames();
  }

  /**
   * Must return application context
   * 
   * @return application context
   */
  public Context getApplicationContext();
  
  /**
   * Must return user context
   * 
   * @return user context
   */
  public Context getUserContext();

  /**
   * Must return event context
   * 
   * @return event context
   */
  public Context getEventContext();

}
