/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime.context;

import java.io.Serializable;


/**
 * Represents Event parameter. In spite of the fact it's placed in statical core
 * package, actually it is being used only during runtime.
 * 
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public class Parameter implements Serializable {

    private String name;
    private Object value;

    /**
     * Creates parameter with given name and value.
     * 
     * @param name parameter name
     * @param value parameter value
     */
    public Parameter(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Method <code>addToContext</code> adds parameter to given context.
     * Usually, target context is EventContext.
     * 
     * @param context context to add parameter to
     */
    public void addToContext(StateMachineContext.Context context) {
        context.setParameter(name, value);
    }
    
    public String getName() {
        return name;
    }
    
    public Object getValue() {
        return value;
    }
}
