/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime;

/**
 * Provides information about automata model.
 *
 * @author Maxim Mazin
 */
public interface ModelStructure {
    /**
     * Returns path to the root state machine.
     * @return path to the root state machine
     */
    StateMachinePath getRootPath() throws EventProcessorException;

    /**
     * Returns {@link StateMachineConfigManager config manager} for state
     * machine with given name.
     *
     * @param stateMachine state machine String representation gotten with a help of {@link com.evelopers.unimod.contract.CoreContract#encode(StateMachine)}
     * @return {@link StateMachineConfigManager config manager} for state machine 
     */
    StateMachineConfigManager getConfigManager(String stateMachine) throws EventProcessorException;

    /**
     * Initial config factory method.
     *
     * @param stateMachine state machine String representation gotten with a help of {@link com.evelopers.unimod.contract.CoreContract#encode(StateMachine)}
     * @return config with active initial state of state machine
     */
    StateMachineConfig getTopConfig(String stateMachine) throws EventProcessorException;

    /**
     * Determines whether active state defined by the given
     * config is final for state machine with the given name
     * @param stateMachine state machine String representation gotten with a help of {@link com.evelopers.unimod.contract.CoreContract#encode(StateMachine)}
     * @param config state machine config to test
     * @return <code>true</code> iff given config is final for the given state machine
     */
    boolean isFinal(String stateMachine, StateMachineConfig config) throws EventProcessorException;
}
