/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime;

import com.evelopers.common.exception.CommonException;

/**
 * Event Provider. Instances of this class will be notified by
 * {@link EventProvidersManager} on startup and on dispose.
 * Instances responsible for providing event to {@link ModelEngine#handle}
 * and preparation of {@link com.evelopers.unimod.runtime.context.StateMachineContext}.
 *
 * @author Vadim Gurov
 */
public interface EventProvider {
    
    /**
     * Called on engine start-up
     * 
     * @param engine that will be notified about events.
     */
    public void init(ModelEngine engine) throws CommonException;
    
    /**
     * Called on sthutdown. If some threads was started by event
     * provider they must be stopped here.
     */
    public void dispose();

    /** @link dependency 
     * @label throws events*/
    /*# ModelEngine lnkEventHandler; */

    /** @link dependency 
     * @label prepares*/
    /*# com.evelopers.unimod.runtime.context.StateMachineContext lnkStateMachineContext; */
}
