/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime;

import com.evelopers.unimod.core.stateworks.*;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * The implemetors of this interface manages events sent to
 * {@link ModelEngine}. Model engine delegetes event handling
 * to implementor of this interface passed to its factory method.
 *
 * @author Vadim Gurov
 * @author Maxim Mazin
 * @version $Revision: 1$
 */
public interface EventManager extends LifeCycleManager {

    /**
	 * Calls of event providers or model engine client to
     * {@link ModelEngine#handle} will be delegated to
	 * this method.
     * If event manager uses dispatch queue, returns immediately 
     * 
     * @param event
     * @param context
     */
    public void handle(Event event, StateMachineContext context);
    
    /**
	 * Calls of event providers or model engine client to
     * {@link ModelEngine#handle} will be delegated to
	 * this method.
     * If event manager uses dispatch queue, waits for end of event processing
     *  
     * @param event
     * @param context
     */
    public void handleAndWait(Event event, StateMachineContext context);

    
    /** @link dependency
     * @label gets reference to*/
    /*# StateMachineContext lnkStateMachineContext; */
}
