/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */

package com.evelopers.unimod.runtime;

/**
 * Collection of controlled objects
 *
 * @author Maxim Mazin
 */
public interface ControlledObjectsMap {
    /**
     * @directed
     * @supplierCardinality **/
    /*# ControlledObject objects[]; */

    /**
     * Returns controlled object by its name.
     * @param coName name of controlled object
     * @return controlled object with name <code>coName</code>
     */
    ControlledObject getControlledObject(String coName);
}
