/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;

import java.text.MessageFormat;


/**
 * Thrown by {@link ExprParser} when expression references to
 * object that isn't controlled by state machine.
 *
 * @author Maxim Mazin
 * @version Revision: 1
 */
public class UndefinedControlledObjectHandlerException extends ParserException {
    private static final MessageFormat MESSAGE = new MessageFormat("Can''t find controlled object with name {0}");
    private String controlledObjectName;

    public UndefinedControlledObjectHandlerException(String controlledObjectName, int position) {
        super(MESSAGE.format(new Object[] {controlledObjectName}), position);
        this.controlledObjectName = controlledObjectName;
    }

    public String getControlledObjectHandlerName() {
        return controlledObjectName;
    }
}