// $ANTLR : "infix.g" -> "Infix.java"$

/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;


import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


public class Infix extends antlr.TreeParser       implements InfixTokenTypes
 {

	public static String infix(AST ast) throws InterpreterException {
		try {
			Infix i = new Infix();
		
			return i.formula(ast);
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}
public Infix() {
	tokenNames = _tokenNames;
}

	public final String  formula(AST _t) throws RecognitionException {
		String str;
		
		AST formula_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		str = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OR:
			{
				str=dis(_t);
				_t = _retTree;
				break;
			}
			case TRUE:
			case FALSE:
			case AND:
			case NOT:
			case EQUAL:
			case NEQUAL:
			case GE:
			case GT:
			case LE:
			case LT:
			case IDENT:
			case CONST_NUM:
			{
				str=term(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	public final String  dis(AST _t) throws RecognitionException {
		String str;
		
		AST dis_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		str = "";
		String a;
		
		
		try {      // for error handling
			AST __t145 = _t;
			AST tmp1_AST_in = (AST)_t;
			match(_t,OR);
			_t = _t.getFirstChild();
			{
			int _cnt147=0;
			_loop147:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					a=formula(_t);
					_t = _retTree;
					str += (str.length() > 0 ? " || " : "") + a;
				}
				else {
					if ( _cnt147>=1 ) { break _loop147; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt147++;
			} while (true);
			}
			_t = __t145;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	public final String  term(AST _t) throws RecognitionException {
		String str;
		
		AST term_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		str = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case AND:
			{
				str=con(_t);
				_t = _retTree;
				break;
			}
			case TRUE:
			case FALSE:
			case NOT:
			case EQUAL:
			case NEQUAL:
			case GE:
			case GT:
			case LE:
			case LT:
			case IDENT:
			case CONST_NUM:
			{
				str=lit(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	public final String  con(AST _t) throws RecognitionException {
		String str;
		
		AST con_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		str = "";
		String a;
		
		
		try {      // for error handling
			AST __t149 = _t;
			AST tmp2_AST_in = (AST)_t;
			match(_t,AND);
			_t = _t.getFirstChild();
			{
			int _cnt153=0;
			_loop153:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case OR:
				{
					{
					a=dis(_t);
					_t = _retTree;
					str += (str.length() > 0 ? " && (" : "(") + a + ")";
					}
					break;
				}
				case TRUE:
				case FALSE:
				case AND:
				case NOT:
				case EQUAL:
				case NEQUAL:
				case GE:
				case GT:
				case LE:
				case LT:
				case IDENT:
				case CONST_NUM:
				{
					{
					a=term(_t);
					_t = _retTree;
					str += (str.length() > 0 ? " && "  : "" ) + a;
					}
					break;
				}
				default:
				{
					if ( _cnt153>=1 ) { break _loop153; } else {throw new NoViableAltException(_t);}
				}
				}
				_cnt153++;
			} while (true);
			}
			_t = __t149;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	public final String  lit(AST _t) throws RecognitionException {
		String str;
		
		AST lit_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		str = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case NOT:
			{
				str=neg(_t);
				_t = _retTree;
				break;
			}
			case EQUAL:
			case NEQUAL:
			case GE:
			case GT:
			case LE:
			case LT:
			{
				str=cmp(_t);
				_t = _retTree;
				break;
			}
			case TRUE:
			case FALSE:
			case IDENT:
			case CONST_NUM:
			{
				str=val(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	public final String  neg(AST _t) throws RecognitionException {
		String str;
		
		AST neg_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		str = "";
		String a;
		
		
		try {      // for error handling
			AST __t155 = _t;
			AST tmp3_AST_in = (AST)_t;
			match(_t,NOT);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OR:
			{
				{
				a=dis(_t);
				_t = _retTree;
				str = "!(" + a + ")";
				}
				break;
			}
			case AND:
			{
				{
				a=con(_t);
				_t = _retTree;
				str = "!(" + a + ")";
				}
				break;
			}
			case TRUE:
			case FALSE:
			case NOT:
			case EQUAL:
			case NEQUAL:
			case GE:
			case GT:
			case LE:
			case LT:
			case IDENT:
			case CONST_NUM:
			{
				{
				a=lit(_t);
				_t = _retTree;
				str = "!" + a;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t155;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	public final String  cmp(AST _t) throws RecognitionException {
		String str;
		
		AST cmp_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		str = "";
		String a, b;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EQUAL:
			{
				AST __t161 = _t;
				AST tmp4_AST_in = (AST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				a=val(_t);
				_t = _retTree;
				b=val(_t);
				_t = _retTree;
				_t = __t161;
				_t = _t.getNextSibling();
				str = a + " == " + b;
				break;
			}
			case NEQUAL:
			{
				AST __t162 = _t;
				AST tmp5_AST_in = (AST)_t;
				match(_t,NEQUAL);
				_t = _t.getFirstChild();
				a=val(_t);
				_t = _retTree;
				b=val(_t);
				_t = _retTree;
				_t = __t162;
				_t = _t.getNextSibling();
				str = a + " != " + b;
				break;
			}
			case GE:
			{
				AST __t163 = _t;
				AST tmp6_AST_in = (AST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				a=val(_t);
				_t = _retTree;
				b=val(_t);
				_t = _retTree;
				_t = __t163;
				_t = _t.getNextSibling();
				str = a + " >= " + b;
				break;
			}
			case GT:
			{
				AST __t164 = _t;
				AST tmp7_AST_in = (AST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				a=val(_t);
				_t = _retTree;
				b=val(_t);
				_t = _retTree;
				_t = __t164;
				_t = _t.getNextSibling();
				str = a + " > "  + b;
				break;
			}
			case LE:
			{
				AST __t165 = _t;
				AST tmp8_AST_in = (AST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				a=val(_t);
				_t = _retTree;
				b=val(_t);
				_t = _retTree;
				_t = __t165;
				_t = _t.getNextSibling();
				str = a + " <= " + b;
				break;
			}
			case LT:
			{
				AST __t166 = _t;
				AST tmp9_AST_in = (AST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				a=val(_t);
				_t = _retTree;
				b=val(_t);
				_t = _retTree;
				_t = __t166;
				_t = _t.getNextSibling();
				str = a + " < "  + b;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	public final String  val(AST _t) throws RecognitionException {
		String str;
		
		AST val_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		AST c = null;
		
		str = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				i = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				str = i.getText();
				break;
			}
			case CONST_NUM:
			{
				c = (AST)_t;
				match(_t,CONST_NUM);
				_t = _t.getNextSibling();
				str = c.getText();
				break;
			}
			case TRUE:
			{
				AST tmp10_AST_in = (AST)_t;
				match(_t,TRUE);
				_t = _t.getNextSibling();
				str = "true";
				break;
			}
			case FALSE:
			{
				AST tmp11_AST_in = (AST)_t;
				match(_t,FALSE);
				_t = _t.getNextSibling();
				str = "false";
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return str;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"TRUE",
		"FALSE",
		"OR",
		"AND",
		"NOT",
		"LPAREN",
		"RPAREN",
		"EQUAL",
		"NEQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"IDENT",
		"CONST_BOOL",
		"CONST_NUM",
		"WS",
		"DIGIT",
		"LETTER",
		"NAME",
		"CONST_BOOL_OR_IDENT"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 784880L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	}
	
