/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;

import com.evelopers.unimod.compilation.StateMachineCompiler;
import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.StateMachine;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;

/**
 * AST node for identifier. Handles Action object inside for
 * futher interpreting.
 * 
 * @author Vadim Gurov
 * @author Maxim Mazin:
 *  added default constructor
 *  overrided <code>initialize(AST)<code> to copy action
 *  so <code>IdentNode</code> may be duplicated by <code>astFactory.dup(AST)</code>
 * @version $Revision: 1$
 */
public class IdentNode extends CommonAST {
    
    /**
     * @clientCardinality 0..*
     * @supplierCardinality 1 
     */
	private Action action;
	private Class returnType;

    /**
     * Does nothing. Used for duplicating.
     */
    public IdentNode() {
    }

	/**
	 * Creates node for given token
	 *  
	 * @param t token
	 */
	public IdentNode(Token t) {
	  super(t);	
	}

	/**
	 * Returns Action. Called by Interpreter.
	 * 
	 * @return Action
	 */
	public Action getAction() {
	  return action;
	}
	
	/**
	 * Sets Action. Called by Parser.
	 * 
	 * @param e Action
	 */	
	public void setAction(Action e) {
		this.action = e;
	}
	
	public Class getReturnType() {
	    return returnType;
	}
	
	public boolean equals(Object o) {
	    if (!(o instanceof IdentNode)) {
	        return false;
	    }
	    
	    return action.equals(((IdentNode)o).action);
	}
	
	public int hashCode() {
	    return action.hashCode();
	}
	
	/**
	 * Sets Action. Called by Parser.
	 * 
	 * @param e Action
	 */	
	public void setAction(StateMachine sm, Action e, Class returnType) {
		this.action = e;
		this.returnType = returnType;
		/*@TODO: change to StateMachineCompiler.compile(e) */
		e.setObject(sm.getControlledObjectHandler(StateMachineCompiler.getObjectName(e.getIdentifier())));
		e.setActionName(StateMachineCompiler.getActionName(e.getIdentifier()));
	}

    public void initialize(AST t) {
        super.initialize(t);
        if (t instanceof IdentNode) {
            setAction(((IdentNode) t).getAction());
        }
    }
}
