// $ANTLR : "expr.g" -> "ExprParser.java"$

/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

import java.io.*;
import java.util.*;
import com.evelopers.unimod.core.stateworks.*;
import com.evelopers.unimod.compilation.*;
import antlr.*;
import com.evelopers.unimod.compilation.OperationResolver;

/**
 * Logic Expression Parser for Guard {@link com.evelopers.unimod.core.stateworks.Guard}
 * 
 */
public class ExprParser extends antlr.LLkParser       implements ExprTokenTypes
 {

	private StateMachine sm = null;
	private OperationResolver operationResolver = null;

    static {
        try {
            ExprParser.class.forName("com.evelopers.unimod.parser.IdentNode");
            ExprParser.class.forName("com.evelopers.unimod.parser.ConstNode");
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

	public void setStateMachine(StateMachine sm) {
		this.sm = sm;
	}
	
	public void setOperationResolver(OperationResolver operationResolver) {
		this.operationResolver = operationResolver;
	}

	public static AST parse(String expr, StateMachine sm, OperationResolver operationResolver) throws ParserException {
		try {
			ExprParser p = new ExprParser(new ExprLexer(new StringReader(expr)));
			p.setStateMachine(sm);
			p.setOperationResolver(operationResolver);
			p.s();
			return p.getAST();
		} catch (RecognitionException e) {
			throw new ParserException(e.getMessage(), e.getColumn());
		} catch (TokenStreamRecognitionException e) {
			throw new ParserException(e.getMessage(), e.recog.getColumn());
		} catch (TokenStreamException e) {
			throw new ParserException(e);
		}
 	} 
 	
 	private void assertCOExists(Token i) throws ParserException {
 		if (sm.getControlledObjectHandler(StateMachineCompiler.getObjectName(i.getText())) == null) {
 		    throw new UndefinedControlledObjectHandlerException(StateMachineCompiler.getObjectName(i.getText()), i.getColumn());
 		};
 	}
 	
	private void assertReturnType(Token i, Class returnType) throws ParserException {
		if (operationResolver == null) {
			return;
		}
		String ident = i.getText();
		int position = i.getColumn();
        ControlledObjectHandler co = sm.getControlledObjectHandler(StateMachineCompiler.getObjectName(ident));
        // if co is null - assertCOExists will rise exception that will be enougth
        if (co == null) {
        	return;
        }
        
        String actionName = StateMachineCompiler.getActionName(ident);
        Class type = operationResolver.getOperationType(co, actionName);
        if (type == null) {
            throw new UndefinedActionException(co, actionName, position);
        }
        if (! returnType.isAssignableFrom(type)) {
            throw new ActionTypeMismatchException(co, actionName, returnType, type, position);
        }
	}
 	

protected ExprParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public ExprParser(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected ExprParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public ExprParser(TokenStream lexer) {
  this(lexer,2);
}

public ExprParser(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void s() throws RecognitionException, TokenStreamException, ParserException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST s_AST = null;
		
		s1();
		astFactory.addASTChild(currentAST, returnAST);
		match(Token.EOF_TYPE);
		s_AST = (AST)currentAST.root;
		returnAST = s_AST;
	}
	
	public final void s1() throws RecognitionException, TokenStreamException, ParserException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST s1_AST = null;
		
		i1();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop171:
		do {
			if ((LA(1)==OR)) {
				AST tmp2_AST = null;
				tmp2_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp2_AST);
				match(OR);
				i1();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop171;
			}
			
		} while (true);
		}
		s1_AST = (AST)currentAST.root;
		returnAST = s1_AST;
	}
	
	public final void i1() throws RecognitionException, TokenStreamException, ParserException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST i1_AST = null;
		
		i2();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop174:
		do {
			if ((LA(1)==AND)) {
				AST tmp3_AST = null;
				tmp3_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp3_AST);
				match(AND);
				i2();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop174;
			}
			
		} while (true);
		}
		i1_AST = (AST)currentAST.root;
		returnAST = i1_AST;
	}
	
	public final void i2() throws RecognitionException, TokenStreamException, ParserException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST i2_AST = null;
		
		boolean synPredMatched177 = false;
		if (((LA(1)==NOT) && (LA(2)==NOT))) {
			int _m177 = mark();
			synPredMatched177 = true;
			inputState.guessing++;
			try {
				{
				match(NOT);
				match(NOT);
				}
			}
			catch (RecognitionException pe) {
				synPredMatched177 = false;
			}
			rewind(_m177);
inputState.guessing--;
		}
		if ( synPredMatched177 ) {
			match(NOT);
			match(NOT);
			i2();
			astFactory.addASTChild(currentAST, returnAST);
			i2_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==NOT) && (_tokenSet_0.member(LA(2)))) {
			AST tmp6_AST = null;
			tmp6_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp6_AST);
			match(NOT);
			i3();
			astFactory.addASTChild(currentAST, returnAST);
			i2_AST = (AST)currentAST.root;
		}
		else if ((_tokenSet_0.member(LA(1)))) {
			i3();
			astFactory.addASTChild(currentAST, returnAST);
			i2_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = i2_AST;
	}
	
	public final void i3() throws RecognitionException, TokenStreamException, ParserException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST i3_AST = null;
		
		switch ( LA(1)) {
		case LPAREN:
		{
			match(LPAREN);
			s1();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			i3_AST = (AST)currentAST.root;
			break;
		}
		case IDENT:
		case CONST_BOOL:
		case CONST_NUM:
		{
			i4();
			astFactory.addASTChild(currentAST, returnAST);
			i3_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = i3_AST;
	}
	
	public final void i4() throws RecognitionException, TokenStreamException, ParserException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST i4_AST = null;
		Token  i = null;
		com.evelopers.unimod.parser.IdentNode i_AST = null;
		Token  c = null;
		AST c_AST = null;
		
		if ((LA(1)==IDENT||LA(1)==CONST_NUM) && ((LA(2) >= EQUAL && LA(2) <= LT))) {
			i5();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case EQUAL:
			{
				AST tmp9_AST = null;
				tmp9_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp9_AST);
				match(EQUAL);
				break;
			}
			case NEQUAL:
			{
				AST tmp10_AST = null;
				tmp10_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp10_AST);
				match(NEQUAL);
				break;
			}
			case GE:
			{
				AST tmp11_AST = null;
				tmp11_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp11_AST);
				match(GE);
				break;
			}
			case GT:
			{
				AST tmp12_AST = null;
				tmp12_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp12_AST);
				match(GT);
				break;
			}
			case LE:
			{
				AST tmp13_AST = null;
				tmp13_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp13_AST);
				match(LE);
				break;
			}
			case LT:
			{
				AST tmp14_AST = null;
				tmp14_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp14_AST);
				match(LT);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			i5();
			astFactory.addASTChild(currentAST, returnAST);
			i4_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==IDENT) && (_tokenSet_1.member(LA(2)))) {
			i = LT(1);
			i_AST = (com.evelopers.unimod.parser.IdentNode)astFactory.create(i,"com.evelopers.unimod.parser.IdentNode");
			astFactory.addASTChild(currentAST, i_AST);
			match(IDENT);
			if ( inputState.guessing==0 ) {
				assertCOExists(i);
				assertReturnType(i, Boolean.class);
				i_AST.setAction(sm, sm.createAction(i.getText()), Boolean.class);
			}
			i4_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==CONST_BOOL)) {
			c = LT(1);
			c_AST = astFactory.create(c);
			astFactory.addASTChild(currentAST, c_AST);
			match(CONST_BOOL);
			if ( inputState.guessing==0 ) {
				c_AST.setType("true".equalsIgnoreCase(c.getText()) ? TRUE : FALSE);
			}
			i4_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = i4_AST;
	}
	
	public final void i5() throws RecognitionException, TokenStreamException, ParserException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST i5_AST = null;
		Token  i = null;
		com.evelopers.unimod.parser.IdentNode i_AST = null;
		
		switch ( LA(1)) {
		case IDENT:
		{
			i = LT(1);
			i_AST = (com.evelopers.unimod.parser.IdentNode)astFactory.create(i,"com.evelopers.unimod.parser.IdentNode");
			astFactory.addASTChild(currentAST, i_AST);
			match(IDENT);
			if ( inputState.guessing==0 ) {
				assertCOExists(i);
				assertReturnType(i, Integer.class);
				i_AST.setAction(sm, sm.createAction(i.getText()), Integer.class);
			}
			i5_AST = (AST)currentAST.root;
			break;
		}
		case CONST_NUM:
		{
			com.evelopers.unimod.parser.ConstNode tmp15_AST = null;
			tmp15_AST = (com.evelopers.unimod.parser.ConstNode)astFactory.create(LT(1),"com.evelopers.unimod.parser.ConstNode");
			astFactory.addASTChild(currentAST, tmp15_AST);
			match(CONST_NUM);
			i5_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = i5_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"TRUE",
		"FALSE",
		"OR",
		"AND",
		"NOT",
		"LPAREN",
		"RPAREN",
		"EQUAL",
		"NEQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"IDENT",
		"CONST_BOOL",
		"CONST_NUM",
		"WS",
		"DIGIT",
		"LETTER",
		"NAME",
		"CONST_BOOL_OR_IDENT"
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 918016L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 1218L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	
	}
