/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;

import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;

import java.text.MessageFormat;

/**
 * Thrown by {@link ExprParser} when type of action mismatches its usage.
 *
 * @author Maxim Mazin
 * @version Revision: 1
 */
public class ActionTypeMismatchException extends ParserException {
    private static final MessageFormat MESSAGE = new MessageFormat("{0}.{1}: incompatible types. Found: {2}, required: {3}");

    private ControlledObjectHandler controlledObjectHandler;
    private String actionName;
    private Class expectedType;
    private Class foundType;

    public ActionTypeMismatchException(
            ControlledObjectHandler controlledObjectHandler, String actionName, Class expectedType, Class foundType, int position) {
        super(MESSAGE.format(new Object[]{controlledObjectHandler, actionName, foundType, expectedType}), position);
        this.controlledObjectHandler = controlledObjectHandler;
        this.actionName = actionName;
        this.expectedType = expectedType;
        this.foundType = foundType;
    }

    public ControlledObjectHandler getControlledObjectHandler() {
        return controlledObjectHandler;
    }

    public String getActionName() {
        return actionName;
    }

    public Class getExpectedType() {
        return expectedType;
    }

    public Class getFoundType() {
        return foundType;
    }
}