// $ANTLR : "ActionCollector.g" -> "ActionCollector.java"$

/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;


import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

import java.util.*;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.parser.ConstNode;
import com.evelopers.unimod.parser.IdentNode;
import com.evelopers.unimod.parser.InterpreterException;
import com.evelopers.unimod.runtime.context.StateMachineContext;


/**
 * AST Tree Action Collector
 */
public class ActionCollector extends antlr.TreeParser       implements ActionCollectorTokenTypes
 {

	private Set inputActions = new HashSet();

	/**
	* returns set of output actions found in given AST
	*/
	public static Set collect(AST ast) throws InterpreterException {
		try {
			ActionCollector i = new ActionCollector();
			i.s(ast);
			
			return i.inputActions;
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}

	/**
	* returns set of IdentNodes found in given AST
	*/
	public static Set collectIdentNodes(AST ast) throws InterpreterException {
		try {
			ActionCollector i = new ActionCollector();
			i.s_(ast);
			
			return i.inputActions;
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}
	
public ActionCollector() {
	tokenNames = _tokenNames;
}

	public final void s(AST _t) throws RecognitionException {
		
		AST s_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OR:
			{
				AST __t217 = _t;
				AST tmp1_AST_in = (AST)_t;
				match(_t,OR);
				_t = _t.getFirstChild();
				s(_t);
				_t = _retTree;
				s(_t);
				_t = _retTree;
				_t = __t217;
				_t = _t.getNextSibling();
				break;
			}
			case AND:
			{
				AST __t218 = _t;
				AST tmp2_AST_in = (AST)_t;
				match(_t,AND);
				_t = _t.getFirstChild();
				s(_t);
				_t = _retTree;
				s(_t);
				_t = _retTree;
				_t = __t218;
				_t = _t.getNextSibling();
				break;
			}
			case NOT:
			{
				AST __t219 = _t;
				AST tmp3_AST_in = (AST)_t;
				match(_t,NOT);
				_t = _t.getFirstChild();
				s(_t);
				_t = _retTree;
				_t = __t219;
				_t = _t.getNextSibling();
				break;
			}
			case EQUAL:
			{
				AST __t220 = _t;
				AST tmp4_AST_in = (AST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				i5(_t);
				_t = _retTree;
				i5(_t);
				_t = _retTree;
				_t = __t220;
				_t = _t.getNextSibling();
				break;
			}
			case NEQUAL:
			{
				AST __t221 = _t;
				AST tmp5_AST_in = (AST)_t;
				match(_t,NEQUAL);
				_t = _t.getFirstChild();
				i5(_t);
				_t = _retTree;
				i5(_t);
				_t = _retTree;
				_t = __t221;
				_t = _t.getNextSibling();
				break;
			}
			case GE:
			{
				AST __t222 = _t;
				AST tmp6_AST_in = (AST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				i5(_t);
				_t = _retTree;
				i5(_t);
				_t = _retTree;
				_t = __t222;
				_t = _t.getNextSibling();
				break;
			}
			case GT:
			{
				AST __t223 = _t;
				AST tmp7_AST_in = (AST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				i5(_t);
				_t = _retTree;
				i5(_t);
				_t = _retTree;
				_t = __t223;
				_t = _t.getNextSibling();
				break;
			}
			case LE:
			{
				AST __t224 = _t;
				AST tmp8_AST_in = (AST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				i5(_t);
				_t = _retTree;
				i5(_t);
				_t = _retTree;
				_t = __t224;
				_t = _t.getNextSibling();
				break;
			}
			case LT:
			{
				AST __t225 = _t;
				AST tmp9_AST_in = (AST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				i5(_t);
				_t = _retTree;
				i5(_t);
				_t = _retTree;
				_t = __t225;
				_t = _t.getNextSibling();
				break;
			}
			case TRUE:
			{
				AST tmp10_AST_in = (AST)_t;
				match(_t,TRUE);
				_t = _t.getNextSibling();
				break;
			}
			case FALSE:
			{
				AST tmp11_AST_in = (AST)_t;
				match(_t,FALSE);
				_t = _t.getNextSibling();
				break;
			}
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				inputActions.add(((IdentNode)id).getAction());
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void i5(AST _t) throws RecognitionException {
		
		AST i5_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CONST_NUM:
			{
				AST tmp12_AST_in = (AST)_t;
				match(_t,CONST_NUM);
				_t = _t.getNextSibling();
				break;
			}
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				inputActions.add(((IdentNode)id).getAction());
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void s_(AST _t) throws RecognitionException {
		
		AST s__AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OR:
			{
				AST __t228 = _t;
				AST tmp13_AST_in = (AST)_t;
				match(_t,OR);
				_t = _t.getFirstChild();
				s_(_t);
				_t = _retTree;
				s_(_t);
				_t = _retTree;
				_t = __t228;
				_t = _t.getNextSibling();
				break;
			}
			case AND:
			{
				AST __t229 = _t;
				AST tmp14_AST_in = (AST)_t;
				match(_t,AND);
				_t = _t.getFirstChild();
				s_(_t);
				_t = _retTree;
				s_(_t);
				_t = _retTree;
				_t = __t229;
				_t = _t.getNextSibling();
				break;
			}
			case NOT:
			{
				AST __t230 = _t;
				AST tmp15_AST_in = (AST)_t;
				match(_t,NOT);
				_t = _t.getFirstChild();
				s_(_t);
				_t = _retTree;
				_t = __t230;
				_t = _t.getNextSibling();
				break;
			}
			case EQUAL:
			{
				AST __t231 = _t;
				AST tmp16_AST_in = (AST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				i5_(_t);
				_t = _retTree;
				i5_(_t);
				_t = _retTree;
				_t = __t231;
				_t = _t.getNextSibling();
				break;
			}
			case NEQUAL:
			{
				AST __t232 = _t;
				AST tmp17_AST_in = (AST)_t;
				match(_t,NEQUAL);
				_t = _t.getFirstChild();
				i5_(_t);
				_t = _retTree;
				i5_(_t);
				_t = _retTree;
				_t = __t232;
				_t = _t.getNextSibling();
				break;
			}
			case GE:
			{
				AST __t233 = _t;
				AST tmp18_AST_in = (AST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				i5_(_t);
				_t = _retTree;
				i5_(_t);
				_t = _retTree;
				_t = __t233;
				_t = _t.getNextSibling();
				break;
			}
			case GT:
			{
				AST __t234 = _t;
				AST tmp19_AST_in = (AST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				i5_(_t);
				_t = _retTree;
				i5_(_t);
				_t = _retTree;
				_t = __t234;
				_t = _t.getNextSibling();
				break;
			}
			case LE:
			{
				AST __t235 = _t;
				AST tmp20_AST_in = (AST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				i5_(_t);
				_t = _retTree;
				i5_(_t);
				_t = _retTree;
				_t = __t235;
				_t = _t.getNextSibling();
				break;
			}
			case LT:
			{
				AST __t236 = _t;
				AST tmp21_AST_in = (AST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				i5_(_t);
				_t = _retTree;
				i5_(_t);
				_t = _retTree;
				_t = __t236;
				_t = _t.getNextSibling();
				break;
			}
			case TRUE:
			{
				AST tmp22_AST_in = (AST)_t;
				match(_t,TRUE);
				_t = _t.getNextSibling();
				break;
			}
			case FALSE:
			{
				AST tmp23_AST_in = (AST)_t;
				match(_t,FALSE);
				_t = _t.getNextSibling();
				break;
			}
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				inputActions.add(id);
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void i5_(AST _t) throws RecognitionException {
		
		AST i5__AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CONST_NUM:
			{
				AST tmp24_AST_in = (AST)_t;
				match(_t,CONST_NUM);
				_t = _t.getNextSibling();
				break;
			}
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				inputActions.add(id);
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"TRUE",
		"FALSE",
		"OR",
		"AND",
		"NOT",
		"LPAREN",
		"RPAREN",
		"EQUAL",
		"NEQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"IDENT",
		"CONST_BOOL",
		"CONST_NUM",
		"WS",
		"DIGIT",
		"LETTER",
		"NAME",
		"CONST_BOOL_OR_IDENT"
	};
	
	}
	
