/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol.position;

import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * Before or after execution of included state machine  
 */
public class SubmachinesExecutionPosition extends Position {
    
    private Event event;
    private String state;
    private String subMachine;    
    private boolean before;

    public SubmachinesExecutionPosition(StateMachineContext context, StateMachinePath path, Event event, String state, String subMachine, boolean before) {
        super(context, path);
        
        this.event = event;
        this.state = state;
        this.subMachine = subMachine;
        this.before = before;
    }
    
    public Event getEvent() {
        return event;
    }
    
    /**
     * @param event The event to set.
     */
    public void setEvent(Event event) {
        this.event = event;
    }

    public String getState() {
        return state;
    }
    
    /**
     * @return Returns the subMachine.
     */
    public String getSubMachine() {
        return subMachine;
    }

    public boolean isBefore() {
        return before;
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getContainer(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getContainer(Model m) {
        return CoreContract.decodeState(getStateMachine(m), getState());
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getTarget(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getTarget(Model m) {
        return CoreContract.decodeStateMachine(m, getSubMachine());
    }

    public int hashCode() {
        return super.hashCode() /*^ event.hashCode()*/ ^ state.hashCode() ^ subMachine.hashCode() ^(before ? 1 : 0);
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof SubmachinesExecutionPosition)) {
            return false;
        }
        
        return 
        	super.equals(o) && 
        	//((SubmachinesExecutionPosition)o).getEvent().equals(getEvent()) &&
        	((SubmachinesExecutionPosition)o).getState().equals(getState()) &&
        	((SubmachinesExecutionPosition)o).getSubMachine().equals(getSubMachine()) &&
        	((SubmachinesExecutionPosition)o).isBefore() == isBefore();
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#toString()
     */
    public String toString() {
        return super.toString() + "Execute submachine " + getSubMachine() + " in state " + getState();
    }
}
