/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol.position;

import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * Before or after execution of input action inside guard condition of given transition
 */
public class InputActionExecutionPosition extends ActionExecutionPosition {
    
    private String transition;
    private String value;

    public InputActionExecutionPosition(StateMachineContext context, StateMachinePath path, String transition, String action, boolean before, String value) {
        super(context, path, action, before);
        
        this.transition = transition;
        this.value = value;
    }
    
    public String getTransition() {
        return transition;
    }

    public String getValue() {
        return value;
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getContainer(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getContainer(Model m) {
        return CoreContract.decodeTransition(getStateMachine(m), getTransition());
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getTarget(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getTarget(Model m) {
        return CoreContract.decodeInputAction((Transition)getContainer(m), getAction());
    }

    public int hashCode() {
        return super.hashCode() ^ transition.hashCode();
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof InputActionExecutionPosition)) {
            return false;
        }
        
        return 
        	super.equals(o) && 
        	((InputActionExecutionPosition)o).getTransition().equals(getTransition());
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.ActionExecutionPosition#toString()
     */
    public String toString() {
        return super.toString() + "Execute input action " + getAction() + " on transition " + getTransition();
    }
    
}
