/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol.position;

import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * State machine comes to final state
 */
public abstract class FinalStatePosition extends Position {

    private StateMachineConfig config;

    public FinalStatePosition(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
        super(context, path);
        
        this.config = config;
    }
    
    public StateMachineConfig getConfig() {
        return config;
    }

    public int hashCode() {
        return super.hashCode() ^ config.hashCode();
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof FinalStatePosition)) {
            return false;
        }
        
        return 
        	super.equals(o) && 
        	((FinalStatePosition)o).getConfig().equals(getConfig());
    }
    
}
