/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol.position;

import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;


abstract public class ActionExecutionPosition extends Position {
    private String action;
    private boolean before;

    public ActionExecutionPosition(StateMachineContext context, StateMachinePath path, String action, boolean before) {
        super(context, path);
        this.action = action;
        this.before = before;
    }
    
    public String getAction() {
        return action;
    }

    public boolean isBefore() {
        return before;
    }

    public int hashCode() {
        return super.hashCode() ^ action.hashCode() ^ (before ? 1 : 0);
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof ActionExecutionPosition)) {
            return false;
        }
        
        return 
        	super.equals(o) && 
        	((ActionExecutionPosition)o).getAction().equals(getAction()) &&
        	((ActionExecutionPosition)o).isBefore() == isBefore();
    }
   
}
