/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol;

import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.debug.protocol.position.Position;

/**
 * Command messages are sent by debugger host to engine being debugged
 * Possible commands: set breakpoints, remove breakpoints, make step, resume, upload new model   
 */
public class CommandMessage extends Message {

    public static final int SET_BREAKPOINTS = 1;    
    public static final int REMOVE_BREAKPOINTS = 2;    
    public static final int STEP = 3;    
    public static final int RESUME = 4;    
    public static final int UPLOAD_NEW_MODEL = 5;
    
    private Position[] breakpoints;
    private Model newModel;
    
    private CommandMessage(int type, Position[] breakpoints, ThreadInfo thread, Model newModel) {
        super(type, thread);
        this.breakpoints = breakpoints;
        this.newModel = newModel;
    }
    
    public Position[] getBreapoints() {
        return breakpoints;
    }

	public Model getNewModel() {
		return newModel;
	}
    
    public static final CommandMessage createSetBreakpoints(Position[] breakpoints) {
        return new CommandMessage(SET_BREAKPOINTS, breakpoints, null, null);
    }

    public static final CommandMessage createRemoveBreakpoints(Position[] breakpoints) {
        return new CommandMessage(REMOVE_BREAKPOINTS, breakpoints, null, null);
    }
    
    public static final CommandMessage createStep(ThreadInfo thread) {
        return new CommandMessage(STEP, null, thread, null);
    }
    
    public static final CommandMessage createResume(ThreadInfo thread) {
        return new CommandMessage(RESUME, null, thread, null);
    }

    public static final CommandMessage createUploadNewModel(Model newModel) {
        return new CommandMessage(UPLOAD_NEW_MODEL, null, null, newModel);
    }

}