/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.debugger;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.debug.Params;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.EventProvider;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * @author vgurov
 */
public interface BreakpointManager extends EventProvider, ControlledObject {

    /**
     * Must have associated parameter with name {@link Params.Event#BREAKPOINTS} with
     * value as array of {@link com.evelopers.unimod.debug.protocol.position.Position}
	* @unimod.event.descr breakpoints added
	*/
	public static final String E21 = "e21";

	/**
     * Must have associated parameter with name {@link Params.Event#BREAKPOINTS} with
     * value as array of {@link com.evelopers.unimod.debug.protocol.position.Position}
	* @unimod.event.descr breakpoints removed
	*/
	public static final String E22 = "e22";

 	/**
 	 * Must put into event context array of {@link com.evelopers.unimod.debug.protocol.position.Position} with
 	 * name {@link Params.Event#BREAKPOINTS}
 	 * 
	 *@unimod.action.descr get all breakpoints
	 */
	public void z1(StateMachineContext context) throws CommonException;

}
