/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.app;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import com.evelopers.unimod.debug.Params;
import com.evelopers.unimod.debug.protocol.position.Position;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**

 */
public class BreakpointManager implements ControlledObject {

    private Set breakpoints = new HashSet();
    
    private boolean mustSuspend;
    
    BreakpointManager(boolean mustSuspend) {
        this.mustSuspend = mustSuspend;
    }
    
	/**
	*@unimod.action.descr set breakpoints
	*/
	public void z1(StateMachineContext context) {
		Position[] b = (Position[])context.getEventContext().getParameter(Params.Event.BREAKPOINTS);

		breakpoints.addAll(Arrays.asList(b));
	}

	/**
	*@unimod.action.descr remove breakpoints
	*/
	public void z2(StateMachineContext context) {
		Position[] b = (Position[])context.getEventContext().getParameter(Params.Event.BREAKPOINTS);

		breakpoints.removeAll(Arrays.asList(b));
	}

	/**
	*@unimod.action.descr must suspend on breakpoint
	*/
	public boolean x1(StateMachineContext context) {
		Position b = (Position)context.getEventContext().getParameter(Params.Event.POSITION);
		
		if (b == null) {
		    return false;
		}
		
	    return breakpoints.contains(b);
	}

	/**
	*@unimod.action.descr remove all breakpoints
	*/
	public void z3(StateMachineContext context) {
		breakpoints.clear();
	}

	/**
	*@unimod.action.descr must wait for debugger connect
	*/
	public boolean x2(StateMachineContext context) {
		return mustSuspend;
	}

}
