/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug;

import java.util.HashMap;
import java.util.Map;

import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachineConfigManager;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * Uses ThreadInfo as statemachine config key.
 * If ThreadInfo can't be determined - does nothing
 * 
 * @author vgurov
 */
public class ThreadConfigManager implements StateMachineConfigManager {
    
    private Map configs = new HashMap();
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#load()
     */
    public void onEnter(StateMachinePath path) {
        configs.clear();
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#unload()
     */
    public void onExit(StateMachinePath path) {
        configs.clear();
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#init(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext, com.evelopers.unimod.runtime.StateMachineConfig)
     */
    public void init(StateMachinePath path, StateMachineContext context,
            StateMachineConfig initialConfig) {

        store(path, context, initialConfig);        
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#load(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext)
     */
    public StateMachineConfig load(StateMachinePath path,
            StateMachineContext context) {
        
        ThreadInfo ti = getThreadInfo(context);
        
        // if ti == null => statemachine called with event that has no associated thread info
        // this statemachine is not intended to process such event - return null
        if (ti == null) {
            return null;
        }
        
        return (StateMachineConfig)configs.get(ti);
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#store(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext, com.evelopers.unimod.runtime.StateMachineConfig)
     */
    public void store(StateMachinePath path, StateMachineContext context,
            StateMachineConfig config) {

        ThreadInfo ti = getThreadInfo(context);
        
        if (ti == null) {
            return;
        }
        
        configs.put(ti, config);        
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#dispose(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext, com.evelopers.unimod.runtime.StateMachineConfig)
     */
    public void dispose(StateMachinePath path, StateMachineContext context,
            StateMachineConfig finalConfig) {

        ThreadInfo ti = getThreadInfo(context);

        if (ti == null) {
            return;
        }
        
        configs.remove(ti);
    }
    
    public void resetAllThreadConfigs() {
        configs.clear();
    }

    private ThreadInfo getThreadInfo(StateMachineContext context) {
        return (ThreadInfo)context.getEventContext().getParameter(Params.Event.THREAD_INFO);
    }
    
}
